/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasoft.print.core;

import br.com.maximasolutions.core.MaximaException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;

public class ImpressoraSpooler {
    public void imprime(String nomeImpressora, String texto) throws MaximaException {
        PrintService impressora = this.getImpressora(nomeImpressora);
        ByteArrayInputStream pis = new ByteArrayInputStream(texto.getBytes());
        DocFlavor.INPUT_STREAM df = DocFlavor.INPUT_STREAM.AUTOSENSE;
        SimpleDoc d = new SimpleDoc(pis, df, null);
        DocPrintJob job = impressora.createPrintJob();
        try {
            job.print(d, null);
        }
        catch (PrintException e) {
            throw new MaximaException("Ocorreu um erro ao efetuar impress\u00e3o [" + nomeImpressora + "].\n" + e.getLocalizedMessage());
        }
    }

    public PrintService getImpressora(String nomeImpressora) throws MaximaException {
        PrintService impressora = null;
        PrintService[] pservices = PrinterJob.lookupPrintServices();
        if (pservices.length > 0) {
            for (PrintService ps : pservices) {
                if (!ps.getName().equalsIgnoreCase(nomeImpressora)) continue;
                impressora = ps;
                break;
            }
        }
        if (impressora == null) {
            throw new MaximaException("AVISO: Impressora n\u00e3o instalada corretamente.");
        }
        return impressora;
    }
}

