/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions;

import br.com.maximasolutions.Main;
import br.com.maximasolutions.MyPreloader;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.estoque.controller.PDVFormController;
import br.com.maximasolutions.estoque.controller.PDVTouchController;
import br.com.maximasolutions.estoque.controller.PDVVendedorFormController;
import br.com.maximasolutions.estoque.controller.PedidoVendaConstrucaoFormController;
import br.com.maximasolutions.estoque.controller.PedidoVendaFormController;
import br.com.maximasolutions.estoque.dino.controller.PDVDinoController;
import br.com.maximasolutions.sat.controller.CupomFiscalFormController;
import br.com.maximasolutions.view.FxmlView;
import com.sun.javafx.application.LauncherImpl;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

public class Projeto
extends Application {
    protected ConfigurableApplicationContext springContext;
    protected StageManager stageManager;
    private static int stepCount = 1;
    int stateWindow = 1;

    protected void displayInitialScene() {
        this.stageManager.setGetHostController(this.getHostServices());
        this.stageManager.switchScene(FxmlView.LOGIN);
    }

    private void PDVDino() {
        try {
            Stage stage = new MaximaDialogFX().createFrameVBox(this.stageManager, "/fxml/estoque/vendaProduto/dino/PDVDino.fxml", "FRENTE DE CAIXA - M\u00c1XIMA SOFT", new String[0]);
            PDVDinoController controller = (PDVDinoController)stage.getUserData();
            controller.inicializaForm(stage.getScene());
            stage.setMaximized(true);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void PDVTouch() {
        try {
            Stage stage = new MaximaDialogFX().createFrameVBox(this.stageManager, "/fxml/estoque/vendaProduto/PDVTouch.fxml", "FRENTE DE CAIXA - M\u00c1XIMA SOFT", new String[0]);
            PDVTouchController controller = (PDVTouchController)stage.getUserData();
            controller.inicializaForm(stage.getScene());
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void CupomSAT() {
        try {
            Stage stage = new MaximaDialogFX().createFrame(this.stageManager, "/fxml/fiscal/CupomSatForm.fxml", "EMISSOR CUPOM SAT");
            CupomFiscalFormController controller = (CupomFiscalFormController)stage.getUserData();
            controller.inicializa();
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void PDV() {
        try {
            String css = MaximaConfig.getInstance().getProperty("pdv_css", "pdv.css");
            Stage stage = new MaximaDialogFX().createFrameVBox(this.stageManager, "/fxml/estoque/vendaProduto/PDVForm.fxml", "FRENTE DE CAIXA - M\u00c1XIMA SOFT", new String[]{css});
            PDVFormController controller = (PDVFormController)stage.getUserData();
            stage.setOnShown(evt -> controller.inicializaPDV(stage.getScene()));
            stage.setMaximized(true);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void PDVVendedor() {
        try {
            Stage stage = new MaximaDialogFX().createFrameVBox(this.stageManager, "/fxml/estoque/vendaProduto/PDVVendedorForm.fxml", "FRENTE DE CAIXA - M\u00c1XIMA SOFT", new String[]{"pdv_vendedor.css"});
            PDVVendedorFormController controller = (PDVVendedorFormController)stage.getUserData();
            stage.setOnShown(evt -> controller.inicializaPDV(stage.getScene()));
            stage.setMaximized(true);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void pedidoZorzanForm() {
        try {
            Stage stage = new MaximaDialogFX().createFrameVBox(this.stageManager, "/fxml/estoque/vendaProduto/PedidoVendaForm.fxml", "PEDIDO - M\u00c1XIMA SOFT", new String[]{"Styles.css"});
            PedidoVendaFormController controller = (PedidoVendaFormController)stage.getUserData();
            controller.inicializaPedido();
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void pedidoForm() {
        try {
            Stage stage = new MaximaDialogFX().createFrameVBox(this.stageManager, "/fxml/estoque/vendaProduto/PedidoVendaConstrucaoForm.fxml", "PEDIDO - M\u00c1XIMA ERP", new String[0]);
            PedidoVendaConstrucaoFormController controller = (PedidoVendaConstrucaoFormController)stage.getUserData();
            controller.atalhos(stage.getScene());
            controller.inicializaPedido();
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }

    private void sincronizacaoForm() {
        try {
            Stage stage = new MaximaDialogFX().createFrame(this.stageManager, "/fxml/Sincronizacao.fxml", "PEDIDO - M\u00c1XIMA ERP");
            if (!SystemTray.isSupported()) {
                System.out.println("SystemTray is not supported");
                return;
            }
            URL url = Projeto.class.getResource("/img/icone_16.png");
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            TrayIcon trayIcon = new TrayIcon(image, "M\u00e1xima ERP - Sincroniza\u00e7\u00e3o");
            SystemTray tray = SystemTray.getSystemTray();
            trayIcon.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                System.out.println("TrayIcon could not be added.");
            }
            stage.setTitle("M\u00e1xima SOFT - Sincroniza\u00e7\u00e3o");
            Platform.setImplicitExit((boolean)false);
            stage.show();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de sincroniza\u00e7\u00e3o");
        }
    }

    public static String STEP() {
        return stepCount++ + ". ";
    }

    public static void main(String[] args) {
        LauncherImpl.launchApplication(Projeto.class, MyPreloader.class, (String[])args);
    }

    public void init() throws Exception {
        this.springContext = this.springBootApplicationContext();
    }

    public void start(Stage stage) throws Exception {
        javafx.scene.image.Image image = new javafx.scene.image.Image("/images/icone.png");
        stage.getIcons().add((Object)image);
        this.stageManager = (StageManager)this.springContext.getBean(StageManager.class, new Object[]{stage});
        this.displayInitialScene();
    }

    public void stop() throws Exception {
        this.springContext.close();
    }

    private ConfigurableApplicationContext springBootApplicationContext() {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{Main.class});
        String[] args = (String[])this.getParameters().getRaw().stream().toArray(String[]::new);
        Properties properties = new Properties();
        System.out.println("==================== PROPERTIES =====================");
        if (MaximaConfig.getInstance().getProperty("banco_atualizar", "n").equalsIgnoreCase("s")) {
            properties.put("spring.jpa.properties.hibernate.hbm2ddl.auto", "update");
            properties.put("spring.jpa.generate-ddl", "true");
            properties.put("spring.jpa.hibernate.ddl-auto", "true");
        } else {
            properties.put("spring.jpa.properties.hibernate.hbm2ddl.auto", "none");
        }
        builder.properties(properties);
        return builder.run(args);
    }
}

