/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.modelo.Usuario;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class AutorizacaoFormController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnLogin;
    @FXML
    private PasswordField password;
    @FXML
    private TextField username;
    @FXML
    private Label lblLogin;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Boolean autorizado = false;

    public void inicializa() {
        this.autorizado = false;
    }

    public boolean getAurotizado() {
        return this.autorizado;
    }

    private void efetuaLogin() {
        Usuario usuario = this.usuarioService.authenticate(this.getUsername(), this.getPassword());
        if (usuario != null) {
            if (usuario.getPerfil().getNome().contains("ADMIN")) {
                this.autorizado = true;
            }
            this.fecha();
        } else {
            this.lblLogin.setText("Usu\u00e1rio e/ou senha inv\u00e1lidos.");
        }
    }

    private void fecha() {
        Stage form = (Stage)this.btnLogin.getScene().getWindow();
        form.close();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public String getUsername() {
        return this.username.getText();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.registraAcoes();
    }

    private void registraAcoes() {
        this.btnLogin.setOnAction(t -> this.efetuaLogin());
        this.username.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.password.requestFocus();
                this.password.selectAll();
            }
        });
        this.password.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.efetuaLogin();
            }
        });
    }
}

