/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.service.EmpresaService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.MunicipioPesquisaController;
import br.com.maximasolutions.geral.modelo.Empresa;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EmpresaFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EmpresaService empresaService;
    @Autowired
    private MunicipioService municipioService;
    private Empresa empresa;
    private Municipio municipio;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfRazaoSocial;
    @FXML
    private TextField tfNomeFantasia;
    @FXML
    private TextField tfCnpj;
    @FXML
    private TextField tfInscEstadual;
    @FXML
    private TextField tfInscMunicipal;
    @FXML
    private TextField tfEndereco;
    @FXML
    private TextField tfEnderecoNumero;
    @FXML
    private TextField tfBairro;
    @FXML
    private TextField tfCep;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfMunicipioCodigo;
    @FXML
    private TextField tfMunicipioDescricao;
    @FXML
    private TextField tfEmail;
    @FXML
    private ComboBox<NFRegimeTributario> cbbRegimeTributario;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnMunicipio;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
        this.loadEmpresa();
    }

    private void loadEmpresa() {
        this.empresa = this.empresaService.load();
        if (this.empresa != null) {
            this.tfId.setText(this.empresa.getId().toString());
            this.cbbRegimeTributario.getSelectionModel().select((Object)this.empresa.getRegime());
            this.tfRazaoSocial.setText(this.empresa.getNome());
            this.tfNomeFantasia.setText(this.empresa.getFantasia());
            this.tfTelefone.setText(this.empresa.getTelefone());
            this.tfCnpj.setText(this.empresa.getCpf());
            this.tfInscEstadual.setText(this.empresa.getRg());
            this.tfInscMunicipal.setText(this.empresa.getInscMunicipal());
            this.tfEndereco.setText(this.empresa.getEndereco());
            this.tfEnderecoNumero.setText(this.empresa.getNumero());
            this.tfBairro.setText(this.empresa.getBairro());
            this.tfCep.setText(this.empresa.getCep());
            if (this.empresa.getMunicipio() != null) {
                this.tfMunicipioCodigo.setText(this.empresa.getMunicipio().getId().toString());
                this.tfMunicipioDescricao.setText(this.empresa.getMunicipio().getNome() + " - " + this.empresa.getMunicipio().getEstado().getSigla());
            }
            this.tfEmail.setText(this.empresa.getEmail());
            this.municipio = this.empresa.getMunicipio();
        } else {
            this.empresa = new Empresa();
            this.municipio = null;
        }
    }

    private void save() {
        this.empresa.setNome(this.tfRazaoSocial.getText());
        this.empresa.setFantasia(this.tfNomeFantasia.getText());
        this.empresa.setTelefone(MaximaUtils.removeCaracteres((String)this.tfTelefone.getText()));
        this.empresa.setCpf(MaximaUtils.removeCaracteres((String)this.tfCnpj.getText()));
        this.empresa.setRg(MaximaUtils.removeAcentos((String)this.tfInscEstadual.getText()));
        this.empresa.setInscMunicipal(MaximaUtils.removeCaracteres((String)this.tfInscMunicipal.getText()));
        this.empresa.setEndereco(this.tfEndereco.getText());
        this.empresa.setNumero(this.tfEnderecoNumero.getText());
        this.empresa.setBairro(this.tfBairro.getText());
        this.empresa.setCep(MaximaUtils.removeCaracteres((String)this.tfCep.getText()));
        this.empresa.setRegime((NFRegimeTributario)this.cbbRegimeTributario.getSelectionModel().getSelectedItem());
        this.empresa.setMunicipio(this.municipio);
        this.empresa.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.empresa = this.empresaService.save(this.empresa);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados da empresa salvos com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(EmpresaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: n\u00e3o foi poss\u00edvel salvar dados da empresa.\n" + ex.getMessage()));
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.empresa.getNome() == null || this.empresa.getNome().isEmpty()) {
            this.tfRazaoSocial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfRazaoSocial.getStyleClass().remove((Object)"error");
        }
        if (this.empresa.getTelefone() == null || this.empresa.getTelefone().isEmpty()) {
            valido = false;
            this.tfTelefone.getStyleClass().add((Object)"error");
        } else {
            this.tfTelefone.getStyleClass().remove((Object)"error");
        }
        if (this.empresa.getMunicipio() == null) {
            valido = false;
            this.tfMunicipioCodigo.getStyleClass().add((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().add((Object)"error");
        } else {
            this.tfMunicipioCodigo.getStyleClass().remove((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.empresa, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }

    private void loadDadosMunicipio() {
        if (this.municipio != null) {
            this.tfMunicipioCodigo.setText(this.municipio.getId().toString());
            this.tfMunicipioDescricao.setText(this.municipio.getNome().toUpperCase() + " - " + this.municipio.getEstado().getSigla());
        } else {
            this.tfMunicipioCodigo.setText("");
            this.tfMunicipioDescricao.setText("");
            this.tfMunicipioCodigo.requestFocus();
        }
    }

    private void pesquisaMunicipio() {
        String municipioCodigo = this.tfMunicipioCodigo.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioForm();
    }

    private void pesquisaMunicipioForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigo.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnMunicipio.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void loadCombos() {
        this.cbbRegimeTributario.setItems(FXCollections.observableArrayList((Object[])NFRegimeTributario.values()));
    }

    private void setMascaras() {
        MaximaMask.cnpjField((TextField)this.tfCnpj);
        MaximaMask.cepField((TextField)this.tfCep);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
        this.btnMunicipio.setOnAction(event -> this.pesquisaMunicipioForm());
        this.tfMunicipioCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipio();
            }
        });
    }
}

