/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class SenhaFormController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnLogin;
    @FXML
    private Button btnFechar;
    @FXML
    private PasswordField password;
    @FXML
    private Label mensagemLabel;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Boolean fechamentoCaixa;
    private Boolean autorizado;

    public void inicializa() {
        this.fechamentoCaixa = false;
        this.autorizado = false;
        this.password.requestFocus();
    }

    public void setFechamentoCaixa(Boolean valor) {
        this.fechamentoCaixa = valor;
    }

    public Boolean getAutorizado() {
        return this.autorizado;
    }

    private void efetuaLogin() {
        String senha = this.password.getText();
        if (senha == null || senha.isEmpty()) {
            this.mensagemLabel.setText("Senha inv\u00e1lida!!!");
            this.password.requestFocus();
            return;
        }
        Configuracao configuracao = this.configuracaoService.load();
        if (this.fechamentoCaixa.booleanValue()) {
            if (senha.equalsIgnoreCase(configuracao.getSenhaFechamentoCaixa())) {
                this.autorizado = true;
                this.fecha();
                return;
            }
        } else if (senha.equalsIgnoreCase(configuracao.getCancelamentoSenha())) {
            this.autorizado = true;
            this.fecha();
            return;
        }
        this.mensagemLabel.setText("Senha inv\u00e1lida!!!");
        this.password.requestFocus();
    }

    private void fecha() {
        Stage form = (Stage)this.btnLogin.getScene().getWindow();
        form.close();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.registraAcoes();
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnLogin.setOnAction(t -> this.efetuaLogin());
        this.btnFechar.setOnAction(evt -> this.fecha());
        this.password.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.efetuaLogin();
            }
        });
    }
}

