/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.controller;

import br.com.maximasolutions.administrativo.controller.UsuarioFormController;
import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.modelo.Usuario;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class UsuarioController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<Usuario> tabela;
    @FXML
    private TableColumn<Usuario, String> colNome;
    @FXML
    private TableColumn<Usuario, String> colLogin;
    @FXML
    private TableColumn<Usuario, String> colPermissao;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Usuario> usuarioList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.usuarioList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Usuario);
    }

    private void novoUsuario() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formUsuario(null);
        this.loadTabela();
    }

    private void editaUsuario() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Usuario usuario = (Usuario)this.tabela.getSelectionModel().getSelectedItem();
        if (usuario == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um usu\u00e1rio para editar.");
            return;
        }
        this.formUsuario(usuario);
        this.loadTabela();
    }

    private void formUsuario(Usuario usuario) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/administrativo/usuario/UsuarioForm.fxml", "Novo Usu\u00e1rio");
            UsuarioFormController controller = (UsuarioFormController)stage.getUserData();
            controller.inicializa(usuario);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(UsuarioController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form usu\u00e1rio.\n" + ex.getMessage()));
        }
    }

    private void deleteUsuario() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Usuario usuario = (Usuario)this.tabela.getSelectionModel().getSelectedItem();
        if (usuario == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um usu\u00e1rio para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o usu\u00e1rio: '" + usuario.getNome() + "'?"))) {
            this.usuarioService.deleteById(usuario.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Usu\u00e1rio deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.usuarioList.clear();
        this.usuarioList.addAll((Collection)this.usuarioService.list());
        this.tabela.setItems(this.usuarioList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colLogin.setCellValueFactory((Callback)new PropertyValueFactory("login"));
        this.colPermissao.setCellValueFactory((Callback)new PropertyValueFactory("permissao"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoUsuario());
        this.btnEdita.setOnAction(event -> this.editaUsuario());
        this.btnDelete.setOnAction(event -> this.deleteUsuario());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaUsuario();
            }
        });
    }
}

