/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.administrativo.service.ManutencaoService;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrima;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrimaItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.repository.EntradaMateriaPrimaItemRepository;
import br.com.maximasolutions.estoque.repository.EntradaMateriaPrimaRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.repository.CentroCustoRepository;
import br.com.maximasolutions.financeiro.repository.ContaPagarParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepository;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.repository.ClienteRepository;
import br.com.maximasolutions.geral.repository.FornecedorRepository;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.repository.PedidoItemVendaExternaRepository;
import br.com.maximasolutions.vendasexternas.repository.PedidoVendaExternaRepository;
import br.com.maximasolutions.vendasexternas.repository.VendedorProdutoRepository;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class ManutencaoServiceImpl
implements ManutencaoService {
    @Autowired
    private PedidoVendaExternaRepository pedidoVendaExternaRepository;
    @Autowired
    private PedidoItemVendaExternaRepository pedidoItemVendaExternaRepository;
    @Autowired
    private FornecedorRepository fornecedorRepository;
    @Autowired
    private VendedorProdutoRepository vendedorProdutoRepository;
    @Autowired
    private ContaPagarParcelaRepository contaPagarParcelaRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private MovimentacaoEntradaRepository movimentacaoEntradaRepository;
    @Autowired
    private CentroCustoRepository centroCustoRepository;
    @Autowired
    private EntradaMateriaPrimaRepository entradaMateriaPrimaRepository;
    @Autowired
    private EntradaMateriaPrimaItemRepository entradaMateriaPrimaItemRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private ClienteRepository clienteRepository;

    public void atualizaBD() {
        this.fornecedorRepository.setAtivo();
        this.vendaProdutoRepository.setFinalizada();
        this.pedidoVendaExternaRepository.setExcluido();
        this.movimentacaoEntradaRepository.atualizaValorLiquido();
        this.centroCustoRepository.setAtivos();
        this.atualizaMateriaPrima();
        this.atualizaProdutos();
        this.atualizaVendas();
    }

    private void atualizaMateriaPrima() {
        List entradas = this.entradaMateriaPrimaRepository.manutencao();
        for (EntradaMateriaPrima emp : entradas) {
            if (emp.getBaseCalculoIcms() != null && emp.getBaseCalculoIcms().compareTo(BigDecimal.ZERO) > 0) continue;
            emp.setBaseCalculoIcms(emp.getValorProdutos());
            List itens = this.entradaMateriaPrimaItemRepository.lista(emp.getId().longValue());
            BigDecimal valorIcms = BigDecimal.ZERO;
            for (EntradaMateriaPrimaItem i : itens) {
                BigDecimal icms = BigDecimal.ZERO;
                if (i.getCsosn() != null) {
                    i.setCst(NFNotaInfoImpostoTributacaoICMS.TRIBUTACAO_INTEGRALMENTE);
                    i.setBaseCalculoIcms(i.getTotalCusto());
                    i.setValorIcms(i.getValorCreditoIcms());
                    i.setAliquotaIcms(i.getAliquotaIcms());
                    icms = i.getValorCreditoIcms();
                    this.entradaMateriaPrimaItemRepository.save((Object)i);
                }
                if (i.getValorIcms() == null) continue;
                valorIcms = valorIcms.add(icms);
            }
            emp.setValorIcms(valorIcms);
            this.entradaMateriaPrimaRepository.save((Object)emp);
        }
        System.out.println(" === Entrada materia prima atualizada: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
    }

    private void atualizaContasReceber() {
        int atualizacoesContaReceber = 1;
        int tamanho = 1000;
        int cont = 0;
        while (atualizacoesContaReceber > 0) {
            PageRequest pageable = PageRequest.of((int)cont, (int)tamanho, (Sort)Sort.by((String[])new String[]{"id"}));
            List parcelas = this.contaReceberParcelaRepository.listaAtualizacoes((Pageable)pageable);
            for (ContaReceberParcela crp : parcelas) {
                crp.setCentroCusto(crp.getContaReceber().getCentroCusto());
                crp.setCliente(crp.getContaReceber().getCliente());
                crp.setExcluido(Boolean.valueOf(false));
                this.contaReceberParcelaRepository.save((Object)crp);
            }
            ++cont;
            atualizacoesContaReceber = parcelas.size();
        }
        System.out.println(" === Contas a receber atualizadas: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
    }

    private void atualizaContasPagar() {
        Long atualizacoesContaPagar = this.contaPagarParcelaRepository.quantidadeAtualizacoes();
        if (atualizacoesContaPagar > 0L) {
            List parcelas = this.contaPagarParcelaRepository.listaAtualizacoes();
            for (ContaPagarParcela cpp : parcelas) {
                cpp.setCentroCusto(cpp.getContaPagar().getCentroCusto());
                if (cpp.getContaPagar().getFornecedor() == null) continue;
                cpp.setFornecedor(cpp.getContaPagar().getFornecedor());
                cpp.setExcluido(Boolean.valueOf(false));
                this.contaPagarParcelaRepository.save((Object)cpp);
            }
        }
        System.out.println(" === Contas a pagar atualizadas: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
    }

    private void atualizaProdutos() {
        int numeroProdutos = 1;
        int cont = 0;
        while (numeroProdutos > 0) {
            PageRequest pageable = PageRequest.of((int)cont, (int)100);
            List produtos = this.produtoRepository.lista((Pageable)pageable);
            for (Produto produto : produtos) {
                if (produto.getUltimoCusto().compareTo(produto.getPrecoVenda()) <= 0 || produto.getFatorConversaoEntrada() == null || produto.getFatorConversaoEntrada().compareTo(BigDecimal.ZERO) <= 0) continue;
                produto.setUltimoCusto(produto.getUltimoCusto().divide(produto.getFatorConversaoEntrada(), 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN));
                this.produtoRepository.save((Object)produto);
            }
            numeroProdutos = produtos.size();
            ++cont;
        }
        System.out.println(" === Produtos atualizadas: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
    }

    private void atualizaVendas() {
        int numeroVendas = 1;
        int cont = 0;
        while (numeroVendas > 0) {
            PageRequest pageable = PageRequest.of((int)cont, (int)100);
            List vendas = this.vendaProdutoRepository.listaAtualizacao(MaximaDate.convertToLocalDate((String)"01/01/2000"), (Pageable)pageable);
            for (VendaProduto venda : vendas) {
                if (venda.getCustoProdutos() != null && venda.getCustoProdutos().compareTo(venda.getValorProdutos()) < 0) continue;
                BigDecimal custoProdutos = BigDecimal.ZERO;
                BigDecimal custoServicos = BigDecimal.ZERO;
                BigDecimal custoTotal = BigDecimal.ZERO;
                BigDecimal valorPecas = BigDecimal.ZERO;
                BigDecimal valorServicos = BigDecimal.ZERO;
                List itens = this.vendaProdutoItemRepository.listaPorVenda(venda.getId().longValue());
                for (VendaProdutoItem item : itens) {
                    if (!item.getProduto().getServico().booleanValue()) {
                        if (item.getPrecoCusto() == null || item.getPrecoCusto().compareTo(BigDecimal.ZERO) <= 0 || item.getPrecoCusto().compareTo(item.getProduto().getPrecoVenda()) > 0) {
                            item.setPrecoCusto(item.getProduto().getUltimoCusto());
                        }
                        item.setServicoCusto(BigDecimal.ZERO);
                        valorPecas = valorPecas.add(item.getPrecoTotal());
                    } else {
                        if (item.getServicoCusto() == null || item.getServicoCusto().compareTo(BigDecimal.ZERO) <= 0) {
                            item.setServicoCusto(item.getProduto().getUltimoCusto());
                        }
                        item.setPrecoCusto(BigDecimal.ZERO);
                        valorServicos = valorServicos.add(item.getPrecoTotal());
                    }
                    if (item.getServicoCusto() == null) {
                        item.setServicoCusto(BigDecimal.ZERO);
                    }
                    if (item.getPrecoCusto() == null) {
                        item.setPrecoCusto(BigDecimal.ZERO);
                    }
                    item = (VendaProdutoItem)this.vendaProdutoItemRepository.save((Object)item);
                    this.vendaProdutoItemRepository.flush();
                    custoTotal = custoTotal.add(item.getCustoTotal());
                    custoProdutos = custoProdutos.add(item.getCustoTotalProdutos());
                    custoServicos = custoServicos.add(item.getCustoTotalServicos());
                }
                venda.setCustoProdutos(custoProdutos);
                venda.setCustoServicos(custoServicos);
                venda.setCustoTotal(custoTotal);
                if (venda.getValorPecas() == null || venda.getValorPecas().compareTo(BigDecimal.ZERO) == 0) {
                    venda.setValorPecas(valorPecas);
                }
                if (venda.getValorServico() == null || venda.getValorServico().compareTo(BigDecimal.ZERO) == 0) {
                    venda.setValorServico(valorServicos);
                }
                venda = (VendaProduto)this.vendaProdutoRepository.save((Object)venda);
                this.vendaProdutoRepository.flush();
                if (venda.getCustoTotal().compareTo(venda.getTotal()) <= 0) continue;
                System.out.println("== venda: " + venda.getId());
            }
            ++cont;
            numeroVendas = vendas.size();
        }
        System.out.println(" === Vendas atualizadas: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
    }

    private void importa() {
        try {
            BufferedReader buffRead = new BufferedReader(new FileReader("C:/Maxima/clientes.txt"));
            String linha = "";
            int cont = 0;
            Configuracao conf = this.configuracaoRepository.load();
            while ((linha = buffRead.readLine()) != null && !linha.isEmpty()) {
                String[] dados = linha.split(";");
                if (dados.length != 6) continue;
                String nome = dados[1];
                String endereco = dados[2];
                String numero = dados[3];
                String bairro = dados[4];
                String fone = dados[5];
                if (nome.isEmpty() || endereco.isEmpty() || numero.isEmpty() || fone.isEmpty()) continue;
                Cliente cliente = new Cliente();
                cliente.setAtivo(Boolean.TRUE);
                cliente.setBairro(MaximaUtils.getText((String)bairro.toUpperCase()));
                cliente.setCpf("");
                cliente.setDataCadastro(LocalDate.now());
                cliente.setEndereco(MaximaUtils.getText((String)endereco.toUpperCase()));
                cliente.setLimite(new BigDecimal(300));
                cliente.setMunicipio(conf.getEmpresaNFe().getMunicipio());
                cliente.setNegativado(Boolean.FALSE);
                cliente.setNome(MaximaUtils.getText((String)nome.toUpperCase()));
                cliente.setNumero(MaximaUtils.getText((String)numero.toUpperCase()));
                cliente.setTelefone(MaximaUtils.getText((String)fone));
                cliente = (Cliente)this.clienteRepository.save((Object)cliente);
                System.out.println(cliente.getId() + ": " + cliente.getNome());
                ++cont;
            }
            buffRead.close();
            System.out.println("Total = " + cont);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ManutencaoServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ManutencaoServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

