/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.core;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.controller.ProgressController;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class MaximaDialogFX {
    public Stage createWindowForm(StageManager stageManager, String fxml, String titulo) throws IOException {
        FXMLLoader loader = stageManager.loader(fxml);
        AnchorPane content = (AnchorPane)loader.load();
        Scene scene = new Scene((Parent)content);
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/Styles.css").toExternalForm());
        MaximaController controller = (MaximaController)loader.getController();
        controller.inicializa();
        Stage stage = new Stage();
        stage.setResizable(false);
        stage.setTitle(titulo);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.DECORATED);
        stage.initOwner((Window)stageManager.getStage());
        stage.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                stage.close();
            }
        });
        stage.setScene(scene);
        return stage;
    }

    public Stage createWindowUndecaredForm(StageManager stageManager, String fxml, String titulo) throws IOException {
        FXMLLoader loader = stageManager.loader(fxml);
        AnchorPane content = (AnchorPane)loader.load();
        Scene scene = new Scene((Parent)content);
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/Styles.css").toExternalForm());
        MaximaController controller = (MaximaController)loader.getController();
        controller.inicializa();
        Stage stage = new Stage();
        stage.setTitle(titulo);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner((Window)stageManager.getStage());
        stage.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                stage.close();
            }
        });
        stage.setScene(scene);
        return stage;
    }

    public Stage createWindowUndecaredForm_(StageManager stageManager, Stage componentePai, String fxml, String titulo) throws IOException {
        VBox pane = new VBox();
        pane.setPrefWidth(componentePai.getWidth());
        pane.setPrefHeight(componentePai.getHeight());
        pane.setLayoutX(0.0);
        pane.setLayoutY(0.0);
        pane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.8);");
        pane.setAlignment(Pos.CENTER);
        FXMLLoader loader = stageManager.loader(fxml);
        AnchorPane content = (AnchorPane)loader.load();
        if (pane.getPrefWidth() < content.getPrefWidth()) {
            pane.setPrefWidth(content.getPrefWidth());
            pane.setPrefHeight(content.getPrefHeight());
        }
        pane.getChildren().add((Object)content);
        Scene scene = new Scene((Parent)pane);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/Styles.css").toExternalForm());
        MaximaController controller = (MaximaController)loader.getController();
        controller.inicializa();
        Stage stage = new Stage();
        stage.setTitle(titulo);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(scene);
        stage.initOwner((Window)componentePai);
        stage.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                stage.close();
            }
        });
        this.centerChildWindowOnStage(stage, componentePai);
        return stage;
    }

    public Stage createWindowUndecaredForm_(StageManager stageManager, Stage componentePai) throws IOException {
        Pane pane = new Pane();
        pane.setPrefWidth(componentePai.getWidth() - 50.0);
        pane.setPrefHeight(componentePai.getHeight() - 50.0);
        pane.setLayoutX(0.0);
        pane.setLayoutY(0.0);
        pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#F00"), CornerRadii.EMPTY, Insets.EMPTY)}));
        Scene scene = new Scene((Parent)pane);
        scene.setFill((Paint)Color.TRANSPARENT);
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.setScene(scene);
        stage.setWidth(componentePai.getWidth() - 50.0);
        stage.setHeight(componentePai.getHeight() - 50.0);
        this.centerChildWindowOnStage(stage, componentePai);
        return stage;
    }

    public Stage createWindowVBox(StageManager stageManager, String fxml, String titulo) throws IOException {
        FXMLLoader loader = stageManager.loader(fxml);
        VBox content = (VBox)loader.load();
        Scene scene = new Scene((Parent)content);
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/Styles.css").toExternalForm());
        MaximaController controller = (MaximaController)loader.getController();
        controller.inicializa();
        Stage stage = new Stage();
        stage.setResizable(false);
        stage.setTitle(titulo);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.DECORATED);
        stage.initOwner((Window)stageManager.getStage());
        stage.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                stage.close();
            }
        });
        stage.setScene(scene);
        return stage;
    }

    public Stage createFrameVBox(StageManager stageManager, String fxml, String titulo, String ... arquivoCss) throws IOException {
        FXMLLoader loader = stageManager.loader(fxml);
        VBox content = (VBox)loader.load();
        Scene scene = new Scene((Parent)content);
        String css = "Styles.css";
        if (arquivoCss != null && arquivoCss.length > 0) {
            css = arquivoCss[0];
        }
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/" + css).toExternalForm());
        MaximaController controller = (MaximaController)loader.getController();
        controller.inicializa();
        Stage stage = new Stage();
        stage.setResizable(true);
        stage.setTitle(titulo);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.DECORATED);
        stage.setScene(scene);
        return stage;
    }

    public Stage createFrame(StageManager stageManager, String fxml, String titulo) throws IOException {
        FXMLLoader loader = stageManager.loader(fxml);
        AnchorPane content = (AnchorPane)loader.load();
        Scene scene = new Scene((Parent)content);
        scene.getStylesheets().add((Object)this.getClass().getResource("/styles/Styles.css").toExternalForm());
        MaximaController controller = (MaximaController)loader.getController();
        controller.inicializa();
        Stage stage = new Stage();
        stage.setResizable(false);
        stage.setTitle(titulo);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.DECORATED);
        stage.setScene(scene);
        return stage;
    }

    public Stage progress(StageManager stageManager, String mensagem) {
        try {
            Stage stage = this.createWindowUndecaredForm(stageManager, "/fxml/Progress.fxml", "M\u00e1xima Sistema e Solu\u00e7\u00f5es");
            ProgressController controller = (ProgressController)stage.getUserData();
            controller.inicializa(mensagem);
            return stage;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void centerChildWindowOnStage(Stage stage, Stage primaryStage) {
        if (primaryStage == null) {
            return;
        }
        double x = stage.getX();
        double y = stage.getY();
        stage.getScene().getRoot().applyCss();
        stage.getScene().getRoot().layout();
        Scene ownerScene = primaryStage.getScene();
        double titleBarHeight = ownerScene.getY();
        double dialogWidth = stage.getScene().getRoot().prefWidth(-1.0);
        double dialogHeight = stage.getScene().getRoot().prefHeight(dialogWidth);
        double ownerWidth = primaryStage.getScene().getRoot().prefWidth(-1.0);
        double ownerHeight = primaryStage.getScene().getRoot().prefHeight(ownerWidth);
        if (dialogWidth < ownerWidth) {
            x = primaryStage.getX() + ownerScene.getWidth() / 2.0 - dialogWidth / 2.0;
        } else {
            x = primaryStage.getX();
            stage.setWidth(dialogWidth);
        }
        y = dialogHeight < ownerHeight ? primaryStage.getY() + titleBarHeight / 2.0 + ownerScene.getHeight() / 2.0 - dialogHeight / 2.0 : primaryStage.getY();
        stage.setX(x);
        stage.setY(y);
    }
}

