/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.core.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class AlertaWindowController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Label lblMensagem;
    @FXML
    private Button btnSim;
    @FXML
    private ImageView img;

    public void initialize(URL location, ResourceBundle resources) {
        Image image = new Image(this.getClass().getResourceAsStream("/images/alert_64.png"));
        this.img.setImage(image);
    }

    public void inicializa(String pergunta) {
        this.registraAcoes();
        this.carregaIcones();
        this.lblMensagem.setText(pergunta);
        this.btnSim.requestFocus();
    }

    private void sim() {
        this.close();
    }

    private void registraAcoes() {
        this.btnSim.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.sim();
            }
        });
        this.btnSim.setOnAction(event -> this.sim());
        Stage form = (Stage)this.lblMensagem.getScene().getWindow();
        form.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                form.close();
            }
        });
    }

    private void carregaIcones() {
        this.btnSim.setGraphic((Node)new MaximaIcone().ok_24());
    }

    private void close() {
        Stage form = (Stage)this.lblMensagem.getScene().getWindow();
        form.close();
    }
}

