/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.BaixaProdutoFormController;
import br.com.maximasolutions.estoque.modelo.BaixaProduto;
import br.com.maximasolutions.estoque.service.BaixaProdutoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class BaixaProdutoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnBaixaManual;
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnDelete;
    @FXML
    private TableView<BaixaProduto> tabela;
    @FXML
    private TableColumn<BaixaProduto, String> colData;
    @FXML
    private TableColumn<BaixaProduto, String> colMotivo;
    @FXML
    private TableColumn<BaixaProduto, String> colObs;
    @FXML
    private TableColumn<BaixaProduto, BigDecimal> colTotalCusto;
    @FXML
    private TableColumn<BaixaProduto, BigDecimal> colTotalVenda;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotalCusto;
    @FXML
    private Label lblTotalVenda;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private BaixaProdutoService baixaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<BaixaProduto> baixaProdutoList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.baixaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.BaixaProduto);
    }

    private void edita() {
        MaximaAlert.aviso((StageManager)this.stageManager, (String)"Aviso: Opera\u00e7\u00e3o n\u00e3o permitida.");
    }

    private void baixaManual() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.abreForm(null);
    }

    private void abreForm(BaixaProduto baixaProduto) {
        try {
            Stage form = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/baixaProduto/BaixaProdutoForm.fxml", "Cadastro de Baixa de Produto");
            BaixaProdutoFormController controller = (BaixaProdutoFormController)form.getUserData();
            controller.inicializaBaixa(baixaProduto);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(BaixaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir form de baixa de produto.");
        }
    }

    private void imprimeExtrato() {
        BaixaProduto baixaProduto = (BaixaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (baixaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma baixa de produto para imprimir.");
            return;
        }
        try {
            this.baixaProdutoService.imprime(baixaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(BaixaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel imprimir a baixa de estoque.\n" + ex.getMessage()));
        }
    }

    private void delete() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        BaixaProduto baixaProduto = (BaixaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (baixaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma baixa de produto para remover.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover a baixa de produto?")) {
            return;
        }
        try {
            this.baixaProdutoService.delete(baixaProduto);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Baixa de produto removida com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(BaixaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel remover a baixa de produto.\nCausa:" + ex.getMessage()));
        }
    }

    private void setColumnProperties() {
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colMotivo.setCellValueFactory((Callback)new PropertyValueFactory("motivo"));
        this.colObs.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotalCusto.setCellValueFactory((Callback)new PropertyValueFactory("totalCusto"));
        this.colTotalVenda.setCellValueFactory((Callback)new PropertyValueFactory("totalVenda"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotalCusto.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalVenda.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotalCusto.setAlignment(Pos.CENTER_RIGHT);
        this.lblTotalVenda.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.baixaProdutoList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.baixaProdutoService.lista(inicio, fim, Boolean.valueOf(this.ccbExcluida.isSelected()), filtro);
        this.baixaProdutoList.addAll((Collection)list);
        this.tabela.setItems(this.baixaProdutoList);
        BigDecimal totalCusto = BigDecimal.ZERO;
        BigDecimal totalVenda = BigDecimal.ZERO;
        for (BaixaProduto bp : list) {
            totalCusto = totalCusto.add(bp.getTotalCusto());
            totalVenda = totalVenda.add(bp.getTotalVenda());
        }
        this.lblTotalCusto.setText("Total Custo: R$ " + MaximaNumber.formataNumero((BigDecimal)totalCusto));
        this.lblTotalVenda.setText("Total Venda: R$ " + MaximaNumber.formataNumero((BigDecimal)totalVenda));
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnBaixaManual.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnImprime.setOnAction(evt -> this.imprimeExtrato());
        this.btnBaixaManual.setOnAction(event -> this.baixaManual());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

