/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.BaixaProdutoMotivoFormController;
import br.com.maximasolutions.estoque.modelo.BaixaProdutoMotivo;
import br.com.maximasolutions.estoque.service.BaixaProdutoMotivoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class BaixaProdutoMotivoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<BaixaProdutoMotivo> tabela;
    @FXML
    private TableColumn<BaixaProdutoMotivo, String> colNome;
    @Autowired
    private BaixaProdutoMotivoService baixaProdutoMotivoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<BaixaProdutoMotivo> baixaProdutoMotivoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.baixaProdutoMotivoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaBaixaProdutoMotivo();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.BaixaProdutoMotivo);
    }

    private void novoBaixaProdutoMotivo() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formBaixaProdutoMotivo(null);
        this.loadTabela();
    }

    private void editaBaixaProdutoMotivo() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        BaixaProdutoMotivo baixaProdutoMotivo = (BaixaProdutoMotivo)this.tabela.getSelectionModel().getSelectedItem();
        if (baixaProdutoMotivo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um motivo para editar.");
            return;
        }
        this.formBaixaProdutoMotivo(baixaProdutoMotivo);
        this.loadTabela();
    }

    private void formBaixaProdutoMotivo(BaixaProdutoMotivo baixaProdutoMotivo) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/baixaProdutoMotivo/BaixaProdutoMotivoForm.fxml", "Novo Motivo");
            BaixaProdutoMotivoFormController controller = (BaixaProdutoMotivoFormController)stage.getUserData();
            controller.inicializa(baixaProdutoMotivo);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(BaixaProdutoMotivoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form motivo para baixa de estoque.\n" + ex.getMessage()));
        }
    }

    private void deleteBaixaProdutoMotivo() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        BaixaProdutoMotivo baixaProdutoMotivo = (BaixaProdutoMotivo)this.tabela.getSelectionModel().getSelectedItem();
        if (baixaProdutoMotivo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um motivo para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover o motivo: '" + baixaProdutoMotivo.getNome() + "'?"))) {
            this.baixaProdutoMotivoService.deleteById(baixaProdutoMotivo.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Motivo deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.baixaProdutoMotivoList.clear();
        this.baixaProdutoMotivoList.addAll((Collection)this.baixaProdutoMotivoService.list());
        this.tabela.setItems(this.baixaProdutoMotivoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoBaixaProdutoMotivo());
        this.btnEdita.setOnAction(event -> this.editaBaixaProdutoMotivo());
        this.btnDelete.setOnAction(event -> this.deleteBaixaProdutoMotivo());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

