/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.BaixaProdutoMotivo;
import br.com.maximasolutions.estoque.service.BaixaProdutoMotivoService;
import br.com.maximasolutions.food.service.DepartamentoImpressoraService;
import br.com.maximasolutions.utils.MaximaDate;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class BaixaProdutoMotivoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private Button btnSalva;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private BaixaProdutoMotivoService baixaProdutoMotivoService;
    @Autowired
    private DepartamentoImpressoraService departamentoImpressoraService;
    private BaixaProdutoMotivo baixaProdutoMotivo;

    public void initialize(URL url, ResourceBundle rb) {
        this.baixaProdutoMotivo = null;
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa(BaixaProdutoMotivo baixaProdutoMotivo1) {
        this.baixaProdutoMotivo = baixaProdutoMotivo1;
        if (this.baixaProdutoMotivo != null) {
            this.tfId.setText(this.baixaProdutoMotivo.getId().toString());
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.baixaProdutoMotivo.getUltimaAlteracao()));
            this.tfNome.setText(this.baixaProdutoMotivo.getNome());
            this.ccbAtivo.setSelected(this.baixaProdutoMotivo.getAtivo().booleanValue());
            this.tfNome.selectAll();
            this.tfNome.requestFocus();
        }
    }

    private void salva() {
        if (this.baixaProdutoMotivo == null) {
            this.baixaProdutoMotivo = new BaixaProdutoMotivo();
            this.baixaProdutoMotivo.setAtivo(Boolean.TRUE);
        }
        this.baixaProdutoMotivo.setNome(this.tfNome.getText().trim().toUpperCase());
        this.baixaProdutoMotivo.setUltimaAlteracao(LocalDateTime.now());
        this.baixaProdutoMotivo.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        if (!this.validaForm()) {
            return;
        }
        try {
            this.baixaProdutoMotivoService.save(this.baixaProdutoMotivo);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Motivo salvo com sucesso.");
            Stage stage = (Stage)this.tfNome.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(BaixaProdutoMotivoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: " + ex.getMessage()));
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.baixaProdutoMotivo.getNome() == null || this.baixaProdutoMotivo.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

