/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.CategoriaProdutoFormController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CategoriaProdutoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<CategoriaProduto> tabela;
    @FXML
    private TableColumn<CategoriaProduto, String> colNome;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<CategoriaProduto> categoriaProdutoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.categoriaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaCategoriaProduto();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.CategoriaProduto);
    }

    private void novoCategoriaProduto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formCategoriaProduto(null);
        this.loadTabela();
    }

    private void editaCategoriaProduto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        CategoriaProduto categoriaProduto = (CategoriaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (categoriaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma categoria de produto para editar.");
            return;
        }
        this.formCategoriaProduto(categoriaProduto);
        this.loadTabela();
    }

    private void formCategoriaProduto(CategoriaProduto categoriaProduto) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/categoriaProduto/CategoriaProdutoForm.fxml", "Novo Categoria Produto");
            CategoriaProdutoFormController controller = (CategoriaProdutoFormController)stage.getUserData();
            controller.inicializa(categoriaProduto);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(CategoriaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form categoria de produto.\n" + ex.getMessage()));
        }
    }

    private void deleteCategoriaProduto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        CategoriaProduto categoriaProduto = (CategoriaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (categoriaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma categoria de produto para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover a categoria de produto: '" + categoriaProduto.getNome() + "'?"))) {
            this.categoriaProdutoService.deleteById(categoriaProduto.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Categoria de produto deletada com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.categoriaProdutoList.clear();
        this.categoriaProdutoList.addAll((Collection)this.categoriaProdutoService.list());
        this.tabela.setItems(this.categoriaProdutoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoCategoriaProduto());
        this.btnEdita.setOnAction(event -> this.editaCategoriaProduto());
        this.btnDelete.setOnAction(event -> this.deleteCategoriaProduto());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

