/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.CategoriaProdutoTamanhoFormController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.CategoriaProdutoTamanho;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.food.modelo.DepartamentoImpressora;
import br.com.maximasolutions.food.service.DepartamentoImpressoraService;
import br.com.maximasolutions.utils.MaximaDate;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CategoriaProdutoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private ComboBox<DepartamentoImpressora> cbbDepartamento;
    @FXML
    private ComboBox<DepartamentoImpressora> cbbDepartamentoSecundario;
    @FXML
    private CheckBox ccbPermiteMeioAMeio;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnNovoTamanho;
    @FXML
    private TabPane tabPaneFood;
    @FXML
    private TableView<CategoriaProdutoTamanho> tblTamanhos;
    @FXML
    private TableColumn<CategoriaProdutoTamanho, String> colDescricao;
    @FXML
    private TableColumn<CategoriaProdutoTamanho, String> colSigla;
    @FXML
    private TableColumn<CategoriaProdutoTamanho, String> colItem;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private DepartamentoImpressoraService departamentoImpressoraService;
    private CategoriaProduto categoriaProduto;
    private List<CategoriaProdutoTamanho> tamanhos;
    private ObservableList<CategoriaProdutoTamanho> categoriaProdutoTamanhoList;
    @Autowired
    private UsuarioService usuarioService;

    public void initialize(URL url, ResourceBundle rb) {
        this.categoriaProduto = null;
        this.categoriaProdutoTamanhoList = FXCollections.observableArrayList();
        this.tblTamanhos.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaCategoriaProdutoTamanho();
            }
        });
        this.setColumnProperties();
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa(CategoriaProduto categoriaProduto1) {
        this.categoriaProduto = categoriaProduto1;
        if (this.categoriaProduto != null) {
            this.tfId.setText(this.categoriaProduto.getId().toString());
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.categoriaProduto.getUltimaAlteracao()));
            this.tfNome.setText(this.categoriaProduto.getNome());
            this.cbbDepartamento.getSelectionModel().select((Object)this.categoriaProduto.getImpressora());
            this.cbbDepartamentoSecundario.getSelectionModel().select((Object)this.categoriaProduto.getImpressoraSecundaria());
            this.ccbPermiteMeioAMeio.setSelected(this.categoriaProduto.getPermiteMeioAMeio().booleanValue());
            this.tfNome.selectAll();
            this.tfNome.requestFocus();
            this.tamanhos = this.categoriaProdutoService.listaCategoriaProdutoTamanhos(this.categoriaProduto.getId());
        }
        this.loadTabela();
    }

    public void inicializa() {
        this.tamanhos = new ArrayList();
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.CategoriaProduto);
        if (!MaximaConfig.menuFood().booleanValue()) {
            this.tabPaneFood.setVisible(false);
        }
    }

    private void salva() {
        if (this.categoriaProduto == null) {
            this.categoriaProduto = new CategoriaProduto();
            this.categoriaProduto.setAtivo(Boolean.TRUE);
        }
        System.out.println("== cat prod: " + this.categoriaProduto);
        this.categoriaProduto.setNome(this.tfNome.getText().trim().toUpperCase());
        this.categoriaProduto.setUltimaAlteracao(LocalDateTime.now());
        this.categoriaProduto.setImpressora((DepartamentoImpressora)this.cbbDepartamento.getSelectionModel().getSelectedItem());
        this.categoriaProduto.setImpressoraSecundaria((DepartamentoImpressora)this.cbbDepartamentoSecundario.getSelectionModel().getSelectedItem());
        this.categoriaProduto.setPermiteMeioAMeio(Boolean.valueOf(this.ccbPermiteMeioAMeio.isSelected()));
        if (!this.validaForm()) {
            return;
        }
        boolean existePadrao = false;
        boolean erro = false;
        for (CategoriaProdutoTamanho tamanho : this.tamanhos) {
            if (!tamanho.getPadrao().booleanValue()) continue;
            if (existePadrao) {
                erro = true;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Somente um tamanho pode ser cadastrado como padr\u00e3o.");
                break;
            }
            existePadrao = true;
        }
        if (erro) {
            return;
        }
        if (!existePadrao && this.tamanhos != null && this.tamanhos.size() > 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma tamanho cadastrado como padr\u00e3o.");
            return;
        }
        try {
            this.categoriaProdutoService.save(this.categoriaProduto, this.tamanhos);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Categoria de produto salvo com sucesso.");
            Stage stage = (Stage)this.tfNome.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(CategoriaProdutoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: " + ex.getMessage()));
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.categoriaProduto.getNome() == null || this.categoriaProduto.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
        List impressoras = this.departamentoImpressoraService.listaCombo();
        this.cbbDepartamento.setItems(FXCollections.observableArrayList((Collection)impressoras));
        this.cbbDepartamentoSecundario.setItems(FXCollections.observableArrayList((Collection)impressoras));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnNovoTamanho.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void formCategoriaProdutoTamanho(CategoriaProdutoTamanho categoriaProdutoTamanho) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/categoriaProdutoTamanho/CategoriaProdutoTamanhoForm.fxml", "Novo Tamanho");
            CategoriaProdutoTamanhoFormController controller = (CategoriaProdutoTamanhoFormController)stage.getUserData();
            controller.inicializa(categoriaProdutoTamanho);
            stage.showAndWait();
            CategoriaProdutoTamanho tamanho = controller.getTamanho();
            if (tamanho != null) {
                if (!this.tamanhos.contains(tamanho)) {
                    this.tamanhos.add(tamanho);
                }
                this.loadTabela();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CategoriaProdutoTamanhoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form tamanho.\n" + ex.getMessage()));
        }
    }

    private void loadTabela() {
        this.categoriaProdutoTamanhoList.clear();
        int cont = 0;
        for (CategoriaProdutoTamanho tam : this.tamanhos) {
            tam.setNumeroItem(Integer.valueOf(++cont));
            this.categoriaProdutoTamanhoList.add((Object)tam);
        }
        this.tblTamanhos.setItems(this.categoriaProdutoTamanhoList);
    }

    private void setColumnProperties() {
        this.colDescricao.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colSigla.setCellValueFactory((Callback)new PropertyValueFactory("sigla"));
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numeroItem"));
    }

    private void novoCategoriaProdutoTamanho() {
        this.formCategoriaProdutoTamanho(null);
        this.loadTabela();
    }

    private void editaCategoriaProdutoTamanho() {
        CategoriaProdutoTamanho categoriaProdutoTamanho = (CategoriaProdutoTamanho)this.tblTamanhos.getSelectionModel().getSelectedItem();
        if (categoriaProdutoTamanho == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma categoria de produto para editar.");
            return;
        }
        this.formCategoriaProdutoTamanho(categoriaProdutoTamanho);
        this.loadTabela();
    }

    private void deleteItem(CategoriaProdutoTamanho item) {
        if (item == null && (item = (CategoriaProdutoTamanho)this.tblTamanhos.getSelectionModel().getSelectedItem()) == null) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o item: " + item.getNumeroItem() + " ?"))) {
            return;
        }
        this.categoriaProdutoService.deleteTamanho(item.getId());
        this.inicializa(this.categoriaProduto);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Item removido com sucesso.");
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnNovoTamanho.setOnAction(event -> this.novoCategoriaProdutoTamanho());
        this.tblTamanhos.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem(null);
            }
        });
    }
}

