/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.estoque.modelo.CategoriaProdutoTamanho;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.utils.MaximaDate;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CategoriaProdutoTamanhoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    private ObservableList<CategoriaProdutoTamanho> categoriaProdutoTamanhoList;
    private CategoriaProdutoTamanho categoriaProdutoTamanho;
    @FXML
    private TextField tfDescricao;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private TextField tfSigla;
    @FXML
    private CheckBox ccbPadrao;
    @FXML
    private Button btnSalva;

    public void inicializa(CategoriaProdutoTamanho categoriaProdutoTamanho1) {
        this.categoriaProdutoTamanho = categoriaProdutoTamanho1;
        if (this.categoriaProdutoTamanho != null) {
            if (this.categoriaProdutoTamanho.getId() != null) {
                this.tfId.setText(this.categoriaProdutoTamanho.getId().toString());
            }
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.categoriaProdutoTamanho.getUltimaAlteracao()));
            this.tfDescricao.setText(this.categoriaProdutoTamanho.getDescricao());
            this.tfDescricao.selectAll();
            this.tfDescricao.requestFocus();
            this.tfSigla.setText(this.categoriaProdutoTamanho.getSigla());
            this.ccbPadrao.setSelected(this.categoriaProdutoTamanho.getPadrao().booleanValue());
        }
    }

    private void carregaIcones() {
    }

    public CategoriaProdutoTamanho getTamanho() {
        return this.categoriaProdutoTamanho;
    }

    private void salva() {
        if (this.categoriaProdutoTamanho == null) {
            this.categoriaProdutoTamanho = new CategoriaProdutoTamanho();
            this.categoriaProdutoTamanho.setAtivo(Boolean.TRUE);
        }
        if (this.tfId.getText() != null && !this.tfId.getText().isEmpty()) {
            this.categoriaProdutoTamanho.setId(Long.valueOf(Long.parseLong(this.tfId.getText())));
        }
        this.categoriaProdutoTamanho.setDescricao(this.tfDescricao.getText().trim().toUpperCase());
        this.categoriaProdutoTamanho.setUltimaAlteracao(LocalDateTime.now());
        this.categoriaProdutoTamanho.setSigla(this.tfSigla.getText().trim().toUpperCase());
        this.categoriaProdutoTamanho.setPadrao(Boolean.valueOf(this.ccbPadrao.isSelected()));
        if (!this.validaForm()) {
            return;
        }
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Categoria de produto salvo com sucesso.");
        Stage stage = (Stage)this.tfDescricao.getScene().getWindow();
        stage.close();
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.categoriaProdutoTamanho.getDescricao() == null || this.categoriaProdutoTamanho.getDescricao().isEmpty()) {
            this.tfDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDescricao.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.categoriaProdutoTamanho = null;
        this.carregaIcones();
        this.registraAcoes();
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

