/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class DescontoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfValor;
    @FXML
    private TextField tfDescontoPercentual;
    @FXML
    private TextField tfDesconto;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFechar;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private BigDecimal desconto;
    private BigDecimal descontoPercentual;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(BigDecimal valor, BigDecimal descontoPercentual, BigDecimal desconto) {
        System.out.println("== percentual: " + descontoPercentual);
        System.out.println("== desconto..: " + desconto);
        this.tfValor.setText(MaximaNumber.bigDecimalToString((BigDecimal)valor, (int)2));
        this.tfDescontoPercentual.setText(MaximaNumber.bigDecimalToString((BigDecimal)descontoPercentual, (int)2));
        this.tfDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)desconto, (int)2));
        this.tfDescontoPercentual.requestFocus();
    }

    public BigDecimal getDesconto() {
        return this.desconto;
    }

    private void confirma() {
        if (!this.validaForm()) {
            return;
        }
        this.desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        this.descontoPercentual = MaximaNumber.moneyToBigDecimal((String)this.tfDescontoPercentual.getText());
        this.fechaForm();
    }

    private void fechaForm() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDesconto.getText() == null || this.tfDesconto.getText().isEmpty()) {
            this.tfDesconto.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDesconto.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.confirma());
        this.btnSalva.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
        this.btnFechar.setOnAction(evt -> this.fechaForm());
        this.tfDescontoPercentual.setOnKeyReleased(et -> this.calculaDesconto());
        this.tfDesconto.setOnKeyReleased(et -> this.calculaPercentualDesconto());
        this.tfDescontoPercentual.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfDesconto.requestFocus();
                this.tfDesconto.selectAll();
            }
        });
        this.tfDesconto.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }

    private void calculaDesconto() {
        BigDecimal total = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        BigDecimal percentual = MaximaNumber.moneyToBigDecimal((String)this.tfDescontoPercentual.getText());
        BigDecimal desconto = total.multiply(percentual).divide(new BigDecimal(100), 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        this.tfDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)desconto, (int)2));
    }

    private void calculaPercentualDesconto() {
        BigDecimal total = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        BigDecimal percentual = desconto.multiply(new BigDecimal(100)).divide(total, 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        this.tfDescontoPercentual.setText(MaximaNumber.bigDecimalToString((BigDecimal)percentual, (int)2));
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfDescontoPercentual);
    }
}

