/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.EntradaProdutoFormController;
import br.com.maximasolutions.estoque.controller.EntradaProdutoImportaXmlController;
import br.com.maximasolutions.estoque.controller.EntradaProdutoSimplificadaFormController;
import br.com.maximasolutions.estoque.core.ProdutoEtiquetaModelo;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProdutoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.fiscal.certificado.MaximaCertificado;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.fiscal.controller.DownloadXmlController;
import br.com.maximasolutions.fiscal.modelo.ArquivoFiscal;
import br.com.maximasolutions.fiscal.service.ArquivoFiscalService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.nfe.controller.NotaFiscalManifestacaoDestinatarioXml;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoDocumentoZip;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaProdutoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnEntradaManual;
    @FXML
    private Button btnImportaXml;
    @FXML
    private Button btnTouch;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnDownload;
    @FXML
    private TableView<EntradaProduto> tabela;
    @FXML
    private TableColumn<EntradaProduto, String> colFornecedor;
    @FXML
    private TableColumn<EntradaProduto, String> colNota;
    @FXML
    private TableColumn<EntradaProduto, String> colObservacao;
    @FXML
    private TableColumn<EntradaProduto, String> colData;
    @FXML
    private TableColumn<EntradaProduto, BigDecimal> colTotal;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ArquivoFiscalService arquivoFiscalService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<EntradaProduto> entradaProdutoList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.entradaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.EntradaProduto);
        if (!MaximaConfig.getEntradaProdutoTouch().booleanValue()) {
            this.btnTouch.setDisable(true);
        }
    }

    private void etiqueta() {
        EntradaProduto entradaProduto = (EntradaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (entradaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma entrada de produto.");
            return;
        }
        String imp = this.conf.getImpressoraEtiqueta();
        if (imp == null || imp.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Impressora de etiquetas n\u00e3o encontrada.");
            return;
        }
        PrintService impressora = null;
        PrintService[] pservices = PrinterJob.lookupPrintServices();
        if (pservices.length > 0) {
            for (PrintService ps : pservices) {
                if (!ps.getName().equalsIgnoreCase(imp)) continue;
                impressora = ps;
                break;
            }
        }
        if (impressora == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Impressora n\u00e3o instalada corretamente.");
            return;
        }
        ProdutoEtiquetaModelo etiquetaModelo = this.conf.getProdutoEtiquetaModelo();
        if (etiquetaModelo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de etiquta n\u00e3o informado em:\nAdministrativo->Configura\u00e7\u00e3o->Produtos");
            return;
        }
        List itens = this.entradaProdutoService.listItens(entradaProduto);
        StringBuilder texto = new StringBuilder("N\n");
        Boolean isColumn = true;
        Integer quantidadeImprimir = 0;
        int margem = 30;
        String modeloImpressora = MaximaConfig.getInstance().getProperty("etiqueta_tipo", "elgin");
        if (modeloImpressora.equalsIgnoreCase("argox")) {
            margem += 20;
        }
        Integer contadorProdutos = 0;
        for (EntradaProdutoItem item : itens) {
            Produto produto = item.getProduto();
            Integer numeroItem = item.getQuantidade().intValueExact();
            String produtoLinha1 = MaximaUtils.limitaTexto((String)produto.getNome(), (int)30);
            String produtoLinha2 = "";
            if (produto.getNome().length() > 30) {
                produtoLinha2 = produto.getNome().length() > 60 ? produto.getNome().substring(30, 60) : produto.getNome().substring(30, produto.getNome().length());
            }
            for (int cont = 0; cont < numeroItem; ++cont) {
                Number precoParcela;
                if (quantidadeImprimir == 0) {
                    texto = new StringBuilder("N\n");
                    texto.append("I8,A,001\n");
                    texto.append("Q599,024\n");
                    texto.append("q831\n");
                    texto.append("rN\n");
                    texto.append("S3\n");
                    texto.append("D7\n");
                    texto.append("ZB\n");
                    texto.append("JF\n");
                    texto.append("O\n");
                    texto.append("R16,0\n");
                    texto.append("f100\n");
                    texto.append("N\n");
                    texto.append("A" + margem + ",65,0,3,1,1,N," + '\"' + MaximaUtils.removeAcentos((String)MaximaUtils.limitaTexto((String)this.conf.getNomeEmpresa().trim(), (int)25)) + '\"' + "\n");
                    texto.append("A" + margem + ",110,0,2,1,1,N," + '\"' + MaximaUtils.removeAcentos((String)produtoLinha1) + '\"' + "\n");
                    if (!produtoLinha2.isEmpty()) {
                        texto.append("A" + margem + ",130,0,2,1,1,N," + '\"' + MaximaUtils.removeAcentos((String)produtoLinha2) + '\"' + "\n");
                    }
                    texto.append("B" + margem + ",200,0,1,2,1,70,B," + '\"' + produto.getCodigo() + '\"' + "\n");
                    texto.append("B" + margem + ",410,0,1,2,1,70,B," + '\"' + produto.getCodigo() + '\"' + "\n");
                    if (produto.getReferencia() != null && !produto.getReferencia().isEmpty()) {
                        texto.append("A" + margem + ",330,0,4,1,1,N," + '\"' + "REF:  " + produto.getReferencia() + '\"' + "\n");
                    }
                    if (this.conf.getEtiquetaParcelas().compareTo(BigDecimal.ZERO) == 0) {
                        texto.append("A" + (margem + 170) + ",530,0,4,1,1,N," + '\"' + "R$ " + MaximaNumber.formataNumero((BigDecimal)produto.getPrecoVenda()) + '\"' + "\n");
                    } else {
                        texto.append("A" + margem + ",530,0,3,1,1,N," + '\"' + "R$ " + MaximaNumber.formataNumero((BigDecimal)produto.getPrecoVenda()) + '\"' + "\n");
                        precoParcela = produto.getPrecoVenda().divide(this.conf.getEtiquetaParcelas(), 2, RoundingMode.HALF_EVEN);
                        texto.append("A" + (margem + 143) + ",530,0,3,1,1,N," + '\"' + " ou " + MaximaNumber.quantidadeToString((BigDecimal)this.conf.getEtiquetaParcelas()) + "x R$ " + MaximaNumber.bigDecimalToString((BigDecimal)precoParcela, (int)2) + '\"' + "\n");
                    }
                } else {
                    texto.append("A" + (margem + 400) + ",65,0,3,1,1,N," + '\"' + MaximaUtils.removeAcentos((String)MaximaUtils.limitaTexto((String)this.conf.getNomeEmpresa().trim(), (int)25)) + '\"' + "\n");
                    if (!produtoLinha2.isEmpty()) {
                        texto.append("A" + (margem + 400) + ",130,0,2,1,1,N," + '\"' + MaximaUtils.removeAcentos((String)produtoLinha2) + '\"' + "\n");
                    }
                    texto.append("A" + (margem + 400) + ",110,0,2,1,1,N," + '\"' + MaximaUtils.removeAcentos((String)produtoLinha1) + '\"' + "\n");
                    texto.append("B" + (margem + 400) + ",200,0,1,2,1,70,B," + '\"' + produto.getCodigo() + '\"' + "\n");
                    texto.append("B" + (margem + 400) + ",410,0,1,2,1,70,B," + '\"' + produto.getCodigo() + '\"' + "\n");
                    if (produto.getReferencia() != null && !produto.getReferencia().isEmpty()) {
                        texto.append("A" + (margem + 400) + ",330,0,4,1,1,N," + '\"' + "REF:  " + produto.getReferencia() + '\"' + "\n");
                    }
                    if (this.conf.getEtiquetaParcelas().compareTo(BigDecimal.ZERO) == 0) {
                        texto.append("A" + (margem + 570) + ",530,0,4,1,1,N," + '\"' + "R$ " + MaximaNumber.formataNumero((BigDecimal)produto.getPrecoVenda()) + '\"' + "\n");
                    } else {
                        texto.append("A" + (margem + 400) + ",530,0,3,1,1,N," + '\"' + "R$ " + MaximaNumber.formataNumero((BigDecimal)produto.getPrecoVenda()) + '\"' + "\n");
                        precoParcela = produto.getPrecoVenda().divide(this.conf.getEtiquetaParcelas(), 2, RoundingMode.HALF_EVEN);
                        texto.append("A" + (margem + 543) + ",530,0,3,1,1,N," + '\"' + " ou " + MaximaNumber.quantidadeToString((BigDecimal)this.conf.getEtiquetaParcelas()) + "x R$ " + MaximaNumber.bigDecimalToString((BigDecimal)precoParcela, (int)2) + '\"' + "\n");
                    }
                }
                precoParcela = quantidadeImprimir;
                Integer n = quantidadeImprimir = Integer.valueOf(quantidadeImprimir + 1);
            }
            if (quantidadeImprimir == 2 || contadorProdutos == itens.size() - 1) {
                texto.append("P1\n");
                ByteArrayInputStream pis = new ByteArrayInputStream(texto.toString().getBytes());
                DocFlavor.INPUT_STREAM df = DocFlavor.INPUT_STREAM.AUTOSENSE;
                SimpleDoc d = new SimpleDoc(pis, df, null);
                DocPrintJob job = impressora.createPrintJob();
                try {
                    job.print(d, null);
                    quantidadeImprimir = 0;
                    texto = new StringBuilder("N\n");
                }
                catch (PrintException e) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao efetuar impress\u00e3o da eitqueta.");
                    break;
                }
            }
            Integer n = contadorProdutos;
            Integer n2 = contadorProdutos = Integer.valueOf(contadorProdutos + 1);
        }
    }

    private ArquivoFiscal manifestaNfeDestinatario(ArquivoFiscal arquivoFiscal, String chaveAcesso) throws MaximaException {
        try {
            NFeConfigMaxima nfeConfigMaxima = new NFeConfigMaxima(this.conf);
            WSFacade facade = new WSFacade((NFeConfig)nfeConfigMaxima);
            String xmlManifestacao = new NotaFiscalManifestacaoDestinatarioXml().geraXml(chaveAcesso, NFTipoEventoManifestacaoDestinatario.CIENCIA_DA_EMISSAO, "BAIXAR XML NOTA FISCAL", MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf()), this.conf);
            NFEnviaEventoRetorno retornoM = facade.manifestaDestinatarioNotaAssinada(chaveAcesso, xmlManifestacao);
            System.out.println("== RET MANIF: " + retornoM);
            if (retornoM.getCodigoStatusReposta() == 128) {
                if (arquivoFiscal == null) {
                    arquivoFiscal = new ArquivoFiscal();
                }
            } else {
                throw new MaximaException(retornoM.getMotivo());
            }
            arquivoFiscal.setChaveAcesso(chaveAcesso);
            arquivoFiscal.setExcluido(Boolean.FALSE);
            arquivoFiscal.setManifestado(Boolean.TRUE);
            arquivoFiscal = this.arquivoFiscalService.salva(arquivoFiscal);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException((Throwable)ex);
        }
        catch (Exception ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException((Throwable)ex);
        }
        return arquivoFiscal;
    }

    private void importaXml() {
        NFNotaProcessada notaProcessada;
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory());
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Nota Fiscal de Entrada", new String[]{".xml"}));
        File arquivoXml = fileChooser.showOpenDialog(this.btnImportaXml.getScene().getWindow());
        if (arquivoXml == null) {
            return;
        }
        try {
            notaProcessada = (NFNotaProcessada)new DFPersister().read(NFNotaProcessada.class, arquivoXml);
        }
        catch (Exception ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel parsear o arquivo xml para objeto nota fiscal.\nVerifique se o arquivo xml \u00e9 uma nota fiscal eletr\u00f4nica 4.0\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        this.formXml(notaProcessada);
    }

    private void formXml(NFNotaProcessada notaProcessada) {
        try {
            Stage importaXmlForm = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/entradaProduto/EntradaProdutoImportaXml.fxml", "Importa\u00e7\u00e3o Nota Fiscal de Entrada");
            EntradaProdutoImportaXmlController controller = (EntradaProdutoImportaXmlController)importaXmlForm.getUserData();
            controller.inicializa(notaProcessada.getNota().getInfo());
            importaXmlForm.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de importa\u00e7\u00e3o de nota fiscal de entrada.\nErro no arquivo: EntradaProdutoImporta.fxml.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
        }
    }

    private void edita() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        EntradaProduto entradaProduto = (EntradaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (entradaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma entrada de produto.");
            return;
        }
        if (entradaProduto.getExcluida() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Aviso: Entrada de produto j\u00e1 excluida do banco de dados.\nN\u00e3o pode ser editada.");
            return;
        }
        this.abreForm(entradaProduto);
    }

    private void entradaManual() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.abreForm(null);
    }

    private void abreForm(EntradaProduto entradaProduto) {
        try {
            Stage form = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/entradaProduto/EntradaProdutoForm.fxml", "Cadastro de Entrada de Produto");
            EntradaProdutoFormController controller = (EntradaProdutoFormController)form.getUserData();
            controller.inicializaEntrada(entradaProduto);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir form de entrada de produto.");
        }
    }

    private void delete() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        EntradaProduto entradaProduto = (EntradaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (entradaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma entrada de produto para remover.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover a entrada de produto?")) {
            return;
        }
        try {
            this.entradaProdutoService.delete(entradaProduto);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entrada de produto removida com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel remover a entrada de produto.\nCausa:" + ex.getMessage()));
        }
    }

    private void setColumnProperties() {
        this.colNota.setCellValueFactory((Callback)new PropertyValueFactory("numeroNota"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colFornecedor.setCellValueFactory((Callback)new PropertyValueFactory("fornecedor"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.entradaProdutoList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        List list = this.entradaProdutoService.lista(inicio, fim, Boolean.valueOf(this.ccbExcluida.isSelected()), filtro);
        this.entradaProdutoList.addAll((Collection)list);
        this.tabela.setItems(this.entradaProdutoList);
        BigDecimal total = BigDecimal.ZERO;
        for (EntradaProduto ep : list) {
            total = total.add(ep.getTotal());
        }
        this.lblTotal.setText("R$ " + MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void entradaSimplificada() {
        try {
            Stage form = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/entradaProduto/EntradaProdutoSimplificadaForm.fxml", "Entrada de produto");
            EntradaProdutoSimplificadaFormController controller = (EntradaProdutoSimplificadaFormController)form.getUserData();
            controller.inicializaEntrada(null);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir entrada de produto.\n" + ex.getMessage()));
        }
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnEntradaManual.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnDownload.setOnAction(event -> this.etiqueta());
        this.btnEntradaManual.setOnAction(event -> this.entradaManual());
        this.btnImportaXml.setOnAction(event -> this.importaXml());
        this.btnTouch.setOnAction(event -> this.entradaSimplificada());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.edita();
            }
        });
    }

    private void downloadNfeSefaz() {
        this.carregaCertificadoDigital();
        NFeConfigMaxima nfeConfigMaxima = new NFeConfigMaxima(this.conf);
        try {
            NFDistribuicaoIntRetorno retorno = new WSFacade((NFeConfig)nfeConfigMaxima).consultarDistribuicaoDFe(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf()), DFUnidadeFederativa.SP, "", MaximaUtils.completaZeroEsquerda((String)"0", (Integer)15), MaximaUtils.completaZeroEsquerda((String)"294", (Integer)15));
            if (retorno == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel efetuar o download do arquivo.");
                return;
            }
            System.out.println("Retorno: " + retorno);
            if (!retorno.getCodigoStatusReposta().equalsIgnoreCase("138")) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel efetuar o download do arquivo.\n" + retorno.getMotivo()));
                return;
            }
            List documentos = retorno.getLote().getDocZip();
            int cont = 1;
            for (NFDistribuicaoDocumentoZip doc : documentos) {
                if (doc.getSchema().equals("resNFe_v1.01.xsd")) {
                    // empty if block
                }
                byte[] decoded = Base64.decodeBase64((byte[])doc.getValue().getBytes());
                String xml = DownloadXmlController.gZipToXml((byte[])decoded);
                MaximaFile.escreveTexto((String)("C:/Maxima/nota" + cont + ".xml"), (String)xml);
                ++cont;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel fazer o download do arquivo XML.\n" + ex.getMessage()));
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel fazer o download do arquivo XML.\n" + ex.getMessage()));
        }
        catch (Exception ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel fazer o download do arquivo XML.\n" + ex.getMessage()));
        }
    }

    private void carregaCertificadoDigital() {
        try {
            new MaximaCertificado().loadCertificado(this.conf.getAliasCertificado(), this.conf.getSenhaCertificado());
        }
        catch (MaximaException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Falha ao carregar certificado digital.\n" + ex.getMessage()));
        }
    }
}

