/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.bean.EntradaProdutoItemBean;
import br.com.maximasolutions.estoque.controller.EntradaMateriaPrimaImportaXmlController;
import br.com.maximasolutions.estoque.controller.EntradaProdutoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProdutoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.fiscal.modelo.ConfiguracaoFiscalEntradaSaida;
import br.com.maximasolutions.fiscal.service.ConfiguracaoFiscalEntradaSaidaService;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.javafx.formatter.ColumnCenterFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTotal;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaProdutoImportaXmlController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private ConfiguracaoFiscalEntradaSaidaService configuracaoFiscalEntradaSaidaService;
    @Autowired
    private MunicipioService municipioService;
    private Configuracao conf;
    private Fornecedor fornecedor;
    private List<EntradaProdutoItemBean> lista;
    private ObservableList<EntradaProdutoItemBean> entradaProdutoItemList;
    private EntradaProduto entradaProduto;
    private NFNotaInfo nota;
    private HashMap<Integer, Produto> vinculados;
    @FXML
    private VBox vBox;
    @FXML
    private Pane painelTotal;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private DatePicker tfDataEntrada;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private TextField tfChaveAcessoNfe;
    @FXML
    private TextField tfFornecedorCnpj;
    @FXML
    private TextField tfFornecedorNome;
    @FXML
    private TextField tfFornecedorTelefone;
    @FXML
    private TextField tfFornecedorEndereco;
    @FXML
    private TextField tfBaseCalculoICMS;
    @FXML
    private TextField tfValorICMS;
    @FXML
    private TextField tfBaseCalculoICMSST;
    @FXML
    private TextField tfValorICMSST;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorSeguro;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorOutrasDespesas;
    @FXML
    private TextField tfValorIpi;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TableView<EntradaProdutoItemBean> tabela;
    @FXML
    private TableColumn<EntradaProdutoItemBean, String> colProduto;
    @FXML
    private TableColumn<EntradaProdutoItemBean, String> colCodigo;
    @FXML
    private TableColumn<EntradaProdutoItemBean, String> colReferencia;
    @FXML
    private TableColumn<EntradaProdutoItemBean, String> colItem;
    @FXML
    private TableColumn<EntradaProdutoItemBean, String> colUnidade;
    @FXML
    private TableColumn<EntradaProdutoItemBean, BigDecimal> colUnitario;
    @FXML
    private TableColumn<EntradaProdutoItemBean, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<EntradaProdutoItemBean, BigDecimal> colTotalItem;
    @FXML
    private TableColumn<EntradaProdutoItemBean, BigDecimal> colEstoque;
    @FXML
    private TableColumn<EntradaProdutoItemBean, BigDecimal> colPrecoVenda;
    @FXML
    private TableColumn<EntradaProdutoItemBean, BigDecimal> colMargemCusto;
    @FXML
    private TableColumn<EntradaProdutoItemBean, BigDecimal> colMargemVenda;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnFinaliza;
    @FXML
    private CheckBox ccbAtualizarCusto;
    @FXML
    private CheckBox ccbOrdemAlfabetica;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializa(NFNotaInfo nota) {
        this.nota = nota;
        this.entradaProduto = null;
        this.fornecedor = null;
        this.lista = null;
        this.entradaProdutoItemList = FXCollections.observableArrayList();
        this.vinculados = new HashMap();
        this.tfDataEmissao.setValue((Object)nota.getIdentificacao().getDataHoraEmissao().toLocalDate());
        this.tfNumeroNota.setText(nota.getIdentificacao().getNumeroNota());
        this.tfChaveAcessoNfe.setText(nota.getChaveAcesso());
        this.loadDadosFornecedor(nota.getEmitente());
        this.loadValoresTotais(nota.getTotal());
        this.loadItens();
        this.loadTabela();
    }

    private void loadDadosFornecedor(NFNotaInfoEmitente emitente) {
        String cnpj = emitente.getCnpj();
        try {
            this.fornecedor = this.fornecedorService.getByCnpj(cnpj);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(EntradaProdutoImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
            return;
        }
        if (this.fornecedor == null) {
            this.fornecedor = new Fornecedor();
            this.fornecedor.setAtivo(Boolean.TRUE);
            this.fornecedor.setBairro(emitente.getEndereco().getBairro());
            this.fornecedor.setCep(emitente.getEndereco().getCep());
            if (emitente.getEndereco().getComplemento() != null) {
                this.fornecedor.setComplemento(emitente.getEndereco().getComplemento());
            }
            this.fornecedor.setCpf(cnpj);
            this.fornecedor.setDataCadastro(LocalDate.now());
            this.fornecedor.setEndereco(emitente.getEndereco().getLogradouro());
            if (emitente.getNomeFantasia() != null) {
                this.fornecedor.setFantasia(emitente.getNomeFantasia());
            }
            this.fornecedor.setMunicipio(this.municipioService.getByIbge(emitente.getEndereco().getCodigoMunicipio()));
            this.fornecedor.setNome(emitente.getRazaoSocial());
            this.fornecedor.setNumero(emitente.getEndereco().getNumero());
            if (emitente.getInscricaoEstadual() != null) {
                this.fornecedor.setRg(emitente.getInscricaoEstadual());
            }
            if (emitente.getEndereco().getTelefone() != null && !emitente.getEndereco().getTelefone().isEmpty()) {
                this.fornecedor.setTelefone(emitente.getEndereco().getTelefone());
            } else {
                this.fornecedor.setTelefone("00000000");
            }
            try {
                this.fornecedor = this.fornecedorService.save(this.fornecedor);
            }
            catch (MaximaException ex) {
                Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel cadastrar o fornecedor.\n" + ex.getMessage()));
            }
        }
        if (this.fornecedor != null) {
            this.tfFornecedorCnpj.setText(this.fornecedor.getCpf());
            this.tfFornecedorNome.setText(this.fornecedor.getNome().toUpperCase());
            this.tfFornecedorTelefone.setText(this.fornecedor.getTelefone());
            this.tfFornecedorEndereco.setText(this.fornecedor.getEnderecoCompleto());
        }
    }

    private void loadItens() {
        this.lista = new ArrayList();
        for (NFNotaInfoItem item : this.nota.getItens()) {
            BigDecimal valorDescontoTotalItem;
            EntradaProdutoItemBean bean = new EntradaProdutoItemBean();
            if (item.getProduto().getCodigoDeBarras() != null && !item.getProduto().getCodigoDeBarras().isEmpty() && !item.getProduto().getCodigoDeBarras().equals("SEM GTIN")) {
                bean.setCodigo(item.getProduto().getCodigoDeBarras());
            } else {
                bean.setCodigo(item.getProduto().getCodigo());
            }
            bean.setReferencia(item.getProduto().getCodigo());
            if (item.getProduto().getValorDesconto() != null) {
                bean.setDesconto(new BigDecimal(item.getProduto().getValorDesconto()));
            } else {
                bean.setDesconto(BigDecimal.ZERO);
            }
            bean.setDescricao(item.getProduto().getDescricao().toUpperCase());
            if (item.getProduto().getValorFrete() != null) {
                bean.setFrete(new BigDecimal(item.getProduto().getValorFrete()));
            } else {
                bean.setFrete(BigDecimal.ZERO);
            }
            bean.setNumeroItem(item.getNumeroItem());
            bean.setQuantidade(new BigDecimal(item.getProduto().getQuantidadeComercial()));
            bean.setUnidade(item.getProduto().getUnidadeComercial());
            bean.setPrecoTotal(new BigDecimal(item.getProduto().getValorTotalBruto()));
            bean.setPrecoUnitario(new BigDecimal(item.getProduto().getValorUnitario()));
            if (item.getProduto().getValorDesconto() != null && (valorDescontoTotalItem = new BigDecimal(item.getProduto().getValorDesconto())).compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal valorDescontoItem = valorDescontoTotalItem.divide(bean.getQuantidade(), 2, RoundingMode.HALF_EVEN);
                bean.setPrecoUnitario(bean.getPrecoUnitario().subtract(valorDescontoItem));
                bean.setPrecoTotal(bean.getPrecoTotal().subtract(valorDescontoTotalItem));
            }
            Produto produto = this.existeProduto(bean.getCodigo(), bean.getReferencia());
            bean.setProduto(produto);
            bean.setObservacao(item.getInformacoesAdicionais());
            bean.setExiste(Boolean.valueOf(bean.getProduto() != null));
            bean.setNcm(item.getProduto().getNcm());
            bean.setCfopEntrada(item.getProduto().getCfop());
            bean.setNcm(item.getProduto().getNcm());
            bean.setCfopEntrada(item.getProduto().getCfop());
            bean.setOrigem(NFOrigem.NACIONAL);
            bean = this.setImpostoItem(bean, item);
            BigDecimal custoUnitario = bean.getPrecoUnitario();
            if (produto != null) {
                bean.setDescricao(bean.getDescricao() + " (" + produto.getNome().toUpperCase() + ")");
                BigDecimal quantidadeAdicionarEstoque = bean.getQuantidade();
                if (produto.getFatorConversaoEntrada() != null && produto.getFatorConversaoEntrada().compareTo(BigDecimal.ZERO) > 0) {
                    quantidadeAdicionarEstoque = quantidadeAdicionarEstoque.multiply(produto.getFatorConversaoEntrada());
                    custoUnitario = bean.getPrecoTotal().divide(quantidadeAdicionarEstoque, 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
                }
                bean.setUnidadeEntrada(MaximaNumber.quantidadeToString((BigDecimal)bean.getQuantidade()) + " x " + bean.getUnidade());
                if (produto.getUnidade().getSigla().equalsIgnoreCase(bean.getUnidade())) {
                    bean.setUnidadeEstoque(MaximaNumber.quantidadeToString((BigDecimal)bean.getQuantidade()) + " x " + produto.getUnidade().getSigla().toUpperCase());
                } else {
                    bean.setUnidadeEstoque(MaximaNumber.quantidadeToString((BigDecimal)quantidadeAdicionarEstoque) + " x " + produto.getUnidade().getSigla().toUpperCase());
                }
                bean.setEstoque(MaximaNumber.quantidadeToString((BigDecimal)produto.getEstoqueAtual()) + " | " + MaximaNumber.quantidadeToString((BigDecimal)produto.getEstoqueAtual().add(quantidadeAdicionarEstoque)));
                bean.setPrecoVenda(produto.getPrecoVenda());
            } else {
                bean.setUnidadeEntrada(MaximaNumber.quantidadeToString((BigDecimal)bean.getQuantidade()) + " x " + bean.getUnidade());
            }
            bean.setCustoUnitario(custoUnitario);
            this.lista.add(bean);
        }
    }

    private Produto existeProduto(String codigo, String referencia) {
        List listaProdutos = this.produtoService.listaPorCodigoBarras(codigo);
        if (listaProdutos.size() >= 1) {
            return (Produto)listaProdutos.get(0);
        }
        System.out.println("== CODIGO: " + codigo);
        Produto produto = this.produtoService.getByCodigoEntrada(codigo);
        if (produto != null) {
            return produto;
        }
        produto = this.produtoService.getByCodigoEntrada(referencia);
        if (produto != null) {
            return produto;
        }
        if (produto != null) {
            return produto;
        }
        return null;
    }

    private void loadValoresTotais(NFNotaInfoTotal total) {
        this.tfBaseCalculoICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getBaseCalculoICMS()), (int)2));
        this.tfValorICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalICMS()), (int)2));
        this.tfBaseCalculoICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getBaseCalculoICMSST()), (int)2));
        this.tfValorICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalICMSST()), (int)2));
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalDosProdutosServicos()), (int)2));
        this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalFrete()), (int)2));
        this.tfValorSeguro.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalSeguro()), (int)2));
        this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalDesconto()), (int)2));
        this.tfValorOutrasDespesas.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getOutrasDespesasAcessorias()), (int)2));
        this.tfValorIpi.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalIPI()), (int)2));
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalNFe()), (int)2));
    }

    private void finalizaEntrada() {
        boolean continuar;
        if (this.lista == null || this.lista.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto adicionado na lista.");
            return;
        }
        boolean erro = false;
        boolean avisoUnidadeCompra = false;
        boolean avisoPrecoCusto = false;
        for (EntradaProdutoItemBean bean2 : this.lista) {
            if (!bean2.getExiste().booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Item '" + bean2.getNumeroItem() + "': produto n\u00e3o cadastrado."));
                erro = true;
                break;
            }
            if (!bean2.validaUnidade().booleanValue()) {
                avisoUnidadeCompra = true;
                break;
            }
            if (!this.ccbAtualizarCusto.isSelected() || bean2.getCustoUnitario().compareTo(bean2.getProduto().getPrecoVenda()) < 0) continue;
            avisoPrecoCusto = true;
            break;
        }
        if (erro) {
            return;
        }
        if (avisoUnidadeCompra && !(continuar = MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"AVISO: Produto(s) com unidade de compra diferente da unidade de controle de estoque. Desejar continuar?"))) {
            return;
        }
        if (avisoPrecoCusto && !(continuar = MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"AVISO: Produto(s) com pre\u00e7o de custo maior ou igual ao pre\u00e7o de venda. Deseja continuar?"))) {
            return;
        }
        ArrayList entradaProdutoItems = new ArrayList();
        this.lista.forEach(bean -> entradaProdutoItems.add(this.createEntradaProdutoItem(bean.getProduto(), bean.getPrecoUnitario(), bean.getPrecoVenda(), bean.getQuantidade(), bean.getCfopEntrada(), bean)));
        try {
            this.entradaProdutoService.salva(this.createEntradaProduto(), entradaProdutoItems);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entrada de produto cadastrada com sucesso.");
            Stage form = (Stage)this.btnFinaliza.getScene().getWindow();
            form.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EntradaProdutoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel salvar a entrada de produtos.\nCausa: " + ex.getMessage()));
        }
    }

    private void cancelaEntrada() {
    }

    private void loadTabela() {
        this.entradaProdutoItemList.clear();
        if (this.ccbOrdemAlfabetica.isSelected()) {
            Collections.sort(this.lista);
        }
        this.entradaProdutoItemList.addAll((Collection)this.lista);
        this.tabela.setItems(this.entradaProdutoItemList);
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numeroItem"));
        this.colReferencia.setCellValueFactory((Callback)new PropertyValueFactory("referencia"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("unidadeEstoque"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidadeEntrada"));
        this.colEstoque.setCellValueFactory((Callback)new PropertyValueFactory("estoque"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("custoUnitario"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colPrecoVenda.setCellValueFactory((Callback)new PropertyValueFactory("precoVenda"));
        this.colMargemCusto.setCellValueFactory((Callback)new PropertyValueFactory("margemLucroCusto"));
        this.colMargemVenda.setCellValueFactory((Callback)new PropertyValueFactory("margemLucroVenda"));
        this.colUnidade.setCellFactory((Callback)new ColumnCenterFormatter());
        this.colEstoque.setCellFactory((Callback)new ColumnCenterFormatter());
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colPrecoVenda.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colMargemCusto.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colMargemVenda.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setRowFactory(row -> new /* Unavailable Anonymous Inner Class!! */);
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaEntrada());
        this.btnCancela.setOnAction(event -> this.cancelaEntrada());
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                // empty if block
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.ccbOrdemAlfabetica.selectedProperty().addListener(evt -> this.loadTabela());
    }

    private void cadastraProduto() {
        EntradaProdutoItemBean bean = (EntradaProdutoItemBean)this.tabela.getSelectionModel().getSelectedItem();
        Produto produto = bean.getExiste() != false ? bean.getProduto() : this.cadastroNovoProduto(bean);
        try {
            Stage produtoForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoForm.fxml", "Cadastro de Produto");
            ProdutoFormController controller = (ProdutoFormController)produtoForm.getUserData();
            controller.inicializa(produto);
            produtoForm.showAndWait();
            produto = controller.getProdutoCadastrado();
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaProdutoImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de cadastro de produto ( ProdutoForm.fxml ).");
        }
        this.atualizaTabela(bean, produto);
        this.loadTabela();
    }

    private void atualizaTabela(EntradaProdutoItemBean item, Produto produto) {
        if (produto == null || produto.getId() == null) {
            return;
        }
        for (EntradaProdutoItemBean bean : this.lista) {
            if (!bean.getNumeroItem().equals(item.getNumeroItem())) continue;
            bean.setProduto(produto);
            bean.setExiste(Boolean.valueOf(true));
            BigDecimal custoUnitario = bean.getPrecoUnitario();
            if (produto != null) {
                BigDecimal quantidadeAdicionarEstoque = bean.getQuantidade();
                if (produto.getFatorConversaoEntrada() != null && produto.getFatorConversaoEntrada().compareTo(BigDecimal.ZERO) > 0) {
                    quantidadeAdicionarEstoque = quantidadeAdicionarEstoque.multiply(produto.getFatorConversaoEntrada());
                    custoUnitario = bean.getPrecoTotal().divide(quantidadeAdicionarEstoque, 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
                }
                bean.setUnidadeEntrada(MaximaNumber.quantidadeToString((BigDecimal)bean.getQuantidade()) + " x " + bean.getUnidade());
                if (produto.getUnidade().getSigla().equalsIgnoreCase(bean.getUnidade())) {
                    bean.setUnidadeEstoque(MaximaNumber.quantidadeToString((BigDecimal)bean.getQuantidade()) + " x " + produto.getUnidade().getSigla().toUpperCase());
                } else {
                    bean.setUnidadeEstoque(MaximaNumber.quantidadeToString((BigDecimal)quantidadeAdicionarEstoque) + " x " + produto.getUnidade().getSigla().toUpperCase());
                }
                bean.setEstoque(MaximaNumber.quantidadeToString((BigDecimal)produto.getEstoqueAtual()) + " | " + MaximaNumber.quantidadeToString((BigDecimal)produto.getEstoqueAtual().add(quantidadeAdicionarEstoque)));
                bean.setPrecoVenda(produto.getPrecoVenda());
            } else {
                bean.setUnidadeEntrada(MaximaNumber.quantidadeToString((BigDecimal)bean.getQuantidade()) + " x " + bean.getUnidade());
            }
            bean.setCustoUnitario(custoUnitario);
            break;
        }
    }

    private Produto cadastroNovoProduto(EntradaProdutoItemBean bean) {
        Produto produto = new Produto();
        produto.setNome(bean.getDescricao());
        produto.setNcm(bean.getNcm());
        produto.setCodigo(bean.getCodigo());
        produto.setReferencia(bean.getReferencia());
        Unidade unidade = null;
        try {
            unidade = this.unidadeService.getBySigla(bean.getUnidade());
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(EntradaProdutoImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
            return null;
        }
        if (unidade == null) {
            unidade = new Unidade();
            unidade.setNome(bean.getUnidade());
            unidade.setSigla(bean.getUnidade());
            try {
                unidade = this.unidadeService.save(unidade);
            }
            catch (MaximaException ex) {
                Logger.getLogger(EntradaProdutoImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel cadastrar o tipo de unidade.");
                return null;
            }
        }
        produto.setUnidade(unidade);
        produto.setEstoqueInicial(BigDecimal.ZERO);
        produto.setEstoqueAtual(BigDecimal.ZERO);
        produto.setEstoqueMinimo(BigDecimal.ZERO);
        produto.setUltimoCusto(bean.getPrecoUnitario());
        produto.setCodigoEntrada(bean.getCodigo());
        produto.setUnidadeEntrada(unidade);
        ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida = this.configuracaoFiscalEntradaSaidaService.getByCfopEntrada(bean.getCfopEntrada());
        if (configuracaoFiscalEntradaSaida == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhuma configura\u00e7\u00e3o cadastrada para este CFOP de entrada.\nOs dados fiscais devem ser preenchidos manualmente.");
        } else {
            produto.setCfop(configuracaoFiscalEntradaSaida.getCfopSaida());
            produto.setCfopInterEstad(configuracaoFiscalEntradaSaida.getCfopSaidaInterEstadual());
            produto.setOrigem(configuracaoFiscalEntradaSaida.getOrigem());
            produto.setIcmsSN(configuracaoFiscalEntradaSaida.getCsosn());
            produto.setAliquotaCreditoICMS(configuracaoFiscalEntradaSaida.getAliquotaCreditoICMS());
            produto.setCofins(configuracaoFiscalEntradaSaida.getCofins());
            produto.setAliquotaCofins(configuracaoFiscalEntradaSaida.getAliquotaCofins());
            produto.setPis(configuracaoFiscalEntradaSaida.getPis());
            produto.setAliquotaPis(configuracaoFiscalEntradaSaida.getAliquotaPis());
            produto.setIpi(configuracaoFiscalEntradaSaida.getIpi());
            produto.setAliquotaIpi(configuracaoFiscalEntradaSaida.getAliquotaIpi());
        }
        return produto;
    }

    private void vinculaProduto() {
        block5: {
            EntradaProdutoItemBean bean = (EntradaProdutoItemBean)this.tabela.getSelectionModel().getSelectedItem();
            if (bean == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum item da tabela selecionado.");
                return;
            }
            try {
                Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
                ProdutoPesquisaController controller = (ProdutoPesquisaController)form.getUserData();
                form.showAndWait();
                Produto produto = controller.getProdutoSelecionado();
                if (produto == null) break block5;
                produto.setCodigo(bean.getCodigo());
                produto.setCodigoEntrada(bean.getReferencia());
                try {
                    produto = this.produtoService.save(produto);
                }
                catch (MaximaException maximaException) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)maximaException.getMessage());
                }
                this.vinculados.put(bean.getNumeroItem(), produto);
                this.atualizaTabela(bean, produto);
            }
            catch (IOException ex) {
                Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo de pesquisa de mat\u00e9ria prima.");
            }
        }
        this.loadTabela();
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuCadastraProduto = new MenuItem("Cadastrar/Editar Produto");
        menuCadastraProduto.setOnAction(event -> this.cadastraProduto());
        MenuItem menuVinculaMateriaPrima = new MenuItem("Vincular");
        menuVinculaMateriaPrima.setOnAction(event -> this.vinculaProduto());
        cm.getItems().add((Object)menuCadastraProduto);
        cm.getItems().add((Object)menuVinculaMateriaPrima);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFinaliza.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnCancela.setGraphic((Node)maximaIcone.cancel_24());
    }

    private void carregaCombos() {
    }

    private void carregaMascaras() {
    }

    private EntradaProdutoItem createEntradaProdutoItem(Produto produto, BigDecimal precoCusto, BigDecimal precoVenda, BigDecimal quantidade, String cfop, EntradaProdutoItemBean bean) {
        EntradaProdutoItem item = new EntradaProdutoItem();
        item.setAtivo(Boolean.TRUE);
        item.setCfopEntrada(cfop);
        item.setDataOperacao(LocalDate.now());
        item.setDescricao(produto.getNome().toUpperCase());
        item.setNumItem(Integer.valueOf(1));
        item.setProduto(produto);
        item.setPrecoCusto(precoCusto);
        item.setPrecoVenda(precoVenda);
        item.setQuantidade(quantidade);
        item.setTotalCusto(item.getPrecoCusto().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setUnidade(produto.getUnidade().getSigla());
        item.setCodigoBarras(produto.getCodigo());
        item.setReferencia(produto.getReferencia());
        item.setObservacao(bean.getObservacao());
        item.setCfopEntrada(bean.getCfopEntrada());
        item.setNcm(bean.getNcm());
        item.setOrigem(bean.getOrigem());
        item.setCst(bean.getCst());
        item.setCsosn(bean.getCsosn());
        item.setPis(bean.getPis());
        item.setCofins(bean.getCofins());
        item.setIpi(bean.getIpi());
        item.setAliquotaCreditoIcms(bean.getAliquotaCreditoIcms());
        item.setValorCreditoIcms(bean.getValorCreditoIcms());
        item.setBaseCalculoIcms(bean.getBaseCalculoIcms());
        item.setAliquotaIcms(bean.getAliquotaIcms());
        item.setValorIcms(bean.getValorIcms());
        item.setBaseCalculoPis(bean.getBaseCalculoPis());
        item.setAliquotaPis(bean.getAliquotaPis());
        item.setValorPis(bean.getValorPis());
        item.setBaseCalculoCofins(bean.getBaseCalculoCofins());
        item.setAliquotaCofins(bean.getAliquotaCofins());
        item.setValorCofins(bean.getValorCofins());
        item.setBaseCalculoIpi(bean.getBaseCalculoIpi());
        item.setAliquotaIpi(bean.getAliquotaIpi());
        item.setValorIpi(bean.getValorIpi());
        item.setFatorConversao(bean.getProduto().getFatorConversaoEntrada());
        return item;
    }

    private EntradaProduto createEntradaProduto() {
        if (this.entradaProduto == null) {
            this.entradaProduto = new EntradaProduto();
        }
        this.entradaProduto.setAtualizarCusto(Boolean.valueOf(this.ccbAtualizarCusto.isSelected()));
        this.entradaProduto.setDataEmissao((LocalDate)this.tfDataEmissao.getValue());
        this.entradaProduto.setDataEntrada((LocalDate)this.tfDataEntrada.getValue());
        this.entradaProduto.setDataOperacao(LocalDateTime.now());
        this.entradaProduto.setBaseCalculoIcms(MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoICMS.getText()));
        this.entradaProduto.setValorIcms(MaximaNumber.moneyToBigDecimal((String)this.tfValorICMS.getText()));
        this.entradaProduto.setBaseCalculoIcmsSt(MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoICMSST.getText()));
        this.entradaProduto.setValorIcmsSt(MaximaNumber.moneyToBigDecimal((String)this.tfValorICMSST.getText()));
        this.entradaProduto.setValorProdutos(BigDecimal.ZERO);
        this.entradaProduto.setFrete(MaximaNumber.moneyToBigDecimal((String)this.tfValorFrete.getText()));
        this.entradaProduto.setSeguro(MaximaNumber.moneyToBigDecimal((String)this.tfValorSeguro.getText()));
        this.entradaProduto.setDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfValorDesconto.getText()));
        this.entradaProduto.setDespesa(MaximaNumber.moneyToBigDecimal((String)this.tfValorOutrasDespesas.getText()));
        this.entradaProduto.setIpi(MaximaNumber.moneyToBigDecimal((String)this.tfValorIpi.getText()));
        this.entradaProduto.setTotal(MaximaNumber.moneyToBigDecimal((String)this.tfValorTotal.getText()));
        this.entradaProduto.setExcluida(Boolean.FALSE);
        this.entradaProduto.setFornecedor(this.fornecedor);
        this.entradaProduto.setHistorico("");
        this.entradaProduto.setHistoricoDespesa("");
        this.entradaProduto.setNumeroNota(MaximaUtils.getText((String)this.tfNumeroNota.getText()));
        this.entradaProduto.setNfeChaveAcesso(MaximaUtils.removeCaracteres((String)this.tfChaveAcessoNfe.getText()));
        return this.entradaProduto;
    }

    private EntradaProdutoItemBean setImpostoItem(EntradaProdutoItemBean bean, NFNotaInfoItem item) {
        if (item.getImposto().getIcms().getIcms00() != null) {
            bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms00().getPercentualAliquota()));
            bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms00().getValorBaseCalculo()));
            bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms00().getValorTributo()));
            bean.setCst(item.getImposto().getIcms().getIcms00().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcms10() != null) {
            bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms10().getPercentualAliquota()));
            bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms10().getValorBaseCalculo()));
            bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms10().getValorTributo()));
            bean.setCst(item.getImposto().getIcms().getIcms10().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcms20() != null) {
            bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms20().getPercentualAliquota()));
            bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms20().getValorBCICMS()));
            bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms20().getValorTributo()));
            bean.setCst(item.getImposto().getIcms().getIcms20().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcms30() != null) {
            bean.setCst(item.getImposto().getIcms().getIcms30().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcms40() != null) {
            bean.setAliquotaIcms(BigDecimal.ZERO);
            bean.setBaseCalculoIcms(BigDecimal.ZERO);
            bean.setValorIcms(BigDecimal.ZERO);
            bean.setCst(item.getImposto().getIcms().getIcms40().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcms51() != null) {
            bean.setCst(item.getImposto().getIcms().getIcms51().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcms60() != null) {
            bean.setAliquotaIcms(BigDecimal.ZERO);
            bean.setBaseCalculoIcms(BigDecimal.ZERO);
            bean.setValorIcms(BigDecimal.ZERO);
            bean.setCst(item.getImposto().getIcms().getIcms60().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcms70() != null) {
            bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms70().getPercentualAliquota()));
            bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms70().getValorBC()));
            bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms70().getValorTributo()));
            bean.setAliquotaIcmsST(new BigDecimal(item.getImposto().getIcms().getIcms70().getPercentualAliquotaImpostoICMSST()));
            bean.setBaseCalculoIcmsST(new BigDecimal(item.getImposto().getIcms().getIcms70().getValorBCST()));
            bean.setValorIcmsST(new BigDecimal(item.getImposto().getIcms().getIcms70().getValorICMSST()));
        }
        if (item.getImposto().getIcms().getIcms90() != null) {
            if (item.getImposto().getIcms().getIcms90().getPercentualAliquota() != null) {
                bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms90().getPercentualAliquota()));
                bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms90().getValorBC()));
                bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms90().getValorTributo()));
            } else {
                bean.setAliquotaIcms(BigDecimal.ZERO);
                bean.setBaseCalculoIcms(BigDecimal.ZERO);
                bean.setValorIcms(BigDecimal.ZERO);
            }
            bean.setCst(item.getImposto().getIcms().getIcms90().getSituacaoTributaria());
        }
        if (item.getImposto().getIcms().getIcmssn101() != null) {
            bean.setAliquotaCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn101().getPercentualAliquotaAplicavelCalculoCreditoSN()));
            bean.setValorCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn101().getValorCreditoICMSSN()));
            bean.setCsosn(item.getImposto().getIcms().getIcmssn101().getSituacaoOperacaoSN());
        }
        if (item.getImposto().getIcms().getIcmssn102() != null) {
            bean.setCsosn(item.getImposto().getIcms().getIcmssn102().getSituacaoOperacaoSN());
        }
        if (item.getImposto().getIcms().getIcmssn201() != null) {
            bean.setAliquotaCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn201().getPercentualAliquotaAplicavelCalculoCreditoSN()));
            bean.setValorCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn201().getValorCreditoICMSSN()));
            bean.setCsosn(item.getImposto().getIcms().getIcmssn201().getSituacaoOperacaoSN());
        }
        if (item.getImposto().getIcms().getIcmssn202() != null) {
            bean.setCsosn(item.getImposto().getIcms().getIcmssn202().getSituacaoOperacaoSN());
        }
        if (item.getImposto().getIcms().getIcmssn500() != null) {
            bean.setCsosn(item.getImposto().getIcms().getIcmssn500().getSituacaoOperacaoSN());
        }
        if (item.getImposto().getIcms().getIcmssn900() != null) {
            bean.setCsosn(item.getImposto().getIcms().getIcmssn900().getSituacaoOperacaoSN());
        }
        if (item.getImposto().getPis() != null) {
            if (item.getImposto().getPis().getAliquota() != null) {
                bean.setPis(item.getImposto().getPis().getAliquota().getSituacaoTributaria());
                bean.setBaseCalculoPis(new BigDecimal(item.getImposto().getPis().getAliquota().getValorBaseCalculo()));
                bean.setAliquotaPis(new BigDecimal(item.getImposto().getPis().getAliquota().getPercentualAliquota()));
                bean.setValorPis(new BigDecimal(item.getImposto().getPis().getAliquota().getValorTributo()));
            } else {
                if (item.getImposto().getPis().getNaoTributado() != null) {
                    bean.setPis(item.getImposto().getPis().getNaoTributado().getSituacaoTributaria());
                }
                if (item.getImposto().getPis().getOutrasOperacoes() != null) {
                    bean.setPis(item.getImposto().getPis().getOutrasOperacoes().getSituacaoTributaria());
                }
                bean.setValorPis(BigDecimal.ZERO);
            }
        } else {
            bean.setValorPis(BigDecimal.ZERO);
        }
        if (item.getImposto().getCofins() != null) {
            if (item.getImposto().getCofins().getAliquota() != null) {
                bean.setCofins(item.getImposto().getCofins().getAliquota().getSituacaoTributaria());
                bean.setBaseCalculoCofins(new BigDecimal(item.getImposto().getCofins().getAliquota().getValorBaseCalculo()));
                bean.setAliquotaCofins(new BigDecimal(item.getImposto().getCofins().getAliquota().getPercentualAliquota()));
                bean.setValorCofins(new BigDecimal(item.getImposto().getCofins().getAliquota().getValor()));
            } else {
                if (item.getImposto().getCofins().getNaoTributavel() != null) {
                    bean.setCofins(item.getImposto().getCofins().getNaoTributavel().getSituacaoTributaria());
                }
                if (item.getImposto().getCofins().getOutrasOperacoes() != null) {
                    bean.setCofins(item.getImposto().getCofins().getOutrasOperacoes().getSituacaoTributaria());
                }
                bean.setValorCofins(BigDecimal.ZERO);
            }
        } else {
            bean.setValorCofins(BigDecimal.ZERO);
        }
        if (item.getImposto().getIpi() != null) {
            if (item.getImposto().getIpi().getTributado() != null) {
                bean.setIpi(item.getImposto().getIpi().getTributado().getSituacaoTributaria());
                if (item.getImposto().getIpi().getTributado().getValorBaseCalculo() != null) {
                    bean.setBaseCalculoIpi(new BigDecimal(item.getImposto().getIpi().getTributado().getValorBaseCalculo()));
                }
                if (item.getImposto().getIpi().getTributado().getPercentualAliquota() != null) {
                    bean.setAliquotaIpi(new BigDecimal(item.getImposto().getIpi().getTributado().getPercentualAliquota()));
                }
                bean.setValorIpi(new BigDecimal(item.getImposto().getIpi().getTributado().getValorTributo()));
            } else {
                bean.setIpi(item.getImposto().getIpi().getNaoTributado().getSituacaoTributaria());
                bean.setValorIpi(BigDecimal.ZERO);
            }
        } else {
            bean.setValorIpi(BigDecimal.ZERO);
        }
        return bean;
    }

    private void atualizaCodigo() {
        EntradaProdutoItemBean bean = (EntradaProdutoItemBean)this.tabela.getSelectionModel().getSelectedItem();
        if (bean == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum item da tabela selecionado.");
            return;
        }
        System.out.println("--- ean code: " + bean.getCodigo());
    }
}

