/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProdutoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.geral.controller.FornecedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaProdutoSimplificadaFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Configuracao conf;
    private Fornecedor fornecedor;
    private Produto produto;
    private ObservableList<EntradaProdutoItem> entradaProdutoItemList;
    private EntradaProduto entradaProduto;
    private List<EntradaProdutoItem> itens;
    @FXML
    private VBox vBox;
    @FXML
    private Pane painelTotal;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private DatePicker tfDataEntrada;
    @FXML
    private TextField tfFornecedorNome;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private ComboBox<Produto> cbbProduto;
    @FXML
    private TableView<EntradaProdutoItem> tabela;
    @FXML
    private TableColumn<EntradaProdutoItem, String> colProduto;
    @FXML
    private TableColumn<EntradaProdutoItem, String> colItem;
    @FXML
    private TableColumn<EntradaProdutoItem, BigDecimal> colQuantidade;
    @FXML
    private Button btnFornecedorPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnFinaliza;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializa() {
        this.conf = this.configuracaoService.load();
        this.tfDataEmissao.setValue((Object)LocalDate.now());
    }

    public void inicializaEntrada(EntradaProduto entradaProduto1) {
        if (entradaProduto1 == null) {
            String codigoPadraoFornecedor = MaximaConfig.getInstance().getProperty("entrada_produto_fornecedor", "");
            this.fornecedor = codigoPadraoFornecedor.isEmpty() ? null : this.fornecedorService.getById(Long.valueOf(Long.parseLong(codigoPadraoFornecedor)));
            this.entradaProduto = null;
            this.itens = new ArrayList();
        } else {
            this.entradaProduto = entradaProduto1;
            this.fornecedor = this.entradaProduto.getFornecedor();
            this.itens = this.entradaProdutoService.listItens(this.entradaProduto);
            this.tfDataEmissao.setValue((Object)this.entradaProduto.getDataEmissao());
            this.tfDataEntrada.setValue((Object)this.entradaProduto.getDataEntrada());
        }
        this.inicializaItem();
        this.loadDadosFornecedor();
        Stage stage = (Stage)this.vBox.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        this.tfDataEmissao.requestFocus();
    }

    private void inicializaItem() {
        this.produto = null;
        this.cbbProduto.getSelectionModel().select((Object)this.produto);
        this.tfQuantidade.setText("");
        this.loadItens();
        this.cbbProduto.requestFocus();
    }

    private void loadItens() {
        this.entradaProdutoItemList = FXCollections.observableArrayList();
        this.entradaProdutoItemList.clear();
        BigDecimal valorProdutos = BigDecimal.ZERO;
        for (EntradaProdutoItem item : this.itens) {
            if (item.getExcluido().booleanValue()) continue;
            valorProdutos = valorProdutos.add(item.getTotalCusto());
            this.entradaProdutoItemList.add((Object)item);
        }
        this.tabela.setItems(this.entradaProdutoItemList);
    }

    private void addItem() {
        this.produto = (Produto)this.cbbProduto.getSelectionModel().getSelectedItem();
        if (!this.validaItemForm()) {
            return;
        }
        this.itens.add(this.createEntradaProdutoItem(this.produto, this.produto.getUltimoCusto(), this.produto.getPrecoVenda(), MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText())));
        this.inicializaItem();
    }

    private void editaItem() {
    }

    private void deleteItem() {
        EntradaProdutoItem item = (EntradaProdutoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto selecionado.");
            return;
        }
        int cont = 0;
        for (EntradaProdutoItem i : this.itens) {
            if (i.getNumItem().equals(item.getNumItem())) {
                i.setExcluido(Boolean.TRUE);
                break;
            }
            ++cont;
        }
        cont = 0;
        for (EntradaProdutoItem i : this.itens) {
            ++cont;
            if (i.getExcluido().booleanValue()) continue;
            i.setNumItem(Integer.valueOf(cont));
        }
        this.inicializaItem();
    }

    private void finalizaEntrada() {
        if (!this.validaPedidoForm()) {
            return;
        }
        try {
            this.entradaProdutoService.salva(this.createEntradaProduto(), this.itens);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entrada de produto cadastrada com sucesso.");
            Stage form = (Stage)this.btnFinaliza.getScene().getWindow();
            form.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EntradaProdutoSimplificadaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel salvar a entrada de produtos.\nCausa: " + ex.getMessage()));
        }
    }

    private void cancelaEntrada() {
        this.inicializaEntrada(null);
    }

    private boolean validaItemForm() {
        boolean valido = true;
        if (this.produto == null) {
            this.cbbProduto.getStyleClass().add((Object)"error");
            this.cbbProduto.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbProduto.getStyleClass().remove((Object)"error");
            this.cbbProduto.getStyleClass().remove((Object)"error");
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoForm() {
        boolean valido = true;
        if (this.tfDataEmissao.getValue() == null) {
            this.tfDataEmissao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataEmissao.getStyleClass().remove((Object)"error");
        }
        if (this.fornecedor == null) {
            this.tfFornecedorNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfFornecedorNome.getStyleClass().remove((Object)"error");
        }
        if (this.entradaProdutoItemList == null || this.entradaProdutoItemList.isEmpty()) {
            this.tabela.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tabela.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaEntrada());
        this.btnCancela.setOnAction(event -> this.cancelaEntrada());
        this.btnFornecedorPesquisa.setOnAction(event -> this.pesquisaFornecedorForm());
        this.btnProdutoAdd.setOnAction(event -> this.addItem());
        this.vBox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F2) {
                this.pesquisaFornecedorForm();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.TAB) {
                System.out.println("EVENTO: " + event.getCode() + " - " + KeyCode.TAB);
                BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
                if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
                    this.tfQuantidade.requestFocus();
                    this.tfQuantidade.selectAll();
                    return;
                }
            }
        });
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFornecedorPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.getIconeNovo());
    }

    private void carregaCombos() {
        this.cbbProduto.setItems(FXCollections.observableArrayList((Collection)this.produtoService.pesquisa("")));
        this.cbbProduto.setCellFactory((Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void pesquisaFornecedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorPesquisa.fxml", "Pesquisa de fornecedor");
            FornecedorPesquisaController controller = (FornecedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa("");
            stage.showAndWait();
            Fornecedor fornecedorPesquisa = controller.getFornecedorSelecionado();
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'FornecedorPesquisa'");
        }
    }

    private void loadDadosFornecedor() {
        if (this.fornecedor != null) {
            this.tfFornecedorNome.setText(this.fornecedor.getNome().toUpperCase());
        } else {
            this.tfFornecedorNome.setText("");
        }
    }

    private void carregaMascaras() {
    }

    private void closeWindowEvent(WindowEvent event) {
    }

    private EntradaProdutoItem createEntradaProdutoItem(Produto produto, BigDecimal precoCusto, BigDecimal precoVenda, BigDecimal quantidade) {
        EntradaProdutoItem item = new EntradaProdutoItem();
        item.setAtivo(Boolean.TRUE);
        item.setDataOperacao(LocalDate.now());
        item.setDescricao(produto.getNome().toUpperCase());
        item.setNumItem(Integer.valueOf(this.itens.size() + 1));
        item.setProduto(produto);
        item.setPrecoCusto(precoCusto);
        item.setPrecoVenda(precoVenda);
        item.setQuantidade(quantidade);
        item.setTotalCusto(item.getPrecoCusto().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setUnidade(produto.getUnidade().getSigla());
        item.setCodigoBarras(produto.getCodigo());
        item.setReferencia(produto.getReferencia());
        return item;
    }

    private EntradaProduto createEntradaProduto() {
        if (this.entradaProduto == null) {
            this.entradaProduto = new EntradaProduto();
        }
        this.entradaProduto.setDataEmissao((LocalDate)this.tfDataEmissao.getValue());
        this.entradaProduto.setDataEntrada((LocalDate)this.tfDataEmissao.getValue());
        this.entradaProduto.setDataOperacao(LocalDateTime.now());
        this.entradaProduto.setDesconto(BigDecimal.ZERO);
        this.entradaProduto.setDespesa(BigDecimal.ZERO);
        this.entradaProduto.setExcluida(Boolean.FALSE);
        this.entradaProduto.setFornecedor(this.fornecedor);
        this.entradaProduto.setFrete(BigDecimal.ZERO);
        this.entradaProduto.setHistorico("");
        this.entradaProduto.setHistoricoDespesa("");
        this.entradaProduto.setNumeroNota("");
        this.entradaProduto.setNfeChaveAcesso("");
        this.entradaProduto.setTotal(BigDecimal.ZERO);
        this.entradaProduto.setValorProdutos(BigDecimal.ZERO);
        return this.entradaProduto;
    }
}

