/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.EstoqueBalancoFormController;
import br.com.maximasolutions.estoque.controller.EstoqueBalancoViewController;
import br.com.maximasolutions.estoque.modelo.EstoqueBalanco;
import br.com.maximasolutions.estoque.service.EstoqueBalancoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EstoqueBalancoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnZeraEstoque;
    @FXML
    private TableView<EstoqueBalanco> tabela;
    @FXML
    private TableColumn<EstoqueBalanco, String> colData;
    @FXML
    private TableColumn<EstoqueBalanco, String> colHistorico;
    @FXML
    private TableColumn<EstoqueBalanco, String> colUsuario;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EstoqueBalancoService estoqueBalancoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<EstoqueBalanco> estoqueBalancoList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.estoqueBalancoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.EstoqueBalanco);
    }

    private void edita() {
        EstoqueBalanco selecionado = (EstoqueBalanco)this.tabela.getSelectionModel().getSelectedItem();
        if (selecionado == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/estoqueBalanco/EstoqueBalancoView.fxml", "Balan\u00e7o de estoque");
            EstoqueBalancoViewController controller = (EstoqueBalancoViewController)form.getUserData();
            controller.inicializaBalanco(selecionado);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EstoqueBalancoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir form de cadastro de balan\u00e7o.");
        }
    }

    private void entradaManual() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.abreForm(null);
    }

    private void abreForm(EstoqueBalanco estoqueBalanco) {
        try {
            Stage form = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/estoqueBalanco/EstoqueBalancoForm.fxml", "Balan\u00e7o de estoque");
            EstoqueBalancoFormController controller = (EstoqueBalancoFormController)form.getUserData();
            controller.inicializaBalanco();
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EstoqueBalancoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir form de cadastro de balan\u00e7o.");
        }
    }

    private void zerarEstoque() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja zerar o estoque de TODOS os produtos?")) {
            return;
        }
        try {
            this.estoqueBalancoService.zerarEstoque();
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Estoque zerado com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EstoqueBalancoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void delete() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        EstoqueBalanco estoqueBalanco = (EstoqueBalanco)this.tabela.getSelectionModel().getSelectedItem();
        if (estoqueBalanco == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um balan\u00e7o para remover.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover o balan\u00e7o?")) {
            return;
        }
        try {
            this.estoqueBalancoService.delete(estoqueBalanco);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Balan\u00e7o removido com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EstoqueBalancoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel remover o balan\u00e7o.\nCausa:" + ex.getMessage()));
        }
    }

    private void setColumnProperties() {
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataOperacao"));
        this.colHistorico.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colUsuario.setCellValueFactory((Callback)new PropertyValueFactory("usuario"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
    }

    private void loadTabela() {
        this.estoqueBalancoList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.estoqueBalancoService.lista(inicio, fim, Boolean.valueOf(this.ccbExcluida.isSelected()), filtro);
        this.estoqueBalancoList.addAll((Collection)list);
        this.tabela.setItems(this.estoqueBalancoList);
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnNovo.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.entradaManual());
        this.btnZeraEstoque.setOnAction(evt -> this.zerarEstoque());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.edita();
            }
        });
    }
}

