/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.EstoqueBalanco;
import br.com.maximasolutions.estoque.modelo.EstoqueBalancoProduto;
import br.com.maximasolutions.estoque.service.EstoqueBalancoService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EstoqueBalancoViewController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EstoqueBalancoService estoqueBalancoService;
    private ObservableList<EstoqueBalancoProduto> produtoList;
    private List<EstoqueBalancoProduto> itens;
    private EstoqueBalanco estoqueBalanco;
    @FXML
    private VBox vBox;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TableView<EstoqueBalancoProduto> tabela;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colProduto;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colCodigo;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colReferencia;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colItem;
    @FXML
    private TableColumn<EstoqueBalancoProduto, BigDecimal> colEstoqueAnterior;
    @FXML
    private TableColumn<EstoqueBalancoProduto, BigDecimal> colEstoqueAtual;
    @FXML
    private Button btnFinaliza;

    public void initialize(URL location, ResourceBundle resources) {
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
    }

    public void inicializaBalanco(EstoqueBalanco estoqueBalanco) {
        this.tfDataEmissao.setValue((Object)estoqueBalanco.getDataOperacao());
        this.tfHistorico.setText(estoqueBalanco.getHistorico());
        this.estoqueBalanco = estoqueBalanco;
        this.itens = this.estoqueBalancoService.produtos(this.estoqueBalanco);
        this.loadItens();
    }

    private void loadItens() {
        this.produtoList = FXCollections.observableArrayList((Collection)this.itens);
        this.tabela.getItems().clear();
        this.tabela.setItems(this.produtoList);
    }

    private void finalizaBalanco() {
        this.fechaForm();
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colReferencia.setCellValueFactory((Callback)new PropertyValueFactory("referencia"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colEstoqueAnterior.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAnterior"));
        this.colEstoqueAtual.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colEstoqueAtual.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colEstoqueAnterior.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaBalanco());
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFinaliza.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void fechaForm() {
        Stage form = (Stage)this.vBox.getScene().getWindow();
        form.close();
    }
}

