/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.estoque.bean.EtiquetaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;

public class EtiquetasController {
    public void frutaNoPalito(StageManager stageManager, Produto produto, Integer quantidade, String impressora) {
        try {
            System.out.println("== Imprimir etiqueta jasper ==");
            InputStream file = this.getClass().getResourceAsStream("/jasper/teste_etiqueta.jasper");
            ArrayList<EtiquetaProduto> array_qtd = new ArrayList<EtiquetaProduto>();
            for (int i = 0; i < quantidade; ++i) {
                array_qtd.add(new EtiquetaProduto(produto.getNome(), produto.getComposicao()));
            }
            JRBeanCollectionDataSource dados_qtd = new JRBeanCollectionDataSource(array_qtd);
            HashMap parametros = new HashMap();
            JasperPrint printer = JasperFillManager.fillReport((InputStream)file, parametros, (JRDataSource)dados_qtd);
            this.imprime(printer, impressora);
        }
        catch (JRException jRException) {
            MaximaAlert.aviso((StageManager)stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel imprimir as etiquetas.");
        }
    }

    private void imprime(JasperPrint printer, String impressora) throws JRException {
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(new Copies(1));
        HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
        printServiceAttributeSet.add(new PrinterName(impressora, Locale.getDefault()));
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(printer));
        SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
        configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)printRequestAttributeSet);
        configuration.setPrintServiceAttributeSet((PrintServiceAttributeSet)printServiceAttributeSet);
        exporter.setConfiguration((ExporterConfiguration)configuration);
        configuration.setDisplayPageDialog(Boolean.valueOf(false));
        configuration.setDisplayPrintDialog(Boolean.valueOf(false));
        exporter.setConfiguration((ExporterConfiguration)configuration);
        System.out.println("Inicializando impress\u00e3o");
        exporter.exportReport();
        System.out.println("Impress\u00e3o finalizada");
        System.out.println("== Impress\u00e3o finalizada ==");
    }
}

