/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MateriaPrimaFormController
extends MaximaController
implements Initializable {
    private MateriaPrima materiaPrima;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MateriaPrimaService materiaPrimaService;
    @Autowired
    private UnidadeService unidadeService;
    @FXML
    private TabPane tabPane;
    @FXML
    private TextField tfId;
    @FXML
    private CheckBox cbAtivo;
    @FXML
    private Button btnSalva;
    @FXML
    private ComboBox<Unidade> cbbUnidade;
    @FXML
    private ComboBox<Unidade> cbbUnidadeEntrada;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfCodigoBarras;
    @FXML
    private TextField tfPrecoCusto;
    @FXML
    private TextField tfEstoqueInicial;
    @FXML
    private TextField tfEstoqueAtual;
    @FXML
    private TextField tfEstoqueMinimo;
    @FXML
    private TextField tfCodigoNcm;
    @FXML
    private TextField tfCodigoCest;
    @FXML
    private TextField tfAliquotaICMS;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private TextField tfFatorConversaoEntrada;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    private void fechaForm() {
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }

    private void salva() {
        this.materiaPrima = this.getMateriaPrima();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.materiaPrima, new Class[0]);
        if (!this.validaForm()) {
            return;
        }
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        try {
            this.materiaPrimaService.salva(this.materiaPrima);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Materia Prima salvo com sucesso.");
            this.fechaForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(MateriaPrimaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private MateriaPrima getMateriaPrima() {
        if (this.materiaPrima == null) {
            this.materiaPrima = new MateriaPrima();
        }
        this.materiaPrima.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.materiaPrima.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        this.materiaPrima.setUnidade((Unidade)this.cbbUnidade.getSelectionModel().getSelectedItem());
        this.materiaPrima.setUnidadeEntrada((Unidade)this.cbbUnidadeEntrada.getSelectionModel().getSelectedItem());
        this.materiaPrima.setFatorConversaoEntrada(MaximaNumber.quantidadeToBigDecimal((String)this.tfFatorConversaoEntrada.getText()));
        this.materiaPrima.setCodigo(MaximaUtils.getText((String)this.tfCodigoBarras.getText()));
        this.materiaPrima.setUltimoCusto(MaximaNumber.moneyToBigDecimal((String)this.tfPrecoCusto.getText()));
        this.materiaPrima.setEstoqueInicial(MaximaNumber.moneyToBigDecimal((String)this.tfEstoqueInicial.getText()));
        this.materiaPrima.setEstoqueAtual(MaximaNumber.moneyToBigDecimal((String)this.tfEstoqueAtual.getText()));
        this.materiaPrima.setEstoqueMinimo(MaximaNumber.moneyToBigDecimal((String)this.tfEstoqueMinimo.getText()));
        this.materiaPrima.setNcm(MaximaUtils.getText((String)this.tfCodigoNcm.getText()));
        this.materiaPrima.setCest(MaximaUtils.getText((String)this.tfCodigoCest.getText()));
        this.materiaPrima.setAliquotaIcms(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaICMS.getText()));
        return this.materiaPrima;
    }

    public void inicializa(MateriaPrima materiaPrima1) {
        this.materiaPrima = materiaPrima1;
        if (this.materiaPrima != null) {
            if (this.materiaPrima.getId() != null) {
                this.tfId.setText(this.materiaPrima.getId().toString());
                this.tfEstoqueInicial.setDisable(true);
            }
            this.cbAtivo.setSelected(this.materiaPrima.getAtivo().booleanValue());
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.materiaPrima.getUltimaAlteracao()));
            this.tfNome.setText(this.materiaPrima.getNome());
            this.cbbUnidade.getSelectionModel().select((Object)this.materiaPrima.getUnidade());
            this.cbbUnidadeEntrada.getSelectionModel().select((Object)this.materiaPrima.getUnidadeEntrada());
            this.tfFatorConversaoEntrada.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getFatorConversaoEntrada(), (int)3));
            this.tfCodigoBarras.setText(this.materiaPrima.getCodigo());
            this.tfPrecoCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getUltimoCusto(), (int)2));
            this.tfEstoqueInicial.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getEstoqueInicial(), (int)2));
            this.tfEstoqueAtual.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getEstoqueAtual(), (int)2));
            this.tfEstoqueMinimo.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getEstoqueMinimo(), (int)2));
            this.tfCodigoNcm.setText(this.materiaPrima.getNcm());
            this.tfCodigoCest.setText(this.materiaPrima.getCest());
            this.tfAliquotaICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getAliquotaIcms(), (int)2));
            this.tfNome.requestFocus();
        }
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoCusto);
        MaximaMask.monetaryField((TextField)this.tfEstoqueInicial);
        MaximaMask.monetaryField((TextField)this.tfEstoqueAtual);
        MaximaMask.monetaryField((TextField)this.tfEstoqueMinimo);
        MaximaMask.monetaryField((TextField)this.tfAliquotaICMS);
    }

    private void loadCombos() {
        this.cbbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
        this.cbbUnidadeEntrada.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.tfEstoqueInicial.setOnKeyReleased(event -> this.tfEstoqueAtual.setText(this.tfEstoqueInicial.getText()));
        this.btnSalva.setOnAction(t -> this.salva());
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.materiaPrima.getNome() == null || this.materiaPrima.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.materiaPrima.getUnidade() == null) {
            this.cbbUnidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbUnidade.getStyleClass().remove((Object)"error");
        }
        if (this.materiaPrima.getCodigo() == null || this.materiaPrima.getCodigo().isEmpty()) {
            this.tfCodigoBarras.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigoBarras.getStyleClass().remove((Object)"error");
        }
        return valido;
    }
}

