/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.OrcamentoPesquisaController;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.service.OrcamentoService;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class OrcamentoAbreFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfCodigoOrcamento;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnPesquisa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private OrcamentoService orcamentoService;
    private Orcamento orcamento;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.orcamento = null;
        this.tfCodigoOrcamento.setText("");
        this.tfCodigoOrcamento.requestFocus();
    }

    public Orcamento getOrcamento() {
        return this.orcamento;
    }

    private void confirma() {
        Long codigo;
        String codigoOrcamento = MaximaUtils.getText((String)this.tfCodigoOrcamento.getText());
        if (!this.validaForm(codigoOrcamento)) {
            return;
        }
        try {
            codigo = Long.parseLong(codigoOrcamento);
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo informado inv\u00e1ildo.");
            return;
        }
        this.orcamento = this.orcamentoService.getById(codigo.longValue());
        if (this.orcamento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Or\u00e7amento n\u00e3o encontrado.");
            this.tfCodigoOrcamento.requestFocus();
            this.tfCodigoOrcamento.selectAll();
            return;
        }
        if (this.orcamento.isExcluida().booleanValue() || !this.orcamento.isAtivo().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Or\u00e7amento exclu\u00eddo. N\u00e3o pode ser alterado.");
            this.tfCodigoOrcamento.requestFocus();
            this.tfCodigoOrcamento.selectAll();
            this.orcamento = null;
            return;
        }
        this.fechaForm();
    }

    private void fechaForm() {
        Stage form = (Stage)this.btnPesquisa.getScene().getWindow();
        form.close();
    }

    private void pesquisa() {
        try {
            Stage formPesquisa = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/OrcamentoPesquisa.fxml", "Pesquisar or\u00e7amento");
            OrcamentoPesquisaController controller = (OrcamentoPesquisaController)formPesquisa.getUserData();
            controller.inicializa(Boolean.valueOf(false));
            formPesquisa.showAndWait();
            Orcamento selecionada = controller.getOrcamento();
            if (selecionada == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum pedido foi selecionado.");
                return;
            }
            this.orcamento = this.orcamentoService.getById(selecionada.getId().longValue());
            if (this.orcamento == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Or\u00e7amento n\u00e3o encontrado.");
                this.tfCodigoOrcamento.requestFocus();
                this.tfCodigoOrcamento.selectAll();
                return;
            }
            if (this.orcamento.isExcluida().booleanValue() || !this.orcamento.isAtivo().booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Or\u00e7amento exclu\u00eddo. N\u00e3o pode ser alterado.");
                this.tfCodigoOrcamento.requestFocus();
                this.tfCodigoOrcamento.selectAll();
                this.orcamento = null;
                return;
            }
            this.fechaForm();
        }
        catch (IOException ex) {
            Logger.getLogger(OrcamentoAbreFormController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir a pesquisa de vendas.");
        }
    }

    private boolean validaForm(String codigoVenda) {
        boolean valido = true;
        if (codigoVenda == null || codigoVenda.isEmpty()) {
            this.tfCodigoOrcamento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigoOrcamento.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.confirma());
        this.btnPesquisa.setOnAction(event -> this.pesquisa());
        this.btnSalva.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
        this.tfCodigoOrcamento.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }
}

