/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.modelo.OrcamentoItem;
import br.com.maximasolutions.estoque.service.OrcamentoService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class OrcamentoViewController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private OrcamentoService orcamentoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Configuracao conf;
    private Orcamento orcamento;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfVendedor;
    @FXML
    private TextField tfClienteNome;
    @FXML
    private TextField tfDataEmissao;
    @FXML
    private TextField tfClienteCnpj;
    @FXML
    private TextField tfClienteInscricaoEstadual;
    @FXML
    private TextField tfClienteEndereco;
    @FXML
    private TextField tfClienteTelefone;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorServicos;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfValorBruto;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfValorCusto;
    @FXML
    private TextField tfValorMargem;
    @FXML
    private TextField tfValorLucro;
    @FXML
    private Button btnFechar;
    @FXML
    private TableView<OrcamentoItem> tabela;
    @FXML
    private TableColumn<OrcamentoItem, String> colProduto;
    @FXML
    private TableColumn<OrcamentoItem, String> colCodigo;
    @FXML
    private TableColumn<OrcamentoItem, String> colItem;
    @FXML
    private TableColumn<OrcamentoItem, String> colFuncionario;
    @FXML
    private TableColumn<OrcamentoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<OrcamentoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<OrcamentoItem, BigDecimal> colDesconto;
    @FXML
    private TableColumn<OrcamentoItem, BigDecimal> colTotalItem;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa(Orcamento orcamento) {
        this.orcamento = orcamento;
        this.carregaDadosOrcamento();
    }

    private void carregaDadosOrcamento() {
        if (this.orcamento == null) {
            return;
        }
        this.orcamento = this.orcamentoService.getById(this.orcamento.getId().longValue());
        List itens = this.orcamentoService.itens(this.orcamento);
        Collections.sort(itens, Comparator.comparing(OrcamentoItem::getServico));
        this.tfId.setText(this.orcamento.getId().toString());
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)this.orcamento.getDataEmissao()));
        this.tfVendedor.setText(this.orcamento.getVendedor().getNome().toUpperCase());
        this.tfClienteNome.setText(this.orcamento.getCliente().getNome().toUpperCase());
        this.tfClienteCnpj.setText(this.orcamento.getCliente().getCpf());
        this.tfClienteInscricaoEstadual.setText(this.orcamento.getCliente().getRg());
        this.tfClienteEndereco.setText(this.orcamento.getCliente().getEnderecoCompleto());
        this.tfClienteTelefone.setText(this.orcamento.getCliente().getTelefone());
        this.tfObservacao.setText(this.orcamento.getObservacao());
        this.loadTabela(itens);
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.orcamento.getValorPecas(), (int)2));
        this.tfValorServicos.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.orcamento.getValorServicos(), (int)2));
        this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.orcamento.getDesconto(), (int)2));
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.orcamento.getTotal(), (int)2));
        this.tfValorBruto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.orcamento.getValorProdutos(), (int)2));
        this.tfValorCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.orcamento.getCustoTotal(), (int)2));
        BigDecimal valorLucro = this.orcamento.getTotal().subtract(this.orcamento.getCustoTotal());
        this.tfValorLucro.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorLucro, (int)2));
        BigDecimal margemLucro = valorLucro.multiply(new BigDecimal(100)).divide(this.orcamento.getTotal(), 2, RoundingMode.HALF_EVEN);
        this.tfValorMargem.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemLucro, (int)2));
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigoProduto"));
        this.colFuncionario.setCellValueFactory((Callback)new PropertyValueFactory("funcionario"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colDesconto.setCellValueFactory((Callback)new PropertyValueFactory("desconto"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colDesconto.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setContextMenu(this.getTableMenu());
    }

    private void loadTabela(List<OrcamentoItem> itens) {
        ObservableList pedidoItemList = FXCollections.observableArrayList();
        pedidoItemList.clear();
        pedidoItemList.addAll(itens);
        this.tabela.setItems(FXCollections.observableArrayList((Collection)pedidoItemList));
    }

    private void carregaIcones() {
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void fechar() {
        Stage stage = (Stage)this.anchorPane.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.fechar());
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        return cm;
    }
}

