/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDescontoException;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.DescontoFormController;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVFechamentoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    private Configuracao conf;
    private Pedido pedido;
    private List<VendaProdutoFaturamento> recebimentos = new ArrayList();
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfValorRecebimento;
    @FXML
    private TextField tfValorTroco;
    @FXML
    private TextField tfCodigoRecebimento;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorReceber;
    @FXML
    private TextField tfCliente;
    @FXML
    private TextField tfValorRecebido;
    @FXML
    private ComboBox<CondicaoRecebimento> cbbCondicaoRecebimento;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFechar;
    @FXML
    private Button btnCliente;
    @FXML
    private Label label;
    @FXML
    private Label labelDesconto;
    private boolean sucesso;
    private boolean emitirCupom;
    private VendaProduto vendaProduto;
    private Cliente cliente;
    private Boolean atalho;

    public boolean isEmitirCupom() {
        return this.emitirCupom;
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void inicializa() {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.carregaMascaras();
        this.carregaAtalhos();
        this.tfValorRecebimento.focusedProperty().addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void carregaAtalhos() {
        Scene scene = this.btnSalva.getScene();
        KeyCodeCombination kcF4 = new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[0]);
        Runnable rnF4 = () -> this.desconto();
        scene.getAccelerators().put((Object)kcF4, (Object)rnF4);
    }

    private void valorTroca() {
        BigDecimal valorTroca = this.pedido.getValorTroca().multiply(new BigDecimal(-1));
        if (valorTroca.compareTo(BigDecimal.ZERO) > 0) {
            VendaProdutoFaturamento recebimentoTroca = new VendaProdutoFaturamento();
            recebimentoTroca.setCondicaoRecebimento(this.condicaoRecebimentoService.load(5L));
            recebimentoTroca.setDataEmissao(LocalDateTime.now());
            recebimentoTroca.setDataEntrada(LocalDate.now());
            recebimentoTroca.setHistorico("TROCA");
            recebimentoTroca.setNumItem(Integer.valueOf(1));
            recebimentoTroca.setValor(valorTroca);
            recebimentoTroca.setValorTroco(BigDecimal.ZERO);
            this.recebimentos.add(recebimentoTroca);
        }
        this.calculaTotal();
    }

    private void calculaTotal() {
        BigDecimal recebido = BigDecimal.ZERO;
        for (VendaProdutoFaturamento fat : this.recebimentos) {
            recebido = fat.getValorRecebimento();
        }
        this.tfValorRecebido.setText(MaximaNumber.formataNumero((BigDecimal)recebido));
    }

    public VendaProduto getVendaProduto() {
        return this.vendaProduto;
    }

    public boolean getSucesso() {
        return this.sucesso;
    }

    private void closeWindowEvent(WindowEvent event) {
        System.out.println("***** verificaro o que fazer quando fechar sem confirmar.");
    }

    public void inicializaFechamento(Pedido pedido) {
        this.atalho = false;
        this.vendaProduto = null;
        this.sucesso = false;
        this.emitirCupom = false;
        this.recebimentos = new ArrayList();
        this.cliente = pedido.getCliente();
        this.pedido = pedido;
        this.valorTroca();
        this.atualizaValores();
        if (MaximaConfig.getDino().booleanValue()) {
            this.tfValorRecebimento.setText(MaximaNumber.formataNumero((BigDecimal)BigDecimal.ZERO));
        } else {
            this.tfValorRecebimento.setText(MaximaNumber.formataNumero((BigDecimal)pedido.getValorReceber()));
        }
        this.tfCodigoRecebimento.requestFocus();
        this.loadCliente();
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
    }

    private void atualizaValores() {
        this.tfValorTotal.setText(MaximaNumber.formataNumero((BigDecimal)this.pedido.getValorProdutos()));
        this.tfValorDesconto.setText(MaximaNumber.formataNumero((BigDecimal)this.pedido.getDesconto()));
        this.tfValorReceber.setText(MaximaNumber.formataNumero((BigDecimal)this.pedido.getTotal()));
        this.calculaTroco();
    }

    private void loadCliente() {
        if (this.cliente == null) {
            this.tfCliente.setText("CONSUMIDOR");
        } else {
            String descricaoCliente = this.cliente.getNome().toUpperCase();
            if (this.cliente.getVale().compareTo(BigDecimal.ZERO) > 0) {
                descricaoCliente = "( VALE: " + MaximaNumber.formataNumero((BigDecimal)this.cliente.getVale()) + " ) " + descricaoCliente;
            }
            this.tfCliente.setText(descricaoCliente);
        }
        this.tfCodigoRecebimento.requestFocus();
        this.tfCodigoRecebimento.selectAll();
    }

    private void finalizaFaturamento() {
        BigDecimal valorRecebimento;
        CondicaoRecebimento condicaoRecebimento = (CondicaoRecebimento)this.cbbCondicaoRecebimento.getSelectionModel().getSelectedItem();
        if (condicaoRecebimento == null) {
            this.cbbCondicaoRecebimento.requestFocus();
            return;
        }
        if (condicaoRecebimento.getExigirCliente().booleanValue() && this.cliente == null) {
            this.selecionaCliente();
            if (this.cliente == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um cliente para essa condi\u00e7\u00e3o de recebimento.");
                return;
            }
            this.pedido.setCliente(this.cliente);
        }
        if ((valorRecebimento = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebimento.getText())) == null || valorRecebimento.compareTo(BigDecimal.ZERO) == 0) {
            this.tfValorRecebimento.requestFocus();
            this.tfValorRecebimento.selectAll();
            return;
        }
        BigDecimal valorTroco = this.getValorRecebido().add(valorRecebimento).subtract(this.pedido.getTotal());
        System.out.println("=== valor troco: " + valorTroco);
        if (valorTroco != null && valorTroco.compareTo(BigDecimal.ZERO) > 0 && !condicaoRecebimento.getPermiteTroco().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Condi\u00e7\u00e3o de recebimento n\u00e3o permite troco.");
            return;
        }
        if (valorTroco == null || valorTroco.compareTo(BigDecimal.ZERO) < 0) {
            valorTroco = BigDecimal.ZERO;
        }
        VendaProdutoFaturamento fat = new VendaProdutoFaturamento();
        fat.setCondicaoRecebimento(condicaoRecebimento);
        fat.setDataEmissao(LocalDateTime.now());
        fat.setDataEntrada(this.pedido.getDataEmissao());
        fat.setHistorico("");
        fat.setValorTroco(valorTroco);
        fat.setValor(valorRecebimento);
        if (this.recebimentos == null) {
            this.recebimentos = new ArrayList();
        }
        this.recebimentos.add(fat);
        BigDecimal valorRecebido = BigDecimal.ZERO;
        for (VendaProdutoFaturamento f : this.recebimentos) {
            valorRecebido = valorRecebido.add(f.getValor());
        }
        this.tfValorRecebido.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorRecebido, (int)2));
        if (valorRecebido.compareTo(this.pedido.getTotal()) < 0) {
            this.cbbCondicaoRecebimento.getSelectionModel().select(null);
            this.tfCodigoRecebimento.setText("");
            this.tfValorRecebimento.setText(null);
            this.tfCodigoRecebimento.requestFocus();
            return;
        }
        for (VendaProdutoFaturamento faturamento : this.recebimentos) {
            if (!faturamento.getCondicaoRecebimento().getEmitirCupomFiscal().booleanValue()) continue;
            this.emitirCupom = true;
            break;
        }
        try {
            this.vendaProduto = this.vendaProdutoService.fechamentoPDV(this.pedido, this.cliente, this.recebimentos, valorTroco);
            this.sucesso = true;
        }
        catch (MaximaException ex) {
            VendaProduto vendafaturada = this.vendaProdutoService.getByPedido(this.pedido.getId());
            if (vendafaturada != null && vendafaturada.isFaturado().booleanValue() && !vendafaturada.isExcluida().booleanValue()) {
                this.vendaProduto = vendafaturada;
            }
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Pedido n\u00e3 finalizado.\n" + ex.getMessage()));
            this.fecharForm();
            return;
        }
        this.fecharForm();
    }

    private void selecionaCliente() {
        Cliente clientePesquisa = new ClientePesquisaForm().getCliente(this.stageManager, this.btnCliente.getScene(), "");
        if (clientePesquisa != null) {
            this.cliente = clientePesquisa;
            this.loadCliente();
        }
    }

    private void fecharForm() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(evt -> this.finalizaFaturamento());
        this.btnCliente.setOnAction(evt -> this.selecionaCliente());
        this.btnFechar.setOnAction(evt -> {
            this.sucesso = false;
            this.fecharForm();
        });
        this.cbbCondicaoRecebimento.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfValorRecebimento.requestFocus();
                this.tfValorRecebimento.selectAll();
            }
        });
        this.tfCodigoRecebimento.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.selecionaCondicaoRecebimento();
            }
        });
        this.tfValorRecebimento.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.finalizaFaturamento();
            }
        });
        this.tfValorRecebimento.setOnKeyReleased(evt -> this.calculaTroco());
        this.labelDesconto.setOnMouseClicked(evt -> this.desconto());
    }

    private void selecionaCondicaoRecebimento() {
        Long codigoRecebimentoId;
        try {
            codigoRecebimentoId = Long.parseLong(this.tfCodigoRecebimento.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.tfCodigoRecebimento.setText("");
            this.tfCodigoRecebimento.requestFocus();
            return;
        }
        CondicaoRecebimento condicaoRecebimento = this.condicaoRecebimentoService.load(codigoRecebimentoId.longValue());
        if (condicaoRecebimento == null) {
            this.tfCodigoRecebimento.setText("");
            this.tfCodigoRecebimento.requestFocus();
            return;
        }
        this.cbbCondicaoRecebimento.getSelectionModel().select((Object)condicaoRecebimento);
        this.tfValorRecebimento.requestFocus();
    }

    private BigDecimal getValorRecebido() {
        BigDecimal valor = BigDecimal.ZERO;
        if (this.recebimentos == null || this.recebimentos.isEmpty()) {
            return valor;
        }
        for (VendaProdutoFaturamento fat : this.recebimentos) {
            valor = valor.add(fat.getValor());
        }
        return valor;
    }

    private void calculaTroco() {
        Platform.runLater(() -> {
            BigDecimal valorTroco;
            BigDecimal valorTotal = this.pedido.getTotal();
            BigDecimal valorRecebido = this.getValorRecebido();
            BigDecimal valorRecebimento = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebimento.getText());
            if (valorRecebimento != null) {
                valorRecebido = valorRecebido.add(valorRecebimento);
            }
            if (valorRecebido.compareTo(valorTotal) >= 0) {
                this.label.setText("Troco");
                valorTroco = valorRecebido.subtract(valorTotal);
            } else {
                this.label.setText("Restante");
                valorTroco = valorTotal.subtract(valorRecebido).multiply(new BigDecimal("-1"));
            }
            this.tfValorTroco.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorTroco, (int)2));
        });
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnSalva.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnFechar.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnCliente.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void carregaCombos() {
        List condicaoRecebimentos = this.condicaoRecebimentoService.list();
        this.cbbCondicaoRecebimento.setItems(FXCollections.observableArrayList((Collection)condicaoRecebimentos));
        this.cbbCondicaoRecebimento.setCellFactory((Callback)new /* Unavailable Anonymous Inner Class!! */);
        this.cbbCondicaoRecebimento.valueProperty().addListener((obs, oldItem, newItem) -> {
            if (newItem == null) {
                this.tfCodigoRecebimento.setText("");
            } else {
                this.tfCodigoRecebimento.setText(newItem.getId().toString());
                this.tfValorRecebimento.requestFocus();
                this.tfValorRecebimento.selectAll();
            }
        });
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValorRecebimento);
    }

    private void desconto() {
        try {
            Stage formDesconto = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.labelDesconto.getScene().getWindow(), "/fxml/estoque/vendaProduto/DescontoForm.fxml", "");
            DescontoFormController controller = (DescontoFormController)formDesconto.getUserData();
            BigDecimal percentual = this.pedido.getDesconto().multiply(new BigDecimal(100)).divide(this.pedido.getValorProdutos(), 2, RoundingMode.HALF_EVEN);
            controller.inicializa(this.pedido.getValorProdutos(), percentual, this.pedido.getDesconto());
            formDesconto.showAndWait();
            BigDecimal valorDesconto = controller.getDesconto();
            boolean permissao = false;
            this.pedido = this.pedidoService.atualizaDesconto(this.pedido, valorDesconto, Boolean.valueOf(permissao));
            this.atualizaValores();
            this.tfCodigoRecebimento.requestFocus();
            this.tfCodigoRecebimento.selectAll();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Erro ao abrir desconto.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
        catch (MaximaDescontoException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    static /* synthetic */ TextField access$000(PDVFechamentoFormController x0) {
        return x0.tfValorRecebimento;
    }
}

