/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.controller.AutorizacaoController;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.SincronizacaoErpService;
import br.com.maximasolutions.administrativo.service.SincronizacaoPdvService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.GetCodigoController;
import br.com.maximasolutions.controller.GetNumeroFormController;
import br.com.maximasolutions.controller.GetValorFormController;
import br.com.maximasolutions.controller.PrincipalController;
import br.com.maximasolutions.controller.ValidacaoController;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.ToledoDll;
import br.com.maximasolutions.core.print.ElginPrinter;
import br.com.maximasolutions.core.print.TancaPrinter;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.controller.PDVFormController;
import br.com.maximasolutions.estoque.controller.PDVVendedorFormController;
import br.com.maximasolutions.estoque.controller.PedidoItemEditaFormController;
import br.com.maximasolutions.estoque.controller.PedidoVendaConstrucaoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.controller.VendaProdutoController;
import br.com.maximasolutions.estoque.controller.VendaProdutoPDVController;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Promocao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.PromocaoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaFechaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaIniciaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSangriaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSuprimentoFormController;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.fiscal.controller.CPFFormController;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnQuantidadeFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnTextFormatter;
import br.com.maximasolutions.nfce.controller.NFCeController;
import br.com.maximasolutions.nfce.controller.NFCeImportaVenda;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.modelo.NFCeDestinatario;
import br.com.maximasolutions.nfce.modelo.NFCeEmitente;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.sat.controller.SATController;
import br.com.maximasolutions.sat.controller.SatEnviaController;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeXml;
import br.com.maximasolutions.sat.modelo.SatModelo;
import br.com.maximasolutions.sat.print.SatImpressaoController;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.sat.xml.modelo.CFe;
import br.com.maximasolutions.utils.MaximaNumber;
import com.sun.jna.Native;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.ServerSocket;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Controller
public class PDVFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ValidacaoService validacaoService;
    @Autowired
    private NcmService ncmService;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private PromocaoService promocaoService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private SincronizacaoPdvService sincronizacaoPdvService;
    @Autowired
    private SincronizacaoErpService sincronizacaoErpService;
    @Autowired
    private NFCeService nFCeService;
    private Configuracao conf;
    private Produto produto;
    private Promocao promocao;
    private ObservableList<PedidoItem> pedidoItemList;
    private Pedido pedido;
    @FXML
    private VBox vBox;
    @FXML
    private TextField tfInformacao;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoDescricao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfValorUnitario;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TableView<PedidoItem> tabela;
    @FXML
    private TableColumn<PedidoItem, String> colProduto;
    @FXML
    private TableColumn<PedidoItem, String> colItem;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colTotalItem;
    @FXML
    private MenuItem menuItemFecharCaixa;
    @FXML
    private MenuItem menuItemSincronizar;
    @FXML
    private MenuItem menuItemSangria;
    @FXML
    private MenuItem menuItemSuprimento;
    @FXML
    private MenuItem menuItemVendas;
    private Boolean atalho;
    private ControleSAT controleSAT;
    private ToledoDll balancaToledo;
    private Scene scene;

    public void initialize(URL location, ResourceBundle resources) {
        new ValidacaoController().validaAtivacao(this.stageManager, this.configuracaoService, this.validacaoService);
        this.stageManager.getStage().setUserData((Object)this);
    }

    public void inicializaPDV(Scene scene) {
        try {
            ServerSocket serverSocket = new ServerSocket(12357);
        }
        catch (IOException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Sistema j\u00e1 encontra-se aberto.");
            System.exit(0);
        }
        this.scene = scene;
        this.menuItemSincronizar.setDisable(true);
        if (MaximaConfig.getInstance().getProperty("caixa_local", "n").equals("s")) {
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Sincronizando PDV com SERVIDOR.......");
            progress.show();
            this.sincronizaPDV(progress);
        }
        this.inicializaForm(scene);
    }

    private void sincronizaPDV(Stage progress) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$sincronizaPDV$0(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Falha na sincroniza\u00e7\u00e3o com o servidor.\nO sistema ser\u00e1 encerrado.");
            System.exit(0);
        });
        service.start();
    }

    public void inicializaForm(Scene scene) {
        this.conf = this.configuracaoService.load();
        if (this.conf != null && this.conf.getBloqueaPrecoVenda().booleanValue()) {
            this.tfValorUnitario.setDisable(true);
        } else {
            this.tfValorUnitario.setDisable(false);
        }
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
        this.carregaAtalhos(scene);
        this.validaMovimentoCaixa();
        this.inicializaSAT();
        this.inicializaBalanca();
        this.inicializaPedido();
    }

    private void validaMovimentoCaixa() {
        String caixaIdTxt = MaximaConfig.getInstance().getProperty("caixa_id");
        if (caixaIdTxt == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Caixa n\u00e3o configurado no arquivo properties.");
            return;
        }
        Long caixaId = Long.parseLong(caixaIdTxt);
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
        if (movimentoCaixa == null) {
            try {
                Stage abreMovimentoCaixaForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/AbrirCaixaForm.fxml", "Abertura de Movimento de Caixa");
                MovimentoCaixaIniciaFormController controller = (MovimentoCaixaIniciaFormController)abreMovimentoCaixaForm.getUserData();
                controller.inicializa(null);
                abreMovimentoCaixaForm.showAndWait();
            }
            catch (IOException ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo: ABERTURA DE MOVIMENTO DE CAIXA.");
                System.exit(0);
            }
            movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
            if (movimentoCaixa == null) {
                this.vBox.setDisable(true);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum movimento de caixa aberto.");
            }
        } else if (movimentoCaixa.getDataAbertura().toLocalDate().isBefore(LocalDate.now())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Movimento de caixa n\u00e3o fechado do dia anterior.");
        }
    }

    private void inicializaBalanca() {
        String porta = MaximaConfig.getBalancaPorta();
        if (porta.isEmpty()) {
            return;
        }
        this.inicializaBalancaToledo();
    }

    private void inicializaSAT() {
        String sat = MaximaConfig.getInstance().getProperty("sat", "");
        if (sat == null || sat.isEmpty()) {
            return;
        }
        SatModelo satModelo = SatModelo.get((String)sat);
        if (satModelo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de SAT n\u00e3o configurado no sistema.");
            return;
        }
        System.out.println("== MODELO SAT: " + satModelo);
        try {
            this.loadSAT(satModelo);
        }
        catch (MaximaException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private void loadSAT(SatModelo satModelo) throws MaximaException {
        try {
            this.controleSAT = new ControleSAT(satModelo.getDll());
        }
        catch (UnsatisfiedLinkError e) {
            Logger.getLogger(PDVFormController.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaException("AVISO: Falha ao carregar DLL do equipamento SAT: " + satModelo.toString() + ".");
        }
    }

    public void inicializaPedido() {
        this.atalho = false;
        this.pedido = null;
        this.pedidoItemList = null;
        this.inicializaItem();
    }

    private void inicializaItem() {
        this.produto = null;
        this.promocao = null;
        this.loadDadosProduto();
        this.loadItens();
    }

    private void setColumnProperties() {
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidadeFormatada"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        ColumnTextFormatter textFormatter = new ColumnTextFormatter();
        ColumnNumberFormatter valorFormatter = new ColumnNumberFormatter();
        ColumnQuantidadeFormatter quantidadeFormatter = new ColumnQuantidadeFormatter();
        quantidadeFormatter.setFontSize(32);
        valorFormatter.setFonte(Boolean.valueOf(true));
        this.colProduto.setCellFactory((Callback)textFormatter);
        this.colQuantidade.setCellFactory((Callback)quantidadeFormatter);
        this.colUnitario.setCellFactory((Callback)valorFormatter);
        this.colTotalItem.setCellFactory((Callback)valorFormatter);
    }

    private void imprimeUltimaVenda() {
        try {
            this.vendaProdutoService.imprimeUltimaVenda();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem(null));
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
    }

    private void carregaCombos() {
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            this.produto = null;
            this.promocao = null;
            this.loadDadosProduto();
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto == null && produtoCodigo.length() == 13 && produtoCodigo.substring(0, 1).equals("2")) {
            String codigoProduto = produtoCodigo.substring(1, 5);
            System.out.println("=== Codigo produto balan\u00e7a: " + codigoProduto);
            String precoTotal1 = produtoCodigo.substring(5, 10);
            String precoTotal2 = produtoCodigo.substring(10, 12);
            BigDecimal precoTotal = new BigDecimal(precoTotal1 + "." + precoTotal2);
            System.out.println("== Preco Etqueta: " + precoTotal);
            this.produto = this.produtoService.getByCodigoBarras(codigoProduto);
            if (this.produto != null) {
                if (this.produto.getPrecoVenda().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                    this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                } else {
                    BigDecimal quantidade = BigDecimal.ONE.setScale(3, RoundingMode.HALF_UP);
                    this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                }
            } else {
                codigoProduto = produtoCodigo.substring(3, 7);
                precoTotal1 = produtoCodigo.substring(7, 10);
                precoTotal2 = produtoCodigo.substring(10, 12);
                precoTotal = new BigDecimal(precoTotal1 + "." + precoTotal2);
                List produtos2 = this.produtoService.getByCodigoInterno(codigoProduto);
                if (produtos2 != null && produtos2.size() == 1) {
                    this.produto = (Produto)produtos2.get(0);
                }
                if (this.produto != null) {
                    if (this.produto.getPrecoVenda().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                        this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                    } else {
                        BigDecimal quantidade = BigDecimal.ONE.setScale(3, RoundingMode.HALF_UP);
                        this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                    }
                } else {
                    codigoProduto = produtoCodigo.substring(4, 7);
                    produtos2 = this.produtoService.getByCodigoInterno(codigoProduto);
                    if (produtos2 != null && produtos2.size() == 1) {
                        this.produto = (Produto)produtos2.get(0);
                    }
                    if (this.produto != null) {
                        if (this.produto.getPrecoVenda().compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                            this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                        } else {
                            BigDecimal quantidade = BigDecimal.ONE.setScale(3, RoundingMode.HALF_UP);
                            this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                        }
                    }
                }
            }
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoDescricao.setText(MaximaNumber.quantidadeToString((BigDecimal)MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText())) + "  X  " + this.produto.getNome().toUpperCase());
            this.tfValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.calculaTotalItem();
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            if (this.pedido == null || this.pedido.getId() == null) {
                this.tfProdutoDescricao.setText("");
                this.tfValorUnitario.setText("");
            }
            this.calculaTotalItem();
            this.tfQuantidade.setText("1");
            this.tfProdutoPesquisa.setText("");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        }
    }

    private void loadItens() {
        this.pedidoItemList = FXCollections.observableArrayList();
        this.pedidoItemList.clear();
        if (this.pedido != null && this.pedido.getId() != null) {
            this.pedidoItemList.addAll((Collection)this.pedidoService.itens(this.pedido));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getTotal(), (int)2));
        } else {
            this.tfValorTotal.setText("0,00");
        }
        this.tabela.setItems(this.pedidoItemList);
        this.tabela.scrollTo(this.pedidoItemList.size() - 1);
    }

    private void calculaTotalItem() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfTotalItem.setText("");
            return;
        }
        BigDecimal valorUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText());
        if (valorUnitario == null) {
            this.tfTotalItem.setText("");
            return;
        }
        BigDecimal totalItem = valorUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private void carregaMascaras() {
    }

    private void closeWindowEvent(WindowEvent event) {
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja finalizar o sistema?")) {
                event.consume();
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Existe um pedido em andamento. Cancele o pedido para encerrar o sistema.");
            event.consume();
        }
    }

    private void selecionaProduto() {
        String codigoPesquisa = this.tfProdutoPesquisa.getText();
        if (codigoPesquisa == null || codigoPesquisa.isEmpty()) {
            this.produto = null;
        } else if (this.produto == null || !this.produto.getCodigo().equals(codigoPesquisa.trim())) {
            this.pesquisaProduto();
        }
        if (this.produto != null) {
            if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
                this.addItem();
            } else {
                this.tfQuantidade.selectAll();
                this.tfQuantidade.requestFocus();
            }
        }
    }

    private void registraAcoes() {
        this.tfProdutoPesquisa.focusedProperty().addListener((obs, oldVal, newVal) -> {
            if (oldVal.booleanValue()) {
                // empty if block
            }
        });
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.selecionaProduto();
            }
        });
        this.tfQuantidade.setOnKeyReleased(event -> {
            if (!this.conf.getBloqueaPrecoVenda().booleanValue()) {
                this.calculaTotalItem();
            }
        });
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
                    this.tfProdutoPesquisa.requestFocus();
                    this.tfProdutoPesquisa.selectAll();
                } else {
                    this.tfValorUnitario.requestFocus();
                    this.tfValorUnitario.selectAll();
                }
            }
        });
        this.tfValorUnitario.setOnKeyReleased(event -> this.calculaTotalItem());
        this.tfValorUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem(null);
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.menuItemFecharCaixa.setOnAction(evt -> this.fecharCaixa());
        this.menuItemSincronizar.setOnAction(evt -> {
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Sincronizando PDV com SERVIDOR.......");
            progress.show();
            this.sincronizaPDV(progress);
        });
        this.menuItemSangria.setOnAction(evt -> this.sangriaCaixa());
        this.menuItemSuprimento.setOnAction(evt -> this.suprimentoCaixa());
        this.menuItemVendas.setOnAction(evt -> this.loadVendas());
    }

    private void setQuantidade() {
        this.tfQuantidade.requestFocus();
        this.tfQuantidade.selectAll();
    }

    private void carregaAtalhos(Scene scene) {
        Stage stage = (Stage)scene.getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        KeyCodeCombination kcF1 = new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]);
        Runnable rnF1 = () -> {
            if (MaximaConfig.getF1().booleanValue()) {
                this.finalizaPedido();
            } else {
                this.capturarPesoBalanca();
            }
        };
        scene.getAccelerators().put((Object)kcF1, (Object)rnF1);
        KeyCodeCombination kcF2 = new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]);
        Runnable rnF2 = () -> {
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        };
        scene.getAccelerators().put((Object)kcF2, (Object)rnF2);
        KeyCodeCombination kcF3 = new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]);
        Runnable rnF3 = () -> this.setQuantidade();
        scene.getAccelerators().put((Object)kcF3, (Object)rnF3);
        KeyCodeCombination kcF4 = new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[0]);
        Runnable rnF4 = () -> this.editaItem();
        scene.getAccelerators().put((Object)kcF4, (Object)rnF4);
        KeyCodeCombination kcF5 = new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]);
        Runnable rnF5 = () -> this.finalizaPedido();
        scene.getAccelerators().put((Object)kcF5, (Object)rnF5);
        KeyCodeCombination kcF6 = new KeyCodeCombination(KeyCode.F6, new KeyCombination.Modifier[0]);
        Runnable rnF6 = () -> this.imprimeUltimaVenda();
        scene.getAccelerators().put((Object)kcF6, (Object)rnF6);
        KeyCodeCombination kcF7 = new KeyCodeCombination(KeyCode.F7, new KeyCombination.Modifier[0]);
        Runnable rnF7 = () -> this.consultaPreco();
        scene.getAccelerators().put((Object)kcF7, (Object)rnF7);
        KeyCodeCombination kcF8 = new KeyCodeCombination(KeyCode.F8, new KeyCombination.Modifier[0]);
        Runnable rnF8 = () -> this.abreGaveta();
        scene.getAccelerators().put((Object)kcF8, (Object)rnF8);
        KeyCodeCombination kcF9 = new KeyCodeCombination(KeyCode.F9, new KeyCombination.Modifier[0]);
        Runnable rnF9 = () -> this.cancelaItem();
        scene.getAccelerators().put((Object)kcF9, (Object)rnF9);
        KeyCodeCombination kcF10 = new KeyCodeCombination(KeyCode.F10, new KeyCombination.Modifier[0]);
        Runnable rnF10 = () -> this.cancelaPedido();
        scene.getAccelerators().put((Object)kcF10, (Object)rnF10);
        KeyCodeCombination kcF11 = new KeyCodeCombination(KeyCode.F11, new KeyCombination.Modifier[0]);
        Runnable rnF11 = () -> this.loadVendas();
        scene.getAccelerators().put((Object)kcF11, (Object)rnF11);
        KeyCodeCombination kcF12 = new KeyCodeCombination(KeyCode.F12, new KeyCombination.Modifier[0]);
        Runnable rnF12 = () -> this.emiteCupomUltimaVenda();
        scene.getAccelerators().put((Object)kcF12, (Object)rnF12);
    }

    private void inicializaBalancaToledo() {
        String portaBalanca = MaximaConfig.getBalancaPorta();
        if (portaBalanca == null || portaBalanca.isEmpty()) {
            return;
        }
        Integer portaCom = null;
        try {
            portaCom = Integer.parseInt(portaBalanca);
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A porta da balan\u00e7a deve ser um N\u00daMERO inteiro.");
            return;
        }
        try {
            this.balancaToledo = (ToledoDll)Native.loadLibrary((String)"P05", ToledoDll.class);
            System.out.println("=== balanca toledo: " + this.balancaToledo);
            this.balancaToledo.DeterminaUmStopBit();
            int retorno = this.balancaToledo.AbrePorta(portaCom.intValue(), 0, 1, 0);
            System.out.println("Retorno abre porta: " + retorno);
            if (retorno != 1) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir porta de comunica\u00e7\u00e3o com a balan\u00e7a.");
            }
        }
        catch (Exception e) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um ao carregar a dll para balan\u00e7a.");
        }
    }

    private void capturarPesoBalanca() {
        System.out.println("--- capturar peso balan\u00e7a ---");
        if (this.balancaToledo == null) {
            this.inicializaBalancaToledo();
        }
        if (this.balancaToledo == null) {
            return;
        }
        byte[] peso = new byte[6];
        String local = "C:\\Maxima\\";
        int ret = this.balancaToledo.PegaPeso(0, peso, local);
        System.out.println("Retorno Pega Peso: " + ret);
        if (ret != 1) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao capturar peso da balan\u00e7a.");
            return;
        }
        BigDecimal quantidade = MaximaNumber.convertStringToNumberToledo((String)new String(peso));
        this.tfQuantidade.setText(MaximaNumber.quantidadeToString((BigDecimal)quantidade));
        this.tfProdutoPesquisa.requestFocus();
    }

    private void iniciaPedido() throws MaximaException {
        if (this.pedido != null && this.pedido.getId() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Existe um pedido em andamento.\nN\u00e3o \u00e9 poss\u00edvel iniciar outro pedido.");
            return;
        }
        this.pedido = this.pedidoService.inicia(null, this.conf.getCliente(), LocalDate.now(), null, null);
    }

    private void addItem() {
        if (this.produto == null && this.promocao == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe um produto para adicionar o item.");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
            return;
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) == 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe uma quantidade v\u00e1lida (Deve ser um n\u00famero maior que zero).");
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
            return;
        }
        if (this.pedido == null || this.pedido.getId() == null) {
            try {
                this.iniciaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                return;
            }
        }
        BigDecimal valorUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText());
        if (this.conf.getBloqueaPrecoVenda().booleanValue() && (valorUnitario == null || valorUnitario.compareTo(BigDecimal.ZERO) <= 0)) {
            valorUnitario = this.getValorUnitario();
        }
        BigDecimal desconto = BigDecimal.ZERO;
        String observacao = "";
        try {
            boolean isTroca = quantidade.compareTo(BigDecimal.ZERO) < 0;
            this.pedido = this.pedidoService.addItem(this.pedido, null, this.produto, quantidade, valorUnitario, desconto, observacao, Boolean.valueOf(false), Boolean.valueOf(isTroca));
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private void editaItem() {
        if (this.pedido == null || this.pedido.getId() == null) {
            return;
        }
        PedidoItem item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            Long numeroItem;
            try {
                Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetNumeroForm.fxml", "Informe o n\u00famero do Item");
                GetNumeroFormController controller = (GetNumeroFormController)form.getUserData();
                form.showAndWait();
                numeroItem = controller.getNumero();
            }
            catch (IOException ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel excluir item.");
                return;
            }
            if (numeroItem == null) {
                return;
            }
            item = this.pedidoService.getPorNumeroItem(Integer.valueOf(numeroItem.intValue()), this.pedido);
            if (item == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Item n\u00e3o encontrado.");
                return;
            }
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PedidoItemEditaForm.fxml", "Edi\u00e7\u00e3o de produto");
            PedidoItemEditaFormController controller = (PedidoItemEditaFormController)form.getUserData();
            controller.inicializa(item);
            form.showAndWait();
            this.pedido = this.pedidoService.getById(this.pedido.getId());
            this.inicializaItem();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo: 'PedidoItemEditaForm.fxml'.");
        }
    }

    private void deleteItem(PedidoItem item) {
        boolean autorizado;
        if (item == null && (item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem()) == null) {
            return;
        }
        if (this.conf.getCancelamentoSenha() != null && !this.conf.getCancelamentoSenha().isEmpty() && !(autorizado = new AutorizacaoController().solicitarCancelamento(this.stageManager, (Stage)this.vBox.getScene().getWindow()).booleanValue())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Solicita\u00e7\u00e3o N\u00c3O AUTORIZADA.");
            return;
        }
        try {
            this.pedido = this.pedidoService.deleteItem(item);
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void finalizaPedido() {
        if (this.pedido == null || this.pedido.getId() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum pedido inicializado.");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
            return;
        }
        if (this.pedidoItemList == null || this.pedidoItemList.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto adicionado no pedido.");
            return;
        }
        if (this.pedido.getTotal().compareTo(BigDecimal.ZERO) < 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o \u00e9 permitido finalizar um pedido com valor negativo.");
            return;
        }
        try {
            Stage formFechamento = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVFechamentoForm.fxml", "FINALIZAR PEDIDO");
            PDVFechamentoFormController controller = (PDVFechamentoFormController)formFechamento.getUserData();
            controller.inicializa();
            controller.carregaAtalhos();
            controller.inicializaFechamento(this.pedido);
            formFechamento.showAndWait();
            if (controller.getSucesso()) {
                VendaProduto vendaProduto = controller.getVendaProduto();
                this.abreGaveta();
                Boolean emitirSat = MaximaConfig.getInstance().getProperty("sat_emitir", "n").equalsIgnoreCase("s");
                if (!emitirSat.booleanValue() && controller.isEmitirCupom()) {
                    emitirSat = true;
                }
                if (emitirSat.booleanValue()) {
                    this.emiteCupomUltimaVenda();
                } else if (!MaximaConfig.pdvImprimeDireto().booleanValue()) {
                    if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o comprovante de venda?")) {
                        this.imprimeVenda(vendaProduto);
                    }
                } else {
                    this.imprimeVenda(vendaProduto);
                }
                this.inicializaPedido();
            } else {
                this.pedido = this.pedidoService.getById(this.pedido.getId());
                this.inicializaItem();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o form de fechamento de pedido.\n" + ex.getMessage()));
        }
    }

    private void imprimeVenda(VendaProduto vendaProduto) {
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido n\u00e3o impressora. \nFalha na comunica\u00e7\u00e3o com a impress\u00e3o.");
        }
    }

    private void cancelaPedido() {
        if (this.pedido == null || this.pedido.getId() == null) {
            return;
        }
        if (this.conf.getCancelamentoSenha() != null && !this.conf.getCancelamentoSenha().isEmpty()) {
            boolean autorizado = new AutorizacaoController().solicitarCancelamento(this.stageManager, (Stage)this.vBox.getScene().getWindow());
            if (!autorizado) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Solicita\u00e7\u00e3o N\u00c3O AUTORIZADA.");
                return;
            }
        } else if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cancelar o pedido em andamento?")) {
            return;
        }
        try {
            this.pedidoService.cancela(this.pedido);
            this.inicializaPedido();
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido cancelado com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadVendas() {
        try {
            Stage stage = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/VendaProdutoPDV.fxml", "Pedidos Recentes");
            VendaProdutoPDVController controller = (VendaProdutoPDVController)stage.getUserData();
            controller.inicializa(this.controleSAT, this.conf);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
        }
    }

    private void emiteCupomUltimaVenda() {
        String cpf;
        String nome;
        System.out.println("************** 0" + LocalDateTime.now());
        Long caixaId = Long.valueOf(MaximaConfig.getInstance().getProperty("caixa_id", "1"));
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
        if (movimentoCaixa == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum movimento de caixa aberto.");
            return;
        }
        VendaProduto ultimaVenda = this.vendaProdutoService.getUltimaMovimentoCaixa(movimentoCaixa.getId());
        if (ultimaVenda == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda encontrada.");
            return;
        }
        System.out.println("************** 1" + LocalDateTime.now());
        if (!ultimaVenda.isFaturado().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido n\u00e3o faturado. N\u00e3o pode ser emitido cupom fiscal.");
            return;
        }
        if (ultimaVenda.isExcluida().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido exclu\u00eddo. N\u00e3o pode ser emitido cupom fiscal.");
            return;
        }
        if (ultimaVenda.getSatCFe() != null || ultimaVenda.getNfce() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal j\u00e1 emitido para a venda selecioanda. N\u00e3o \u00e9 permitido a opera\u00e7\u00e3o.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/CPFForm.fxml", "CPF ou CNPJ");
            CPFFormController controller = (CPFFormController)stage.getUserData();
            controller.inicializa();
            stage.showAndWait();
            nome = controller.getNome();
            cpf = controller.getCpf();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir janela de CPF ou CNPJ.");
            return;
        }
        if (MaximaConfig.getCupomTipo().equalsIgnoreCase("sat")) {
            this.emiteCupomSAT(ultimaVenda, cpf, nome);
        } else {
            this.emiteCupomNFCe(ultimaVenda, cpf, nome);
        }
    }

    private void emiteCupomNFCe(VendaProduto ultimaVenda, String cpf, String nome) {
        NFCeCabecalho nfce;
        block10: {
            nfce = null;
            try {
                System.out.println("************** 2" + LocalDateTime.now());
                List list = this.vendaProdutoService.listItens(ultimaVenda);
                List faturamentos = this.vendaProdutoService.listaFaturamentos(ultimaVenda);
                NFCeImportaVenda nFCeImportaVenda = new NFCeImportaVenda(this.conf, this.nFCeService);
                nfce = nFCeImportaVenda.getNFCe(ultimaVenda, list);
                NFCeEmitente emitente = nFCeImportaVenda.getEmitente();
                NFCeDestinatario destinatario = nFCeImportaVenda.getDestinatario(cpf, nome);
                List itens = nFCeImportaVenda.getItensNFe(ultimaVenda, list, this.ncmService);
                List pagamentos = nFCeImportaVenda.pagamentos(faturamentos);
                System.out.println("************** 3" + LocalDateTime.now());
                nfce = this.nFCeService.salva(nfce, emitente, destinatario, itens, pagamentos, ultimaVenda, this.conf);
                System.out.println("************** 4" + LocalDateTime.now());
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao gerar Cupom Fiscal Consumidor");
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
            catch (Exception ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao validar o xml do Cupom Fiscal Consumidor");
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
        }
        if (nfce != null && nfce.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
            try {
                System.out.println("************** imp 1" + LocalDateTime.now());
                this.nFCeService.imprime(nfce, this.conf);
                System.out.println("************** imp 2" + LocalDateTime.now());
            }
            catch (MaximaException ex) {
                Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Cupom Fiscal N\u00e3o Impresso.\n" + ex.getMessage()));
            }
        }
    }

    private void emiteCupomSAT(VendaProduto ultimaVenda, String cpf, String nome) {
        SatCFe satCFe;
        byte[] arquivoCupom = null;
        try {
            String xmlEnvio = SatEnviaController.convertVendaProdutoToXmlCupom((NcmService)this.ncmService, (VendaProduto)ultimaVenda, (List)this.vendaProdutoService.listItens(ultimaVenda), (List)this.vendaProdutoService.listaFaturamentos(ultimaVenda), (Configuracao)this.conf, (String)MaximaConfig.getInstance().getProperty("caixa_id", "1"), (String)cpf, (String)nome);
            String xmlCupomEmitido = new SATController(this.controleSAT, this.conf).emiteCupom(xmlEnvio);
            arquivoCupom = SatEnviaController.tratarResultadoVenda((String)xmlCupomEmitido, (Configuracao)this.conf);
            SatCFeXml satCFeXml = new SatCFeXml();
            if (arquivoCupom != null) {
                satCFeXml.setArquivo(arquivoCupom);
            }
            String xmlCupom = ControleArquivos.lerBytesArquivo((String)"C:/Maxima/ultimoCupom.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlCupom.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            Node raiz = raizes.item(0);
            CFe xmlCFe = new CFe(raiz);
            satCFe = this.satCFeService.getSatCfeXmlCupom(xmlCFe);
            List itens = this.satCFeService.getSatCfeItemXmlCupom(xmlCFe);
            List parcelas = this.satCFeService.getSatCfePagamento(xmlCFe);
            satCFe = this.satCFeService.salvaCupom(satCFe, itens, parcelas, satCFeXml, ultimaVenda);
        }
        catch (Exception ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao emitir cupom fiscal.\n" + ex.getMessage()));
            return;
        }
        try {
            SatImpressaoController.imprimeCupom((byte[])arquivoCupom, (Configuracao)this.conf, (SatCFe)satCFe);
        }
        catch (Exception ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal emitido com sucesso.\nAVISO:Falha ao imprimir cupom fiscal.");
        }
    }

    private void fecharCaixa() {
        boolean autorizado;
        if (!this.conf.getSenhaFechamentoCaixa().isEmpty() && !(autorizado = new AutorizacaoController().solicitarFechamentoCaixa(this.stageManager, (Stage)this.vBox.getScene().getWindow()).booleanValue())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Solicita\u00e7\u00e3o N\u00c3O AUTORIZADA.");
            return;
        }
        try {
            Long caixaId = Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1"));
            MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
            if (movimentoCaixa == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum movimento de caixa aberto.");
                return;
            }
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/FecharCaixaForm.fxml", "Fechamento de Caixa");
            MovimentoCaixaFechaFormController controller = (MovimentoCaixaFechaFormController)stage.getUserData();
            controller.inicializa(this.caixaService.find(Long.valueOf(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")))));
            stage.showAndWait();
            if (controller.isSucesso()) {
                System.exit(0);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir form de fechamento de caixa.");
        }
    }

    private void abreGaveta() {
        boolean acionarGaveta = MaximaConfig.getInstance().getProperty("pdv_gaveta", "n").equalsIgnoreCase("s");
        if (!acionarGaveta) {
            return;
        }
        if (this.conf.getImpressoraModelo().equals((Object)ImpressoraModelo.ELGIN)) {
            try {
                ElginPrinter printer = new ElginPrinter();
                printer.acionaGaveta();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Falha ao abrir gaveta com impressora elgin.");
            }
        }
        if (this.conf.getImpressoraModelo().equals((Object)ImpressoraModelo.TANCA)) {
            try {
                TancaPrinter tancaPrinter = new TancaPrinter(this.conf);
                tancaPrinter.adicionaGaveta();
                tancaPrinter.finaliza();
            }
            catch (MaximaValidacaoException ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Falha ao abrir gaveta com impressora tanca.");
            }
        }
    }

    private void cancelaItem() {
        Long numeroItem;
        if (this.pedido == null || this.pedido.getId() == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetNumeroForm.fxml", "Informe o n\u00famero do Item");
            GetNumeroFormController controller = (GetNumeroFormController)form.getUserData();
            form.showAndWait();
            numeroItem = controller.getNumero();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel excluir item.");
            return;
        }
        PedidoItem item = this.pedidoService.getPorNumeroItem(Integer.valueOf(numeroItem.intValue()), this.pedido);
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Item n\u00e3o encontrado.");
            return;
        }
        this.deleteItem(item);
    }

    private BigDecimal getValorUnitario() {
        BigDecimal valorUnitario = BigDecimal.ZERO;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetValorForm.fxml", "Informe o valor unit\u00e1rio");
            GetValorFormController controller = (GetValorFormController)form.getUserData();
            form.showAndWait();
            valorUnitario = controller.getValor();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return valorUnitario;
    }

    private void sangriaCaixa() {
        boolean autorizado;
        if (!this.conf.getSenhaFechamentoCaixa().isEmpty() && !(autorizado = new AutorizacaoController().solicitarFechamentoCaixa(this.stageManager, (Stage)this.vBox.getScene().getWindow()).booleanValue())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Solicita\u00e7\u00e3o N\u00c3O AUTORIZADA.");
            return;
        }
        try {
            Stage sangriaForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/financeiro/movimentoCaixa/SangriaForm.fxml", "SANGRIA");
            MovimentoCaixaSangriaFormController controller = (MovimentoCaixaSangriaFormController)sangriaForm.getUserData();
            controller.inicializa(null);
            sangriaForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel eftuar sangria.");
        }
    }

    private void suprimentoCaixa() {
        boolean autorizado;
        if (!this.conf.getSenhaFechamentoCaixa().isEmpty() && !(autorizado = new AutorizacaoController().solicitarFechamentoCaixa(this.stageManager, (Stage)this.vBox.getScene().getWindow()).booleanValue())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Solicita\u00e7\u00e3o N\u00c3O AUTORIZADA.");
            return;
        }
        try {
            Stage sangriaForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/financeiro/movimentoCaixa/SuprimentoForm.fxml", "SUPRIMENTO");
            MovimentoCaixaSuprimentoFormController controller = (MovimentoCaixaSuprimentoFormController)sangriaForm.getUserData();
            controller.inicializa(null);
            sangriaForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel eftuar suprimento.");
        }
    }

    private void consultaPreco() {
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetCodigo.fxml", "Consulta Produto");
            GetCodigoController controller = (GetCodigoController)form.getUserData();
            form.showAndWait();
            String codigo = controller.getCodigo();
            if (codigo == null || codigo.isEmpty()) {
                return;
            }
            Produto produto = this.produtoService.getByCodigoBarras(codigo);
            if (produto == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Produto n\u00e3o cadastrado!!!");
                return;
            }
            MaximaAlert.informePreco((StageManager)this.stageManager, (String)produto.getNome().toUpperCase(), (String)("R$ " + MaximaNumber.formataNumero((BigDecimal)produto.getPrecoVenda())));
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ops, falha ao consultar pre\u00e7o do produto.");
            return;
        }
    }

    private /* synthetic */ void lambda$sincronizaPDV$0(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Sincroniza\u00e7\u00e3o realizada com sucesso.");
            this.inicializaForm(this.scene);
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ SincronizacaoPdvService access$000(PDVFormController x0) {
        return x0.sincronizacaoPdvService;
    }
}

