/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVGetItemFormController
extends MaximaController
implements Initializable {
    @FXML
    private Label label;
    @FXML
    private TextField tfValor;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFechar;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private String retorno;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.retorno = null;
        this.tfValor.setText("");
        this.tfValor.requestFocus();
    }

    public void setLabel(String descricao) {
        this.label.setText(descricao);
    }

    public void setValor(String valor) {
        this.tfValor.setText(valor);
    }

    public String getRetorno() {
        return this.retorno;
    }

    private void confirma() {
        this.retorno = MaximaUtils.getText((String)this.tfValor.getText());
        if (!this.validaForm(this.retorno)) {
            return;
        }
        this.fecharForm();
    }

    private void fecharForm() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }

    private boolean validaForm(String valor) {
        boolean valido = true;
        if (valor == null || valor.isEmpty()) {
            this.tfValor.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValor.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> {
            this.retorno = null;
            this.fecharForm();
        });
        this.btnSalva.setOnAction(event -> this.confirma());
        this.btnSalva.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
        this.tfValor.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }
}

