/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVTouchFechamentoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    private Configuracao conf;
    private Pedido pedido;
    @FXML
    private Button btnFechar;
    @FXML
    private Button btn10;
    @FXML
    private Button btn20;
    @FXML
    private Button btn50;
    @FXML
    private Button btn100;
    @FXML
    private Button btnLimpa;
    @FXML
    private Button btnFinalizar;
    @FXML
    private Button btn1;
    @FXML
    private Button btn2;
    @FXML
    private Button btn3;
    @FXML
    private Button btn4;
    @FXML
    private Button btn5;
    @FXML
    private Button btn6;
    @FXML
    private Button btn7;
    @FXML
    private Button btn8;
    @FXML
    private Button btn9;
    @FXML
    private Button btn0;
    @FXML
    private Button btnPonto;
    @FXML
    private Button btnReceber;
    @FXML
    private Pane paneCondicaoRecebimento;
    @FXML
    private Pane paneOpcoes;
    @FXML
    private TextField tfValorRecebido;
    @FXML
    private TextField tfValorTroco;
    @FXML
    private TextField tfTotal;
    @FXML
    private TextField tfValorDigitado;
    private Boolean finalizado;
    private BigDecimal valorRecebido;
    private BigDecimal valorTroco;
    private CondicaoRecebimento condicaoRecebimentoDinheiro;
    private List<Button> botoesCondicaoRecebimento;
    private CondicaoRecebimento condicaoRecebimento;
    private List<VendaProdutoFaturamento> recebimentos;

    public void initialize(URL location, ResourceBundle resources) {
        this.btnFinalizar.getStyleClass().add((Object)"btn-green");
        this.registraAcoes();
        this.carregaIcones();
    }

    public Boolean isFinalizado() {
        if (this.finalizado == null) {
            this.finalizado = false;
        }
        return this.finalizado;
    }

    public void inicializa(Pedido pedido) {
        this.recebimentos = new ArrayList();
        this.condicaoRecebimento = null;
        this.botoesCondicaoRecebimento = new ArrayList();
        this.paneOpcoes.setDisable(true);
        this.condicaoRecebimentoDinheiro = null;
        this.finalizado = false;
        this.valorRecebido = BigDecimal.ZERO;
        this.valorTroco = BigDecimal.ZERO;
        this.pedido = pedido;
        this.tfTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)pedido.getTotal(), (int)2));
        this.tfValorRecebido.setText(MaximaNumber.formataNumero((BigDecimal)BigDecimal.ZERO));
        this.listaCondicaoRecebimento();
    }

    private void listaCondicaoRecebimento() {
        List condicaoRecebimentos = this.condicaoRecebimentoService.pesquisa("");
        int linha = 1;
        int coluna = 1;
        int largura = 220;
        int altura = 80;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        for (CondicaoRecebimento cat : condicaoRecebimentos) {
            Button btn = new Button(cat.getNome().toUpperCase());
            btn.wrapTextProperty().setValue(Boolean.valueOf(true));
            btn.setPrefWidth((double)largura);
            btn.setPrefHeight((double)altura);
            btn.setFont(Font.font((double)18.0));
            btn.getStyleClass().add((Object)"btn-rich-blue-fechamento");
            btn.setOnAction(evt -> this.selecionaCondicaoRecebimento(cat, btn));
            gridPane.add((Node)btn, coluna, linha);
            ++linha;
            this.botoesCondicaoRecebimento.add(btn);
        }
        this.paneCondicaoRecebimento.getChildren().clear();
        this.paneCondicaoRecebimento.getChildren().add((Object)gridPane);
    }

    private void selecionaCondicaoRecebimento(CondicaoRecebimento condicaoRecebimento, Button btn) {
        this.paneOpcoes.setDisable(false);
        this.condicaoRecebimento = condicaoRecebimento;
        for (Button botao : this.botoesCondicaoRecebimento) {
            botao.getStyleClass().removeAll((Object[])new String[]{"btn-rich-blue-fechamento", "btn-green"});
            botao.getStyleClass().add((Object)"btn-rich-blue-fechamento");
        }
        btn.getStyleClass().removeAll((Object[])new String[]{"btn-rich-blue-fechamento"});
        btn.getStyleClass().add((Object)"btn-green");
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText());
        if (valorRecebido == null) {
            valorRecebido = BigDecimal.ZERO;
        }
        BigDecimal valorPendente = this.pedido.getTotal().subtract(valorRecebido);
        this.tfValorDigitado.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorPendente, (int)2));
    }

    private void finalizaPedido() {
        VendaProduto venda;
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText());
        BigDecimal valorDigitado = MaximaNumber.moneyToBigDecimal((String)this.tfValorDigitado.getText());
        if (valorRecebido == null) {
            valorRecebido = BigDecimal.ZERO;
        }
        if (valorDigitado == null) {
            valorDigitado = BigDecimal.ZERO;
        }
        if ((valorRecebido = valorRecebido.add(valorDigitado)).compareTo(this.pedido.getTotal()) < 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"O valor recebido n\u00e3o \u00e9 suficiente para finalizar o pedido");
            return;
        }
        if (valorDigitado.compareTo(BigDecimal.ZERO) > 0) {
            VendaProdutoFaturamento fat = new VendaProdutoFaturamento();
            fat.setCondicaoRecebimento(this.condicaoRecebimento);
            fat.setDataEmissao(LocalDateTime.now());
            LocalDate hoje = LocalDate.now();
            LocalDate dataEntrada = hoje.plusDays(this.condicaoRecebimento.getDiasParaEntrada().intValue());
            fat.setDataEntrada(dataEntrada);
            fat.setHistorico("");
            fat.setNumItem(Integer.valueOf(this.recebimentos.size() + 1));
            System.out.println("== Valor Digitado: " + valorDigitado);
            System.out.println("== Valor Troco: " + this.valorTroco);
            if (this.valorTroco.compareTo(BigDecimal.ZERO) >= 0) {
                fat.setValor(valorDigitado);
            } else {
                fat.setValor(valorDigitado);
            }
            fat.setValorTroco(this.valorTroco);
            this.recebimentos.add(fat);
        }
        try {
            venda = this.vendaProdutoService.fechamentoPDV(this.pedido, null, this.recebimentos, this.valorTroco);
            this.finalizado = true;
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Falha ao finalizar pedido.\n" + ex.getMessage()));
            return;
        }
        if (MaximaConfig.getInstance().getProperty("touch_imprime_venda", "s").equalsIgnoreCase("s")) {
            this.imprimeVenda(venda);
        } else if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Pedido emitido com sucesso. Deseja imprimir o comprovante?")) {
            this.imprimeVenda(venda);
        }
        this.fechaForm();
    }

    private void imprimeVenda(VendaProduto venda) {
        try {
            this.vendaProdutoService.imprimeVenda(venda);
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVTouchFechamentoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Falha ao imprimir o pedido.\n" + ex.getMessage()));
        }
    }

    private void cancela() {
        this.finalizado = false;
        this.fechaForm();
    }

    private void addNumero(String valor) {
        String texto = this.tfValorDigitado.getText();
        if (texto == null) {
            texto = "";
        }
        if (valor.equals(",") && texto.contains(",")) {
            return;
        }
        this.tfValorDigitado.setText(texto + valor);
        this.calculaTroco();
    }

    private void recebimento() {
        BigDecimal valorPendente;
        BigDecimal valorDigitado = MaximaNumber.moneyToBigDecimal((String)this.tfValorDigitado.getText());
        if (valorDigitado == null || valorDigitado.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText());
        if (valorRecebido == null) {
            valorRecebido = BigDecimal.ZERO;
        }
        if (valorDigitado.compareTo(valorPendente = this.pedido.getTotal().subtract(valorRecebido)) >= 0) {
            this.finalizaPedido();
            return;
        }
        VendaProdutoFaturamento fat = new VendaProdutoFaturamento();
        fat.setCondicaoRecebimento(this.condicaoRecebimento);
        fat.setDataEmissao(LocalDateTime.now());
        LocalDate hoje = LocalDate.now();
        LocalDate dataEntrada = hoje.plusDays(this.condicaoRecebimento.getDiasParaEntrada().intValue());
        fat.setDataEntrada(dataEntrada);
        fat.setHistorico("");
        fat.setNumItem(Integer.valueOf(this.recebimentos.size() + 1));
        if (this.valorTroco.compareTo(BigDecimal.ZERO) >= 0) {
            fat.setValor(valorDigitado.subtract(this.valorTroco));
        } else {
            fat.setValor(valorDigitado);
        }
        this.recebimentos.add(fat);
        valorRecebido = BigDecimal.ZERO;
        for (VendaProdutoFaturamento rec : this.recebimentos) {
            valorRecebido = valorRecebido.add(rec.getValor());
        }
        this.tfValorRecebido.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorRecebido, (int)2));
        for (Button botao : this.botoesCondicaoRecebimento) {
            botao.getStyleClass().removeAll((Object[])new String[]{"btn-rich-blue-fechamento", "btn-green"});
            botao.getStyleClass().add((Object)"btn-rich-blue-fechamento");
        }
        this.paneOpcoes.setDisable(true);
        this.zeraValorDigitado();
    }

    private void zeraValorDigitado() {
        this.tfValorDigitado.setText("");
        this.calculaTroco();
    }

    private void calculaTroco() {
        BigDecimal valorDigitado;
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText());
        if (valorRecebido == null) {
            valorRecebido = BigDecimal.ZERO;
        }
        if ((valorDigitado = MaximaNumber.moneyToBigDecimal((String)this.tfValorDigitado.getText())) == null) {
            valorDigitado = BigDecimal.ZERO;
        }
        valorRecebido = valorRecebido.add(valorDigitado);
        this.valorTroco = valorRecebido.subtract(this.pedido.getTotal());
        if (valorRecebido.compareTo(BigDecimal.ZERO) <= 0) {
            this.valorTroco = BigDecimal.ZERO;
        }
        this.tfValorTroco.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.valorTroco, (int)2));
    }

    private void registraAcoes() {
        this.btnFinalizar.setOnAction(evt -> this.finalizaPedido());
        this.btnReceber.setOnAction(evt -> this.recebimento());
        this.btnFechar.setOnAction(evt -> this.cancela());
        this.btnLimpa.setOnAction(evt -> this.zeraValorDigitado());
        this.btn1.setOnAction(evt -> this.addNumero("1"));
        this.btn2.setOnAction(evt -> this.addNumero("2"));
        this.btn3.setOnAction(evt -> this.addNumero("3"));
        this.btn4.setOnAction(evt -> this.addNumero("4"));
        this.btn5.setOnAction(evt -> this.addNumero("5"));
        this.btn6.setOnAction(evt -> this.addNumero("6"));
        this.btn7.setOnAction(evt -> this.addNumero("7"));
        this.btn8.setOnAction(evt -> this.addNumero("8"));
        this.btn9.setOnAction(evt -> this.addNumero("9"));
        this.btn0.setOnAction(evt -> this.addNumero("0"));
        this.btn10.setOnAction(evt -> {
            this.zeraValorDigitado();
            this.addNumero("10");
        });
        this.btn20.setOnAction(evt -> {
            this.zeraValorDigitado();
            this.addNumero("20");
        });
        this.btn50.setOnAction(evt -> {
            this.zeraValorDigitado();
            this.addNumero("50");
        });
        this.btn100.setOnAction(evt -> {
            this.zeraValorDigitado();
            this.addNumero("100");
        });
        this.btnPonto.setOnAction(evt -> this.addNumero(","));
        this.btnLimpa.setOnAction(evt -> this.zeraValorDigitado());
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFechar.setGraphic((Node)maximaIcone.getIconeDelete());
    }

    private void fechaForm() {
        Stage form = (Stage)this.btnFechar.getScene().getWindow();
        form.close();
    }
}

