/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaWebAPI;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.stage.Stage;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVTouchServidorApiController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnFechar;
    @FXML
    private Label labelStatus;
    @FXML
    private Label labelEnderecoIp;

    public void initialize(URL location, ResourceBundle resources) {
        this.registraAcoes();
    }

    public void inicializa() {
        this.atualizaDados();
    }

    private void atualizaDados() {
        InetAddress myIP = null;
        try {
            myIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(PDVTouchServidorApiController.class.getName()).log(Level.SEVERE, null, ex);
        }
        String enderecoIp = "Endere\u00e7o IP n\u00e3o encontrado.";
        if (myIP != null) {
            enderecoIp = myIP.getHostAddress();
        }
        this.labelEnderecoIp.setText(enderecoIp);
        String status = this.getStatus();
        this.labelStatus.setText(status);
    }

    private String getStatus() {
        Response response;
        try {
            response = new MaximaWebAPI("http://localhost:8087/").enviaSolicitacaoGet("api/comanda");
        }
        catch (IOException ex) {
            return "Indispon\u00edvel";
        }
        if (!response.isSuccessful()) {
            return "Indispon\u00edvel";
        }
        if (response.body() == null || response.code() != 200) {
            return "Indispon\u00edvel";
        }
        return "Dispon\u00edvel";
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.fechaForm());
    }

    private void fechaForm() {
        Stage form = (Stage)this.btnFechar.getScene().getWindow();
        form.close();
    }
}

