/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.PedidoFechamentoTipo;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PedidoFechamentoOpcoesFormController
extends MaximaController
implements Initializable {
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private Button btnFechar;
    @FXML
    private Button btnFinalizar;
    @FXML
    private Button btnFaturar;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private PedidoFechamentoTipo fechamentoTipo;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa() {
        this.fechamentoTipo = null;
        boolean faturar = MaximaConfig.getInstance().getProperty("pedido_venda_faturamento", "s").equalsIgnoreCase("s");
        if (!faturar) {
            this.btnFaturar.setDisable(true);
        }
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFechar.setGraphic((Node)maximaIcone.getIconeDelete());
    }

    public PedidoFechamentoTipo getPedidoFechamentoTipo() {
        return this.fechamentoTipo;
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> {
            this.fechamentoTipo = null;
            this.fechaForm();
        });
        this.btnFinalizar.setOnAction(evt -> {
            this.fechamentoTipo = PedidoFechamentoTipo.FINALIZAR;
            this.fechaForm();
        });
        this.btnFaturar.setOnAction(evt -> {
            this.fechamentoTipo = PedidoFechamentoTipo.FATURAR;
            this.fechaForm();
        });
    }

    private void fechaForm() {
        Stage form = (Stage)this.anchorPane.getScene().getWindow();
        form.close();
    }
}

