/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.PrincipalController;
import br.com.maximasolutions.controller.ValidacaoController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDescontoException;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.controller.DescontoFormController;
import br.com.maximasolutions.estoque.controller.DevolucaoFechamentoFormController;
import br.com.maximasolutions.estoque.controller.OrcamentoAbreFormController;
import br.com.maximasolutions.estoque.controller.OrcamentoFechamentoOpcoesFormController;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.controller.PDVFormController;
import br.com.maximasolutions.estoque.controller.PDVVendedorFormController;
import br.com.maximasolutions.estoque.controller.PedidoFaturamentoFormController;
import br.com.maximasolutions.estoque.controller.PedidoFechamentoOpcoesFormController;
import br.com.maximasolutions.estoque.controller.PedidoItemEditaFormController;
import br.com.maximasolutions.estoque.controller.PedidoVendaAbreFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.controller.VendaProdutoController;
import br.com.maximasolutions.estoque.controller.VendaProdutoOSController;
import br.com.maximasolutions.estoque.controller.VendaProdutoPDVController;
import br.com.maximasolutions.estoque.modelo.DevolucaoTipo;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoFechamentoTipo;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.DevolucaoService;
import br.com.maximasolutions.estoque.service.OrcamentoService;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.fiscal.controller.CPFFormController;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.geral.controller.VendedorPesquisaController;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.nfce.controller.NFCeController;
import br.com.maximasolutions.nfce.controller.NFCeImportaVenda;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.modelo.NFCeDestinatario;
import br.com.maximasolutions.nfce.modelo.NFCeEmitente;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.sat.controller.SATController;
import br.com.maximasolutions.sat.controller.SatEnviaController;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeXml;
import br.com.maximasolutions.sat.modelo.SatModelo;
import br.com.maximasolutions.sat.print.SatImpressaoController;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.sat.xml.modelo.CFe;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Controller
public class PedidoVendaConstrucaoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private ValidacaoService validacaoService;
    @Autowired
    private OrcamentoService orcamentoService;
    @Autowired
    private DevolucaoService devolucaoService;
    @Autowired
    private NFCeService nFCeService;
    @Autowired
    private NcmService ncmService;
    private Configuracao conf;
    private Cliente cliente;
    private Vendedor vendedor;
    private Produto produto;
    private ObservableList<PedidoItem> pedidoItemList;
    private Pedido pedido;
    private ControleSAT controleSAT;
    @FXML
    private VBox vBox;
    @FXML
    private MenuItem mnImprimeUltimaVenda;
    @FXML
    private MenuItem mnListaVendas;
    @FXML
    private MenuItem mnImprimeUltimoCupom;
    @FXML
    private ComboBox<TipoMovimentacao> cbbTipoMovimentacao;
    @FXML
    private TextField tfDataEmissao;
    @FXML
    private TextField tfNumeroPedido;
    @FXML
    private TextField tfOrdemCompra;
    @FXML
    private TextField tfVendedorPesquisa;
    @FXML
    private TextField tfVendedorNome;
    @FXML
    private TextField tfClientePesquisa;
    @FXML
    private TextField tfClienteNome;
    @FXML
    private TextField tfClienteTelefone;
    @FXML
    private TextField tfClienteEndereco;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoNome;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfPrecoUnitario;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfObservacaoPedido;
    @FXML
    private TableView<PedidoItem> tabela;
    @FXML
    private TableColumn<PedidoItem, String> colProduto;
    @FXML
    private TableColumn<PedidoItem, String> colCodigo;
    @FXML
    private TableColumn<PedidoItem, String> colItem;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colDesconto;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colTotalItem;
    @FXML
    private Button btnVendedorPesquisa;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnCancelaPedido;
    @FXML
    private Button btnFinalizaPedido;
    @FXML
    private Button btnAbrePedido;
    @FXML
    private Button btnAbreOrcamento;
    private Boolean atalho;

    public void initialize(URL location, ResourceBundle resources) {
        new ValidacaoController().validaAtivacao(this.stageManager, this.configuracaoService, this.validacaoService);
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializa() {
        this.conf = this.configuracaoService.load();
        if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
            this.tfPrecoUnitario.setDisable(true);
        }
        this.carregaCombos();
        this.inicializaSAT();
    }

    private void inicializaSAT() {
        String sat = MaximaConfig.getInstance().getProperty("sat", "");
        if (sat == null || sat.isEmpty()) {
            return;
        }
        SatModelo satModelo = SatModelo.get((String)sat);
        if (satModelo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de SAT n\u00e3o configurado no sistema.");
            return;
        }
        System.out.println("== MODELO SAT: " + satModelo);
        try {
            this.loadSAT(satModelo);
        }
        catch (MaximaException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadSAT(SatModelo satModelo) throws MaximaException {
        try {
            this.controleSAT = new ControleSAT(satModelo.getDll());
        }
        catch (UnsatisfiedLinkError e) {
            throw new MaximaException("AVISO: Falha ao carregar DLL do equipamento SAT: " + satModelo.toString() + ".");
        }
    }

    public void inicializaPedido() {
        this.atalho = false;
        this.cbbTipoMovimentacao.setDisable(false);
        this.btnCancelaPedido.setDisable(false);
        this.btnAbreOrcamento.setDisable(false);
        this.btnAbrePedido.setDisable(false);
        this.btnClientePesquisa.setDisable(false);
        this.btnVendedorPesquisa.setDisable(false);
        this.tfClientePesquisa.setDisable(false);
        this.tfObservacaoPedido.setText("");
        this.cliente = null;
        this.vendedor = null;
        this.pedido = null;
        this.inicializaItem();
        this.loadDadosCliente();
        this.loadDadosVendedor();
        if (MaximaConfig.getOrcamento().booleanValue()) {
            this.cbbTipoMovimentacao.getSelectionModel().select((Object)TipoMovimentacao.ORCAMENTO);
        } else {
            this.cbbTipoMovimentacao.getSelectionModel().select((Object)TipoMovimentacao.PEDIDO_VENDA);
        }
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)LocalDate.now()));
        this.tfNumeroPedido.setText("NOVO PEDIDO");
        this.tfOrdemCompra.setText("");
        Stage stage = (Stage)this.vBox.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        this.cbbTipoMovimentacao.requestFocus();
    }

    private void inicializaItem() {
        this.produto = null;
        this.loadValoresTotais();
        this.loadItens();
        this.loadDadosProduto();
    }

    private void loadItens() {
        this.pedidoItemList = FXCollections.observableArrayList();
        this.pedidoItemList.clear();
        if (this.pedido != null && this.pedido.getId() != null) {
            List list = this.pedidoService.itens(this.pedido);
            this.pedidoItemList.addAll((Collection)list);
        }
        this.tabela.setItems(this.pedidoItemList);
    }

    private void addItem() {
        if (!this.validaItemForm()) {
            return;
        }
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!this.validaPedidoNovo()) {
                return;
            }
            try {
                this.pedido = this.pedidoService.inicia(this.vendedor, this.cliente, MaximaDate.convertToLocalDate((String)this.tfDataEmissao.getText()), (TipoMovimentacao)this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem(), MaximaUtils.getText((String)this.tfOrdemCompra.getText()));
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
            this.btnAbreOrcamento.setDisable(true);
            this.btnAbrePedido.setDisable(true);
        }
        try {
            BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
            boolean isTroca = quantidade.compareTo(BigDecimal.ZERO) < 0;
            this.pedido = this.pedidoService.addItem(this.pedido, this.vendedor, this.produto, quantidade, MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText()), MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()), MaximaUtils.getText((String)this.tfObservacao.getText()), Boolean.valueOf(false), Boolean.valueOf(isTroca));
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        }
    }

    private void editaItem() {
        PedidoItem item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/PedidoItemEditaForm.fxml", "Edi\u00e7\u00e3o de produto");
            PedidoItemEditaFormController controller = (PedidoItemEditaFormController)form.getUserData();
            controller.inicializa(item);
            form.showAndWait();
            this.pedido = this.pedidoService.getById(this.pedido.getId());
            this.inicializaItem();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo: 'PedidoItemEditaForm.fxml'.");
        }
    }

    private void deleteItem() {
        PedidoItem item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o item: '" + item.getNumItem() + "' ?"))) {
            return;
        }
        try {
            this.pedido = this.pedidoService.deleteItem(item);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Item removido com sucesso.");
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void finalizaDevolucao() {
        DevolucaoTipo devolucaoTipo;
        boolean erro = false;
        String mensagemErro = "";
        for (PedidoItem item : this.pedidoItemList) {
            if (item.getQuantidade().compareTo(BigDecimal.ZERO) < 0) continue;
            erro = true;
            mensagemErro = mensagemErro + "Item " + item.getNumItem() + ": Quantidade deve ser um n\u00famero negativo.\n";
        }
        if (erro) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + mensagemErro));
            return;
        }
        try {
            Stage formDevolucao = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/DevolucaoFechamentoForm.fxml", "");
            DevolucaoFechamentoFormController controller = (DevolucaoFechamentoFormController)formDevolucao.getUserData();
            formDevolucao.showAndWait();
            devolucaoTipo = controller.getDevolucaoTipo();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir o fechamento de devolu\u00e7\u00e3o.");
            return;
        }
        if (devolucaoTipo == null) {
            return;
        }
        try {
            this.devolucaoService.salva(this.pedido, devolucaoTipo);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Devolu\u00e7\u00e3o efetuada com sucesso.");
            this.inicializaPedido();
        }
        catch (MaximaException | MaximaValidacaoException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void finalizaPedido() {
        if (!this.validaPedidoForm()) {
            return;
        }
        this.pedido.setTipoMovimentacao((TipoMovimentacao)this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem());
        if (this.pedido.getTotal().compareTo(BigDecimal.ZERO) < 0 && !this.pedido.getTipoMovimentacao().equals((Object)TipoMovimentacao.DEVOLUCAO)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido deve ser do tipo: DEVOLU\u00c7\u00c3O.");
            return;
        }
        if (this.pedido.getTipoMovimentacao().equals((Object)TipoMovimentacao.DEVOLUCAO)) {
            this.pedido.setDevolucao(Boolean.TRUE);
        }
        this.pedido.setCliente(this.cliente);
        this.pedido.setVendedor(this.vendedor);
        this.pedido.setObservacao(MaximaUtils.getText((String)this.tfObservacaoPedido.getText()));
        this.pedido = this.pedidoService.salva(this.pedido);
        TipoMovimentacao tipoMovimentacao = (TipoMovimentacao)this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem();
        if (tipoMovimentacao.equals((Object)TipoMovimentacao.PEDIDO_VENDA)) {
            this.finalizaVenda(tipoMovimentacao);
        }
        if (tipoMovimentacao.equals((Object)TipoMovimentacao.CONSIGNADO)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Aviso: Ocorreu um erro ao salvar consignado.\nQuery no banco de dados n\u00e3o pode ser executada.");
            return;
        }
        if (tipoMovimentacao.equals((Object)TipoMovimentacao.ORCAMENTO)) {
            this.finalizaOrcamento();
        }
        if (tipoMovimentacao.equals((Object)TipoMovimentacao.DEVOLUCAO)) {
            this.finalizaDevolucao();
        }
    }

    private void finalizaConsignado() {
        try {
            VendaProduto vendaProduto = this.vendaProdutoService.salva(this.pedido, this.cliente == null ? this.conf.getCliente() : this.cliente, TipoMovimentacao.CONSIGNADO);
            if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Consignado salvo com sucesso. Deseja imprimir?")) {
                this.vendaProdutoService.imprimeVenda(vendaProduto);
            }
            this.inicializaPedido();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Falha ao finalizar a condicional.\n" + ex.getMessage()));
        }
    }

    private void finalizaOrcamento() {
        if (this.pedido.getValorDevolucao().compareTo(BigDecimal.ZERO) != 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o \u00e9 permitido o lan\u00e7amento de devolu\u00e7\u00e3o para OR\u00c7AMENTO.");
            return;
        }
        PedidoFechamentoTipo fechamentoTipo = null;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/OrcamentoFechamentoOpcoesForm.fxml", "");
            OrcamentoFechamentoOpcoesFormController controller = (OrcamentoFechamentoOpcoesFormController)form.getUserData();
            form.showAndWait();
            fechamentoTipo = controller.getPedidoFechamentoTipo();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel finalizar o or\u00e7amento. (Falha no software)");
            return;
        }
        if (fechamentoTipo == null) {
            return;
        }
        if (fechamentoTipo.equals((Object)PedidoFechamentoTipo.FINALIZAR)) {
            try {
                Orcamento orcamento = this.orcamentoService.salva(this.pedido, this.cliente);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Or\u00e7amento realizado com sucesso.");
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o or\u00e7amento?")) {
                    this.orcamentoService.imprime(orcamento);
                }
                this.inicializaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Ocorreu um erro ao salvar or\u00e7amento.\n" + ex.getMessage()));
            }
        }
        if (fechamentoTipo.equals((Object)PedidoFechamentoTipo.ORCAMENTO_PARA_VENDA)) {
            this.finalizaVenda(TipoMovimentacao.PEDIDO_VENDA);
        }
    }

    private void finalizaVenda(TipoMovimentacao tipoMovimentacao) {
        try {
            PedidoFechamentoTipo pedidoFechamentoTipo;
            try {
                Stage formOpcoes = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PedidoFechamentoOpcoesForm.fxml", "");
                PedidoFechamentoOpcoesFormController controller = (PedidoFechamentoOpcoesFormController)formOpcoes.getUserData();
                formOpcoes.showAndWait();
                pedidoFechamentoTipo = controller.getPedidoFechamentoTipo();
            }
            catch (IOException ex) {
                Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo para fechamento de pedido.");
                return;
            }
            if (pedidoFechamentoTipo == null) {
                return;
            }
            VendaProduto vendaProduto = null;
            if (pedidoFechamentoTipo.equals((Object)PedidoFechamentoTipo.FINALIZAR)) {
                vendaProduto = this.vendaProdutoService.salva(this.pedido, this.cliente, tipoMovimentacao);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido finalizado com sucesso.");
            }
            if (pedidoFechamentoTipo.equals((Object)PedidoFechamentoTipo.FATURAR)) {
                try {
                    Stage faturamentoForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/PedidoFaturamentoForm.fxml", "Faturamento Pedido");
                    PedidoFaturamentoFormController controller = (PedidoFaturamentoFormController)faturamentoForm.getUserData();
                    controller.inicializaPedido(this.pedido);
                    faturamentoForm.showAndWait();
                    vendaProduto = controller.getVendaProduto();
                }
                catch (IOException ex) {
                    Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de faturamento do pedido [ PedidoFaturamentoForm.fxml ].\n" + ex.getMessage()));
                    return;
                }
            }
            if (vendaProduto == null) {
                this.pedido = this.pedidoService.getById(this.pedido.getId());
                this.inicializaItem();
                return;
            }
            if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o pedido?")) {
                this.vendaProdutoService.imprimeVenda(vendaProduto);
            }
            this.inicializaPedido();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void cancelaPedido() {
        if (this.pedido != null && this.pedido.getId() != null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cancelar o pedido em andamento?")) {
                return;
            }
            try {
                this.pedidoService.cancela(this.pedido);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido cancelado com sucesso.");
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                return;
            }
        }
        this.inicializaPedido();
    }

    private void abrePedidoVenda() {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/PedidoVendaAbreForm.fxml", "Abrir Pedido Venda");
            PedidoVendaAbreFormController controller = (PedidoVendaAbreFormController)form.getUserData();
            controller.inicializa();
            form.showAndWait();
            VendaProduto vendaProduto = controller.getVendaProduto();
            System.out.println("*** VENDA: " + vendaProduto);
            if (vendaProduto != null) {
                if (vendaProduto.getPedido() == null) {
                    this.pedidoService.create(vendaProduto);
                    vendaProduto = this.vendaProdutoService.getById(vendaProduto.getId());
                }
                if (vendaProduto.getPedido().getExcluido().booleanValue()) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido exclu\u00eddo ou desativado.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
                    return;
                }
                this.cbbTipoMovimentacao.setDisable(true);
                this.btnCancelaPedido.setDisable(true);
                this.btnAbreOrcamento.setDisable(true);
                this.btnAbrePedido.setDisable(true);
                this.btnClientePesquisa.setDisable(false);
                this.tfClientePesquisa.setDisable(false);
                this.carregaPedido(vendaProduto.getPedido(), vendaProduto.getId().toString());
                this.validaPedidoForm();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o form 'PedidoVendaAbreForm.fxml'");
        }
    }

    private void abreOrcamento() {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/OrcamentoAbreForm.fxml", "Abrir Or\u00e7amento");
            OrcamentoAbreFormController controller = (OrcamentoAbreFormController)form.getUserData();
            controller.inicializa();
            form.showAndWait();
            Orcamento orcamento = controller.getOrcamento();
            System.out.println("=== Or\u00e7amento: " + orcamento);
            if (orcamento != null) {
                if (orcamento.getPedido() == null) {
                    this.pedidoService.create(orcamento);
                    orcamento = this.orcamentoService.getById(orcamento.getId().longValue());
                }
                if (orcamento.getPedido().getExcluido().booleanValue()) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido exclu\u00eddo ou desativado.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
                    return;
                }
                this.cbbTipoMovimentacao.setDisable(true);
                this.btnCancelaPedido.setDisable(true);
                this.btnAbreOrcamento.setDisable(true);
                this.btnAbrePedido.setDisable(true);
                this.btnClientePesquisa.setDisable(false);
                this.tfClientePesquisa.setDisable(false);
                this.carregaPedido(orcamento.getPedido(), orcamento.getId().toString());
                this.validaPedidoForm();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o form 'PedidoVendaAbreForm.fxml'");
        }
    }

    private void loadValoresTotais() {
        if (this.pedido == null) {
            this.tfValorProdutos.setText("");
            this.tfValorFrete.setText("");
            this.tfValorDesconto.setText("");
            this.tfValorTotal.setText("");
        } else {
            this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getValorProdutos(), (int)2));
            this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getFrete(), (int)2));
            this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getDesconto(), (int)2));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getTotal(), (int)2));
        }
    }

    private boolean validaItemForm() {
        boolean valido = true;
        if (this.produto == null) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoNome.getStyleClass().remove((Object)"error");
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) == 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            TipoMovimentacao tipoMovimentacao = (TipoMovimentacao)this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem();
            if (tipoMovimentacao != null && tipoMovimentacao.equals((Object)TipoMovimentacao.DEVOLUCAO) && quantidade.compareTo(BigDecimal.ZERO) > 0) {
                this.tfQuantidade.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfQuantidade.getStyleClass().remove((Object)"error");
            }
        }
        BigDecimal precoUnitario = MaximaNumber.quantidadeToBigDecimal((String)this.tfPrecoUnitario.getText());
        if (precoUnitario == null || precoUnitario.compareTo(BigDecimal.ZERO) < 0) {
            this.tfPrecoUnitario.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfPrecoUnitario.getStyleClass().remove((Object)"error");
        }
        BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        if (desconto == null || desconto.compareTo(BigDecimal.ZERO) < 0) {
            this.tfDesconto.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDesconto.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoForm() {
        boolean valido = true;
        if (this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem() == null) {
            this.cbbTipoMovimentacao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbTipoMovimentacao.getStyleClass().remove((Object)"error");
        }
        if (this.vendedor == null) {
            this.tfVendedorPesquisa.getStyleClass().add((Object)"error");
            this.tfVendedorNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfVendedorPesquisa.getStyleClass().remove((Object)"error");
            this.tfVendedorNome.getStyleClass().remove((Object)"error");
        }
        if (this.cliente == null) {
            this.tfClientePesquisa.getStyleClass().add((Object)"error");
            this.tfClienteNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfClientePesquisa.getStyleClass().remove((Object)"error");
            this.tfClienteNome.getStyleClass().remove((Object)"error");
        }
        if (this.pedidoItemList == null || this.pedidoItemList.isEmpty()) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoNome.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoNovo() {
        boolean valido = true;
        if (this.vendedor == null) {
            this.tfVendedorPesquisa.getStyleClass().add((Object)"error");
            this.tfVendedorNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfVendedorPesquisa.getStyleClass().remove((Object)"error");
            this.tfVendedorNome.getStyleClass().remove((Object)"error");
        }
        if (this.cliente == null) {
            this.tfClientePesquisa.getStyleClass().add((Object)"error");
            this.tfClienteNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfClientePesquisa.getStyleClass().remove((Object)"error");
            this.tfClienteNome.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void calculaTotalItem() {
        BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (precoUnitario == null || quantidade == null) {
            this.tfTotalItem.setText(null);
            return;
        }
        BigDecimal totalItem = precoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private void carregaPedido(Pedido pedido, String numeroPedido) {
        System.out.println("Carregar Pedido: " + numeroPedido);
        this.pedido = this.pedidoService.getById(pedido.getId());
        this.vendedor = pedido.getVendedor();
        this.cliente = pedido.getCliente();
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)pedido.getDataEmissao()));
        this.cbbTipoMovimentacao.getSelectionModel().select((Object)pedido.getTipoMovimentacao());
        this.tfNumeroPedido.setText(numeroPedido);
        this.tfOrdemCompra.setText(pedido.getOrdemCompra());
        this.tfObservacaoPedido.setText(pedido.getObservacao());
        this.loadDadosVendedor();
        this.loadDadosCliente();
        this.inicializaItem();
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colDesconto.setCellValueFactory((Callback)new PropertyValueFactory("desconto"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colDesconto.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void imprimeUltimaVenda() {
        try {
            this.vendaProdutoService.imprimeUltimaVenda();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void imprimeUltimoCupom() {
        SatCFe cupom = this.satCFeService.getUltimo();
        if (cupom == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Cupom fiscal n\u00e3o encontrado.");
            return;
        }
        try {
            SatImpressaoController.imprimeCupom((byte[])cupom.getXml().getArquivo(), (Configuracao)this.conf, (SatCFe)cupom);
        }
        catch (Exception ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel imprimir cupom fiscal.\n" + ex.getMessage()));
        }
    }

    private void loadVendas() {
        Boolean os = MaximaConfig.getOS();
        if (os.booleanValue()) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/VendaProdutoOS.fxml", "Pedidos Recentes");
                VendaProdutoOSController controller = (VendaProdutoOSController)stage.getUserData();
                controller.inicializa(this.controleSAT, this.conf);
                stage.showAndWait();
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
            }
        } else {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/VendaProdutoPDV.fxml", "Pedidos Recentes");
                VendaProdutoPDVController controller = (VendaProdutoPDVController)stage.getUserData();
                controller.inicializa(this.controleSAT, this.conf);
                stage.showAndWait();
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
            }
        }
    }

    private void registraAcoes() {
        this.mnListaVendas.setOnAction(evt -> this.loadVendas());
        this.mnImprimeUltimoCupom.setOnAction(event -> this.imprimeUltimoCupom());
        this.mnImprimeUltimaVenda.setOnAction(event -> this.imprimeUltimaVenda());
        this.btnFinalizaPedido.setOnAction(event -> this.finalizaPedido());
        this.btnCancelaPedido.setOnAction(event -> this.cancelaPedido());
        this.btnAbrePedido.setOnAction(event -> this.abrePedidoVenda());
        this.btnAbreOrcamento.setOnAction(evt -> this.abreOrcamento());
        this.tfVendedorPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaVendedor();
            }
        });
        this.btnVendedorPesquisa.setOnAction(event -> this.pesquisaVendedorForm());
        this.tfClientePesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnClientePesquisa.setOnAction(event -> this.pesquisaClienteForm());
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(event -> this.addItem());
        this.vBox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F2) {
                this.pesquisaClienteForm();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.cbbTipoMovimentacao.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfOrdemCompra.requestFocus();
                this.tfOrdemCompra.selectAll();
            }
        });
        this.tfOrdemCompra.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfVendedorPesquisa.requestFocus();
                this.tfVendedorPesquisa.selectAll();
            }
        });
        this.tfObservacao.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfQuantidade.requestFocus();
                this.tfQuantidade.selectAll();
            }
        });
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.TAB) {
                if (!this.conf.getBloqueaPrecoVenda().booleanValue()) {
                    this.tfPrecoUnitario.requestFocus();
                    this.tfPrecoUnitario.selectAll();
                } else {
                    this.tfDesconto.requestFocus();
                    this.tfDesconto.selectAll();
                }
                this.calculaTotalItem();
            }
        });
        this.tfQuantidade.setOnKeyReleased(event -> this.calculaTotalItem());
        this.tfPrecoUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfDesconto.requestFocus();
                this.tfDesconto.selectAll();
                this.calculaTotalItem();
            }
        });
        this.tfPrecoUnitario.setOnKeyReleased(event -> this.calculaTotalItem());
        this.tfDesconto.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
    }

    private void desconto() {
        try {
            Stage formDesconto = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/DescontoForm.fxml", "");
            DescontoFormController controller = (DescontoFormController)formDesconto.getUserData();
            BigDecimal percentual = this.pedido.getDesconto().multiply(new BigDecimal(100)).divide(this.pedido.getValorProdutos(), 2, RoundingMode.HALF_EVEN);
            controller.inicializa(this.pedido.getValorProdutos(), percentual, this.pedido.getDesconto());
            formDesconto.showAndWait();
            BigDecimal valorDesconto = controller.getDesconto();
            this.pedido = this.pedidoService.atualizaDesconto(this.pedido, valorDesconto, Boolean.valueOf(false));
            this.inicializaItem();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Erro ao abrir desconto.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
        catch (MaximaDescontoException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    public void atalhos(Scene scene) {
        Stage stage = (Stage)scene.getWindow();
        stage.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            try {
                if (!this.atalho.booleanValue()) {
                    if (event.getCode() == KeyCode.F2) {
                        this.atalho = true;
                        this.tfProdutoPesquisa.requestFocus();
                        this.tfProdutoPesquisa.selectAll();
                        this.atalho = false;
                    }
                    if (event.getCode() == KeyCode.F5) {
                        this.atalho = true;
                        this.finalizaPedido();
                        this.atalho = false;
                    }
                    if (event.getCode() == KeyCode.F6) {
                        this.atalho = true;
                        this.imprimeUltimaVenda();
                        this.atalho = false;
                    }
                    if (event.getCode() == KeyCode.F7) {
                        this.atalho = true;
                        this.desconto();
                        this.atalho = false;
                    }
                    if (event.getCode() == KeyCode.F9) {
                        this.atalho = true;
                        this.atalho = false;
                    }
                    if (event.getCode() == KeyCode.F10) {
                        this.atalho = true;
                        this.cancelaPedido();
                        this.atalho = false;
                    }
                    if (event.getCode() == KeyCode.F11) {
                        this.atalho = true;
                        this.loadVendas();
                        this.atalho = false;
                    }
                    if (event.getCode() == KeyCode.F12) {
                        this.atalho = true;
                        this.emiteCupomUltimaVenda();
                        this.atalho = false;
                    }
                }
            }
            catch (Exception e) {
                this.atalho = false;
            }
        });
    }

    private void emiteCupomUltimaVenda() {
        String cpf;
        String nome;
        VendaProduto ultimaVenda = this.vendaProdutoService.getUltima(Long.valueOf(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id"))));
        if (!ultimaVenda.isFaturado().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido n\u00e3o faturado. N\u00e3o pode ser emitido cupom fiscal.");
            return;
        }
        if (ultimaVenda.isExcluida().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido exclu\u00eddo. N\u00e3o pode ser emitido cupom fiscal.");
            return;
        }
        if (ultimaVenda.getSatCFe() != null || ultimaVenda.getNfce() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal j\u00e1 emitido para a venda selecioanda. N\u00e3o \u00e9 permitido a opera\u00e7\u00e3o.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/CPFForm.fxml", "CPF ou CNPJ");
            CPFFormController controller = (CPFFormController)stage.getUserData();
            controller.inicializa();
            stage.showAndWait();
            if (!controller.isFinalizado()) {
                return;
            }
            nome = controller.getNome();
            cpf = controller.getCpf();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir janela de CPF ou CNPJ.");
            return;
        }
        if (MaximaConfig.getCupomTipo().equalsIgnoreCase("sat")) {
            this.emiteCupomSAT(ultimaVenda, cpf, nome);
        } else {
            this.emiteCupomNFCe(ultimaVenda, cpf, nome);
        }
    }

    private void emiteCupomNFCe(VendaProduto ultimaVenda, String cpf, String nome) {
        NFCeCabecalho nfce;
        block10: {
            nfce = null;
            try {
                List list = this.vendaProdutoService.listItens(ultimaVenda);
                List faturamentos = this.vendaProdutoService.listaFaturamentos(ultimaVenda);
                NFCeImportaVenda nFCeImportaVenda = new NFCeImportaVenda(this.conf, this.nFCeService);
                nfce = nFCeImportaVenda.getNFCe(ultimaVenda, list);
                NFCeEmitente emitente = nFCeImportaVenda.getEmitente();
                NFCeDestinatario destinatario = nFCeImportaVenda.getDestinatario(cpf, nome);
                List itens = nFCeImportaVenda.getItensNFe(ultimaVenda, list, this.ncmService);
                List pagamentos = nFCeImportaVenda.pagamentos(faturamentos);
                nfce = this.nFCeService.salva(nfce, emitente, destinatario, itens, pagamentos, ultimaVenda, this.conf);
                Thread.sleep(3000L);
                nfce = this.nFCeService.consultaStatus(nfce);
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao gerar Cupom Fiscal Consumidor");
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
            catch (Exception ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao validar o xml do Cupom Fiscal Consumidor");
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
        }
        if (nfce != null && nfce.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
            try {
                this.nFCeService.imprime(nfce, this.conf);
            }
            catch (MaximaException ex) {
                Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Cupom Fiscal N\u00e3o Impresso.\n" + ex.getMessage()));
            }
        }
    }

    private void emiteCupomSAT(VendaProduto ultimaVenda, String cpf, String nome) {
        SatCFe satCFe;
        byte[] arquivoCupom = null;
        try {
            String xmlEnvio = SatEnviaController.convertVendaProdutoToXmlCupom((NcmService)this.ncmService, (VendaProduto)ultimaVenda, (List)this.vendaProdutoService.listItens(ultimaVenda), (List)this.vendaProdutoService.listaFaturamentos(ultimaVenda), (Configuracao)this.conf, (String)MaximaConfig.getInstance().getProperty("caixa_id", "1"), (String)cpf, (String)nome);
            String xmlCupomEmitido = new SATController(this.controleSAT, this.conf).emiteCupom(xmlEnvio);
            arquivoCupom = SatEnviaController.tratarResultadoVenda((String)xmlCupomEmitido, (Configuracao)this.conf);
            SatCFeXml satCFeXml = new SatCFeXml();
            if (arquivoCupom != null) {
                satCFeXml.setArquivo(arquivoCupom);
            }
            String xmlCupom = ControleArquivos.lerBytesArquivo((String)"C:/Maxima/ultimoCupom.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlCupom.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            org.w3c.dom.Node raiz = raizes.item(0);
            CFe xmlCFe = new CFe(raiz);
            satCFe = this.satCFeService.getSatCfeXmlCupom(xmlCFe);
            List itens = this.satCFeService.getSatCfeItemXmlCupom(xmlCFe);
            List parcelas = this.satCFeService.getSatCfePagamento(xmlCFe);
            satCFe = this.satCFeService.salvaCupom(satCFe, itens, parcelas, satCFeXml, ultimaVenda);
        }
        catch (Exception ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao emitir cupom fiscal.\n" + ex.getMessage()));
            return;
        }
        try {
            SatImpressaoController.imprimeCupom((byte[])arquivoCupom, (Configuracao)this.conf, (SatCFe)satCFe);
        }
        catch (Exception ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal emitido com sucesso.\nAVISO:Falha ao imprimir cupom fiscal.");
        }
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnVendedorPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnClientePesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.getIconeNovo());
    }

    private void carregaCombos() {
        ArrayList tipoMovimentacaos = new ArrayList();
        tipoMovimentacaos.add(null);
        tipoMovimentacaos.addAll(TipoMovimentacao.comboPedido());
        this.cbbTipoMovimentacao.setItems(FXCollections.observableArrayList(tipoMovimentacaos));
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoNome.setText(this.produto.getNome().toUpperCase());
            this.tfPrecoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.tfObservacao.requestFocus();
            this.tfObservacao.selectAll();
        } else {
            this.tfProdutoNome.setText("");
            this.tfProdutoPesquisa.setText("");
            this.tfObservacao.setText("");
            this.tfQuantidade.setText("1");
            this.tfPrecoUnitario.setText("");
            this.tfDesconto.setText("0,00");
            this.tfTotalItem.setText("");
            this.tfProdutoPesquisa.requestFocus();
        }
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClientePesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        System.out.println("==== cliente size carateres: " + clienteCodigo.length());
        if (clienteCodigo.length() < 8) {
            try {
                Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
                Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
                if (clientePesquisa != null) {
                    if (clientePesquisa.getAtivo().booleanValue()) {
                        this.cliente = clientePesquisa;
                    } else {
                        MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Cliente desativado. N\u00e3o \u00e9 poss\u00edvel selecionar esse cliente.");
                        this.cliente = null;
                    }
                } else {
                    this.cliente = null;
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                    this.tfClientePesquisa.requestFocus();
                    this.tfClientePesquisa.selectAll();
                }
                this.loadDadosCliente();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.pesquisaClienteForm();
    }

    private void pesquisaClienteForm() {
        Cliente clientePesquisa = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), this.tfClientePesquisa.getText().trim());
        if (clientePesquisa != null) {
            this.cliente = clientePesquisa;
            this.loadDadosCliente();
        }
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClientePesquisa.setText(this.cliente.getId().toString());
            this.tfClienteNome.setText(this.cliente.getNome().toUpperCase());
            this.tfClienteTelefone.setText(this.cliente.getTelefone());
            this.tfClienteEndereco.setText(this.cliente.getEnderecoCompleto());
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        } else {
            this.tfClienteNome.setText("");
            this.tfClientePesquisa.setText("");
            this.tfClienteTelefone.setText("");
            this.tfClienteEndereco.setText("");
            this.tfClientePesquisa.requestFocus();
        }
    }

    private void pesquisaVendedor() {
        String vendedorCodigo = this.tfVendedorPesquisa.getText().trim();
        if (vendedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long vendedorCodigoNumero = Long.valueOf(vendedorCodigo);
            Vendedor vendedorPesquisa = this.vendedorService.load(vendedorCodigoNumero.longValue());
            if (vendedorPesquisa != null) {
                if (!vendedorPesquisa.getAtivo().booleanValue()) {
                    vendedorPesquisa = null;
                } else {
                    this.vendedor = vendedorPesquisa;
                }
            } else {
                this.vendedor = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de vendedor n\u00e3o encontrado.");
                this.tfVendedorPesquisa.requestFocus();
                this.tfVendedorPesquisa.selectAll();
            }
            this.loadDadosVendedor();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaVendedorForm();
            return;
        }
    }

    private void pesquisaVendedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/vendedor/VendedorPesquisa.fxml", "Pesquisa de vendedor");
            VendedorPesquisaController controller = (VendedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfVendedorPesquisa.getText().trim());
            stage.showAndWait();
            Vendedor vendedorPesquisa = controller.getVendedorSelecionado();
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'VendedorPesquisa'");
        }
    }

    private void loadDadosVendedor() {
        if (this.vendedor != null && this.vendedor.getAtivo().booleanValue()) {
            this.tfVendedorPesquisa.setText(this.vendedor.getId().toString());
            this.tfVendedorNome.setText(this.vendedor.getNome().toUpperCase());
            this.tfClientePesquisa.requestFocus();
            this.tfClientePesquisa.selectAll();
        } else {
            this.tfVendedorNome.setText("");
            this.tfVendedorPesquisa.setText("");
            this.tfVendedorPesquisa.requestFocus();
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoUnitario);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
    }

    private void closeWindowEvent(WindowEvent event) {
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja finalizar o sistema?")) {
                event.consume();
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Existe um pedido em andamento. Cancele o pedido para encerrar o sistema.");
            event.consume();
        }
    }
}

