/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.controller.AutorizacaoController;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.ValidacaoController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDescontoException;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.DescontoFormController;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.controller.PedidoFaturamentoFormController;
import br.com.maximasolutions.estoque.controller.PedidoItemEditaFormController;
import br.com.maximasolutions.estoque.controller.PedidoVendaAbreFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.report.VendaProdutoReport;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.geral.controller.VendedorPesquisaController;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PedidoVendaFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ValidacaoService validacaoService;
    private Configuracao conf;
    private Cliente cliente;
    private Vendedor vendedor;
    private Produto produto;
    private ObservableList<PedidoItem> pedidoItemList;
    private Pedido pedido;
    @FXML
    private VBox vBox;
    @FXML
    private ComboBox<TipoMovimentacao> cbbTipoMovimentacao;
    @FXML
    private TextField tfDataEmissao;
    @FXML
    private TextField tfNumeroPedido;
    @FXML
    private TextField tfOrdemCompra;
    @FXML
    private TextField tfVendedorPesquisa;
    @FXML
    private TextField tfVendedorNome;
    @FXML
    private TextField tfClientePesquisa;
    @FXML
    private TextField tfClienteNome;
    @FXML
    private TextField tfClienteTelefone;
    @FXML
    private TextField tfClienteEndereco;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoNome;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfPrecoUnitario;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfDescontoP;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorServicos;
    @FXML
    private TextField tfSubtotal;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfObservacaoPedido;
    @FXML
    private TableView<PedidoItem> tabela;
    @FXML
    private TableColumn<PedidoItem, String> colProduto;
    @FXML
    private TableColumn<PedidoItem, String> colCodigo;
    @FXML
    private TableColumn<PedidoItem, String> colItem;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colDesconto;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colTotalItem;
    @FXML
    private Button btnVendedorPesquisa;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnCancelaPedido;
    @FXML
    private Button btnFinalizaPedido;
    @FXML
    private Button btnAbrePedido;
    @FXML
    private Button btnAbreOrcamento;
    @FXML
    private Button btnDesconto;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        new ValidacaoController().validaAtivacao(this.stageManager, this.configuracaoService, this.validacaoService);
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
        if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
            this.tfPrecoUnitario.setDisable(true);
        }
    }

    public void inicializaPedido() {
        this.cbbTipoMovimentacao.setDisable(false);
        this.btnCancelaPedido.setDisable(false);
        this.btnAbreOrcamento.setDisable(false);
        this.btnAbrePedido.setDisable(false);
        this.btnClientePesquisa.setDisable(false);
        this.btnVendedorPesquisa.setDisable(false);
        this.tfClientePesquisa.setDisable(false);
        this.tfOrdemCompra.setText("");
        this.tfObservacaoPedido.setText("");
        this.cliente = null;
        this.pedido = null;
        this.inicializaItem();
        this.loadDadosCliente();
        this.cbbTipoMovimentacao.getSelectionModel().select((Object)TipoMovimentacao.PEDIDO_VENDA);
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)LocalDate.now()));
        this.tfNumeroPedido.setText("NOVO PEDIDO");
        Stage stage = (Stage)this.vBox.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        this.cbbTipoMovimentacao.requestFocus();
    }

    private void inicializaItem() {
        this.produto = null;
        this.vendedor = null;
        this.loadValoresTotais();
        this.loadItens();
        this.loadDadosVendedor();
        this.loadDadosProduto();
    }

    private void loadItens() {
        this.pedidoItemList = FXCollections.observableArrayList();
        this.pedidoItemList.clear();
        if (this.pedido != null && this.pedido.getId() != null) {
            List list = this.pedidoService.itens(this.pedido);
            this.pedidoItemList.addAll((Collection)list);
        }
        this.tabela.setItems(this.pedidoItemList);
    }

    private void addItem() {
        if (!this.validaItemForm()) {
            return;
        }
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!this.validaPedidoNovo()) {
                return;
            }
            try {
                this.pedido = this.pedidoService.inicia(null, this.cliente, MaximaDate.convertToLocalDate((String)this.tfDataEmissao.getText()), (TipoMovimentacao)this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem(), MaximaUtils.getText((String)this.tfOrdemCompra.getText()));
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
        try {
            BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
            boolean isTroca = quantidade.compareTo(BigDecimal.ZERO) < 0;
            this.pedido = this.pedidoService.addItem(this.pedido, this.vendedor, this.produto, quantidade, MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText()), MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()), MaximaUtils.getText((String)this.tfObservacao.getText()), Boolean.valueOf(false), Boolean.valueOf(isTroca));
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        }
    }

    private void editaItem() {
        PedidoItem item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/PedidoItemEditaForm.fxml", "Edi\u00e7\u00e3o de produto");
            PedidoItemEditaFormController controller = (PedidoItemEditaFormController)form.getUserData();
            controller.inicializa(item);
            form.showAndWait();
            this.pedido = this.pedidoService.getById(this.pedido.getId());
            this.inicializaItem();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo: 'PedidoItemEditaForm.fxml'.");
        }
    }

    private void deleteItem() {
        PedidoItem item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o item: '" + item.getNumItem() + "' ?"))) {
            return;
        }
        try {
            this.pedido = this.pedidoService.deleteItem(item);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Item removido com sucesso.");
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void finalizaPedido() {
        if (!this.validaPedidoForm()) {
            return;
        }
        this.pedido.setTipoMovimentacao((TipoMovimentacao)this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem());
        this.pedido.setCliente(this.cliente);
        this.pedido.setObservacao(MaximaUtils.getText((String)this.tfObservacaoPedido.getText()));
        this.pedido.setOrdemCompra(MaximaUtils.getText((String)this.tfOrdemCompra.getText()));
        this.pedido = this.pedidoService.salva(this.pedido);
        TipoMovimentacao tipoMovimentacao = (TipoMovimentacao)this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem();
        if (tipoMovimentacao.equals((Object)TipoMovimentacao.PEDIDO_VENDA)) {
            try {
                VendaProduto vendaProduto = this.vendaProdutoService.salva(this.pedido, this.cliente, tipoMovimentacao);
                boolean faturar = MaximaConfig.getInstance().getProperty("pedido_venda_faturamento", "s").equalsIgnoreCase("s");
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja faturar o pedido?")) {
                    try {
                        Stage faturamentoForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/PedidoFaturamentoForm.fxml", "Faturamento Pedido");
                        PedidoFaturamentoFormController controller = (PedidoFaturamentoFormController)faturamentoForm.getUserData();
                        controller.inicializaPedido(this.pedido);
                        faturamentoForm.showAndWait();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
                        MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de faturamento do pedido [ PedidoFaturamentoForm.fxml ].\n" + ex.getMessage()));
                        return;
                    }
                } else {
                    MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido finalizado com sucesso.");
                }
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o pedido?")) {
                    vendaProduto = this.vendaProdutoService.getById(vendaProduto.getId());
                    List itens = this.vendaProdutoService.listItens(vendaProduto);
                    List parcelas = this.vendaProdutoService.listParcelas(vendaProduto);
                    List faturamentos = this.vendaProdutoService.listaFaturamentos(vendaProduto);
                    new VendaProdutoReport(this.conf).visualiza(vendaProduto, itens, faturamentos, parcelas, this.conf);
                }
                this.inicializaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void cancelaPedido() {
        if (this.pedido != null && this.pedido.getId() != null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cancelar o pedido em andamento?")) {
                return;
            }
            try {
                this.pedidoService.cancela(this.pedido);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido cancelado com sucesso.");
            }
            catch (MaximaException ex) {
                Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                return;
            }
        }
        this.inicializaPedido();
    }

    private void abrePedidoVenda() {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/PedidoVendaAbreForm.fxml", "Abrir Pedido Venda");
            PedidoVendaAbreFormController controller = (PedidoVendaAbreFormController)form.getUserData();
            controller.inicializa();
            form.showAndWait();
            VendaProduto vendaProduto = controller.getVendaProduto();
            System.out.println("*** VENDA: " + vendaProduto);
            if (vendaProduto != null) {
                if (vendaProduto.getPedido() == null) {
                    this.pedidoService.create(vendaProduto);
                    vendaProduto = this.vendaProdutoService.getById(vendaProduto.getId());
                }
                if (vendaProduto.getPedido().getExcluido().booleanValue()) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido exclu\u00eddo ou desativado.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
                    return;
                }
                this.cbbTipoMovimentacao.setDisable(true);
                this.btnCancelaPedido.setDisable(true);
                this.btnAbreOrcamento.setDisable(true);
                this.btnAbrePedido.setDisable(true);
                this.btnClientePesquisa.setDisable(false);
                this.tfClientePesquisa.setDisable(false);
                this.carregaPedido(vendaProduto.getPedido(), vendaProduto.getId().toString());
                this.validaPedidoForm();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o form 'PedidoVendaAbreForm.fxml'");
        }
    }

    private void loadValoresTotais() {
        if (this.pedido == null) {
            this.tfSubtotal.setText("");
            this.tfValorProdutos.setText("");
            this.tfValorServicos.setText("");
            this.tfValorDesconto.setText("");
            this.tfValorTotal.setText("");
        } else {
            this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getValorPecas(), (int)2));
            this.tfValorServicos.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getValorServico(), (int)2));
            this.tfSubtotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getValorProdutos(), (int)2));
            this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getDesconto(), (int)2));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getTotal(), (int)2));
        }
    }

    private boolean validaItemForm() {
        boolean valido = true;
        if (this.vendedor == null) {
            this.tfVendedorPesquisa.getStyleClass().add((Object)"error");
            this.tfVendedorNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfVendedorPesquisa.getStyleClass().remove((Object)"error");
            this.tfVendedorNome.getStyleClass().remove((Object)"error");
        }
        if (this.produto == null) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoNome.getStyleClass().remove((Object)"error");
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        BigDecimal precoUnitario = MaximaNumber.quantidadeToBigDecimal((String)this.tfPrecoUnitario.getText());
        if (precoUnitario == null || precoUnitario.compareTo(BigDecimal.ZERO) < 0) {
            this.tfPrecoUnitario.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfPrecoUnitario.getStyleClass().remove((Object)"error");
        }
        BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        if (desconto == null || desconto.compareTo(BigDecimal.ZERO) < 0) {
            this.tfDesconto.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDesconto.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoForm() {
        boolean valido = true;
        if (this.cbbTipoMovimentacao.getSelectionModel().getSelectedItem() == null) {
            this.cbbTipoMovimentacao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbTipoMovimentacao.getStyleClass().remove((Object)"error");
        }
        if (this.cliente == null) {
            this.tfClientePesquisa.getStyleClass().add((Object)"error");
            this.tfClienteNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfClientePesquisa.getStyleClass().remove((Object)"error");
            this.tfClienteNome.getStyleClass().remove((Object)"error");
        }
        if (this.pedidoItemList == null || this.pedidoItemList.isEmpty()) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoNome.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoNovo() {
        boolean valido = true;
        if (this.cliente == null) {
            this.tfClientePesquisa.getStyleClass().add((Object)"error");
            this.tfClienteNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfClientePesquisa.getStyleClass().remove((Object)"error");
            this.tfClienteNome.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void calculaTotalItem() {
        BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (precoUnitario == null || quantidade == null) {
            this.tfTotalItem.setText(null);
            return;
        }
        BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        if (desconto == null) {
            desconto = BigDecimal.ZERO;
        }
        BigDecimal totalItem = precoUnitario.multiply(quantidade).subtract(desconto).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private void carregaPedido(Pedido pedido, String numeroPedido) {
        System.out.println("Carregar Pedido: " + numeroPedido);
        this.pedido = this.pedidoService.getById(pedido.getId());
        this.vendedor = pedido.getVendedor();
        this.cliente = pedido.getCliente();
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)pedido.getDataEmissao()));
        this.cbbTipoMovimentacao.getSelectionModel().select((Object)pedido.getTipoMovimentacao());
        this.tfNumeroPedido.setText(numeroPedido);
        this.tfOrdemCompra.setText(pedido.getOrdemCompra());
        this.tfObservacaoPedido.setText(pedido.getObservacao());
        this.loadDadosVendedor();
        this.loadDadosCliente();
        this.inicializaItem();
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colDesconto.setCellValueFactory((Callback)new PropertyValueFactory("desconto"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colDesconto.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnDesconto.setOnAction(event -> this.desconto());
        this.btnFinalizaPedido.setOnAction(event -> this.finalizaPedido());
        this.btnCancelaPedido.setOnAction(event -> this.cancelaPedido());
        this.btnAbrePedido.setOnAction(event -> this.abrePedidoVenda());
        this.tfVendedorPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaVendedor();
            }
        });
        this.btnVendedorPesquisa.setOnAction(event -> this.pesquisaVendedorForm());
        this.tfClientePesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnClientePesquisa.setOnAction(event -> this.pesquisaClienteForm());
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(event -> this.addItem());
        this.vBox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F2) {
                this.pesquisaClienteForm();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.cbbTipoMovimentacao.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfOrdemCompra.requestFocus();
                this.tfOrdemCompra.selectAll();
            }
        });
        this.tfOrdemCompra.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfClientePesquisa.requestFocus();
                this.tfClientePesquisa.selectAll();
            }
        });
        this.tfObservacao.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfQuantidade.requestFocus();
                this.tfQuantidade.selectAll();
            }
        });
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.TAB) {
                if (!this.conf.getBloqueaPrecoVenda().booleanValue()) {
                    this.tfPrecoUnitario.requestFocus();
                    this.tfPrecoUnitario.selectAll();
                } else {
                    this.tfDesconto.requestFocus();
                    this.tfDesconto.selectAll();
                }
                this.calculaTotalItem();
            }
        });
        this.tfQuantidade.setOnKeyReleased(event -> this.calculaTotalItem());
        this.tfPrecoUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfDescontoP.requestFocus();
                this.tfDescontoP.selectAll();
                this.calculaTotalItem();
            }
        });
        this.tfPrecoUnitario.setOnKeyReleased(event -> this.calculaTotalItem());
        this.tfDescontoP.setOnKeyReleased(event -> {
            BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
            BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
            if (precoUnitario == null || quantidade == null) {
                this.tfTotalItem.setText("0,00");
                this.tfDesconto.setText("0,00");
                return;
            }
            BigDecimal totalItem = precoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal percentual = MaximaNumber.moneyToBigDecimal((String)this.tfDescontoP.getText());
            BigDecimal desconto = percentual.multiply(totalItem).divide(new BigDecimal(100), 2, RoundingMode.HALF_EVEN);
            this.tfDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)desconto, (int)2));
            this.calculaTotalItem();
        });
        this.tfDescontoP.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfDesconto.requestFocus();
                this.tfDesconto.selectAll();
            }
        });
        this.tfDesconto.setOnKeyReleased(event -> {
            BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
            BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
            if (precoUnitario == null || quantidade == null) {
                this.tfTotalItem.setText("0,00");
                this.tfDescontoP.setText("0,00");
                return;
            }
            BigDecimal totalItem = precoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
            if (totalItem.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
            BigDecimal perc = desconto.multiply(new BigDecimal(100)).divide(totalItem, 2, RoundingMode.HALF_EVEN);
            this.tfDescontoP.setText(MaximaNumber.bigDecimalToString((BigDecimal)perc, (int)2));
        });
        this.tfDesconto.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnVendedorPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnClientePesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.getIconeNovo());
    }

    private void carregaCombos() {
        ArrayList<TipoMovimentacao> tipoMovimentacaos = new ArrayList<TipoMovimentacao>();
        tipoMovimentacaos.add(null);
        tipoMovimentacaos.addAll(Arrays.asList(TipoMovimentacao.values()));
        this.cbbTipoMovimentacao.setItems(FXCollections.observableArrayList(tipoMovimentacaos));
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoNome.setText(this.produto.getNome().toUpperCase());
            this.tfPrecoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.tfVendedorPesquisa.requestFocus();
            this.tfVendedorPesquisa.selectAll();
            if (!this.produto.getServico().booleanValue()) {
                this.tfVendedorPesquisa.setText("1");
            }
        } else {
            this.tfVendedorPesquisa.setText("");
            this.tfProdutoNome.setText("");
            this.tfProdutoPesquisa.setText("");
            this.tfObservacao.setText("");
            this.tfQuantidade.setText("1");
            this.tfPrecoUnitario.setText("");
            this.tfDesconto.setText("0,00");
            this.tfDescontoP.setText("0,00");
            this.tfTotalItem.setText("");
            this.tfProdutoPesquisa.requestFocus();
        }
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClientePesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        System.out.println("==== cliente size carateres: " + clienteCodigo.length());
        if (clienteCodigo.length() < 8) {
            try {
                Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
                Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
                if (clientePesquisa != null) {
                    this.cliente = clientePesquisa;
                } else {
                    this.cliente = null;
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                    this.tfClientePesquisa.requestFocus();
                    this.tfClientePesquisa.selectAll();
                }
                this.loadDadosCliente();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.pesquisaClienteForm();
    }

    private void pesquisaClienteForm() {
        Cliente clientePesquisa = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), this.tfClientePesquisa.getText().trim());
        if (clientePesquisa != null) {
            this.cliente = clientePesquisa;
            this.loadDadosCliente();
        }
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClientePesquisa.setText(this.cliente.getId().toString());
            this.tfClienteNome.setText(this.cliente.getNome().toUpperCase());
            this.tfClienteTelefone.setText(this.cliente.getTelefone());
            this.tfClienteEndereco.setText(this.cliente.getEnderecoCompleto());
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        } else {
            this.tfClienteNome.setText("");
            this.tfClientePesquisa.setText("");
            this.tfClienteTelefone.setText("");
            this.tfClienteEndereco.setText("");
            this.tfClientePesquisa.requestFocus();
        }
    }

    private void pesquisaVendedor() {
        String vendedorCodigo = this.tfVendedorPesquisa.getText().trim();
        if (vendedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long vendedorCodigoNumero = Long.valueOf(vendedorCodigo);
            Vendedor vendedorPesquisa = this.vendedorService.load(vendedorCodigoNumero.longValue());
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
            } else {
                this.vendedor = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de vendedor n\u00e3o encontrado.");
                this.tfVendedorPesquisa.requestFocus();
                this.tfVendedorPesquisa.selectAll();
            }
            this.loadDadosVendedor();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaVendedorForm();
            return;
        }
    }

    private void pesquisaVendedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/vendedor/VendedorPesquisa.fxml", "Pesquisa de vendedor");
            VendedorPesquisaController controller = (VendedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfVendedorPesquisa.getText().trim());
            stage.showAndWait();
            Vendedor vendedorPesquisa = controller.getVendedorSelecionado();
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'VendedorPesquisa'");
        }
    }

    private void loadDadosVendedor() {
        if (this.vendedor != null) {
            this.tfVendedorPesquisa.setText(this.vendedor.getId().toString());
            this.tfVendedorNome.setText(this.vendedor.getNome().toUpperCase());
            this.tfObservacao.requestFocus();
            this.tfObservacao.selectAll();
        } else {
            this.tfVendedorNome.setText("");
            this.tfVendedorPesquisa.setText("");
            this.tfVendedorPesquisa.requestFocus();
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoUnitario);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfDescontoP);
    }

    private void closeWindowEvent(WindowEvent event) {
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja finalizar o sistema?")) {
                event.consume();
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Existe um pedido em andamento. Cancele o pedido para encerrar o sistema.");
            event.consume();
        }
    }

    private void desconto() {
        if (this.pedido == null) {
            return;
        }
        try {
            Stage formDesconto = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnDesconto.getScene().getWindow(), "/fxml/estoque/vendaProduto/DescontoForm.fxml", "");
            DescontoFormController controller = (DescontoFormController)formDesconto.getUserData();
            BigDecimal percentual = this.pedido.getDesconto().multiply(new BigDecimal(100)).divide(this.pedido.getValorProdutos(), 2, RoundingMode.HALF_EVEN);
            controller.inicializa(this.pedido.getValorProdutos(), percentual, this.pedido.getDesconto());
            formDesconto.showAndWait();
            BigDecimal valorDesconto = controller.getDesconto();
            BigDecimal percentualDesconto = valorDesconto.multiply(new BigDecimal(100)).divide(this.pedido.getValorProdutos(), 2, RoundingMode.HALF_EVEN);
            BigDecimal descontoPermitido = this.configuracaoService.load().getDescontoAtualPermitido();
            boolean permissao = false;
            if (percentualDesconto.compareTo(descontoPermitido) > 0) {
                permissao = new AutorizacaoController().solicitarAutorizacao(this.stageManager, (Stage)this.btnDesconto.getScene().getWindow());
            }
            this.pedido = this.pedidoService.atualizaDesconto(this.pedido, valorDesconto, Boolean.valueOf(permissao));
            this.inicializaItem();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Erro ao abrir desconto.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
        catch (MaximaDescontoException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }
}

