/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoComboItemFormController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoComposicao;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoComboFormController
extends MaximaController
implements Initializable {
    private Produto produto;
    private List<ProdutoComposicao> subProdutos;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private UnidadeService unidadeService;
    @FXML
    private TableView<ProdutoComposicao> tabela;
    @FXML
    private TableColumn<ProdutoComposicao, String> colNome;
    @FXML
    private TableColumn<ProdutoComposicao, String> colUnidade;
    @FXML
    private TableColumn<ProdutoComposicao, BigDecimal> colValorUnitario;
    @FXML
    private TableColumn<ProdutoComposicao, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<ProdutoComposicao, BigDecimal> colValorTotal;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabFiscal;
    @FXML
    private TextField tfId;
    @FXML
    private CheckBox cbAtivo;
    @FXML
    private ComboBox<CategoriaProduto> cbCategoria;
    @FXML
    private Button btnCategoriaProdutoAdd;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnCodigo;
    @FXML
    private Button btnAddProduto;
    @FXML
    private Button btnDelProduto;
    @FXML
    private ComboBox<Unidade> cbUnidade;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfCodigoBarras;
    @FXML
    private TextField tfCodigoInterno;
    @FXML
    private TextField tfCusto;
    @FXML
    private TextField tfVenda;
    @FXML
    private TextField tfPrecoVenda;

    public void initialize(URL url, ResourceBundle rb) {
        this.setColumnProperties();
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    private void fechaForm() {
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }

    private void salva() {
        this.produto = this.getProduto();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.produto, new Class[0]);
        if (!this.validaForm()) {
            return;
        }
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        if (this.produto.getPrecoVenda().compareTo(BigDecimal.ZERO) == 0 && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cadastrar o produto com pre\u00e7o de venda zerado?")) {
            return;
        }
        try {
            this.produtoService.salva(this.produto, this.subProdutos, null, null, null);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Produto salvo com sucesso.");
            this.fechaForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ProdutoComboFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private Produto getProduto() {
        if (this.produto == null) {
            this.produto = new Produto();
        }
        this.produto.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.produto.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        this.produto.setEstoqueNegativo(Boolean.valueOf(true));
        this.produto.setCategoriaProduto((CategoriaProduto)this.cbCategoria.getSelectionModel().getSelectedItem());
        this.produto.setUnidade((Unidade)this.cbUnidade.getSelectionModel().getSelectedItem());
        this.produto.setCodigo(MaximaUtils.getText((String)this.tfCodigoBarras.getText()));
        this.produto.setReferencia(MaximaUtils.getText((String)this.tfCodigoInterno.getText()));
        this.produto.setUltimoCusto(MaximaNumber.moneyToBigDecimal((String)this.tfCusto.getText()));
        this.produto.setPrecoVenda(MaximaNumber.moneyToBigDecimal((String)this.tfVenda.getText()));
        this.produto.setEstoqueInicial(BigDecimal.ZERO);
        this.produto.setEstoqueAtual(BigDecimal.ZERO);
        this.produto.setEstoqueMinimo(BigDecimal.ZERO);
        this.produto.setComissao(BigDecimal.ZERO);
        this.produto.setDescontoPermitido(BigDecimal.ZERO);
        this.produto.setNcm("00000000");
        this.produto.setCfop("0000");
        this.produto.setCombo(Boolean.valueOf(true));
        return this.produto;
    }

    private void addProdutoCombo() {
        this.formComboItem(null);
        this.loadTabela();
    }

    private void formComboItem(ProdutoComposicao produtoComposicao) {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ComboItemForm.fxml", "Combo Item");
            ProdutoComboItemFormController comboItemFormController = (ProdutoComboItemFormController)form.getUserData();
            comboItemFormController.inicializa(produtoComposicao);
            form.showAndWait();
            ProdutoComposicao subProduto = comboItemFormController.getProdutoComposicao();
            if (subProduto != null) {
                if (this.subProdutos == null) {
                    this.subProdutos = new ArrayList();
                }
                this.subProdutos.add(subProduto);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoComboFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo para cadastro de item do combo de produto.");
        }
    }

    private void deleteProdutoCombo() {
        ProdutoComposicao subProduto = (ProdutoComposicao)this.tabela.getSelectionModel().getSelectedItem();
        if (subProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um subproduto para excluir.");
            return;
        }
        this.subProdutos.remove(subProduto);
        this.loadTabela();
    }

    public void inicializa(Produto produto1) {
        this.produto = produto1;
        if (this.produto != null) {
            if (this.produto.getId() != null) {
                this.tfId.setText(this.produto.getId().toString());
                this.subProdutos = this.produtoService.listaProdutosCombo(this.produto);
            }
            this.cbAtivo.setSelected(this.produto.isAtivo().booleanValue());
            this.tfNome.setText(this.produto.getNome());
            this.cbCategoria.getSelectionModel().select((Object)this.produto.getCategoriaProduto());
            this.cbUnidade.getSelectionModel().select((Object)this.produto.getUnidade());
            this.tfCodigoBarras.setText(this.produto.getCodigo());
            this.tfCodigoInterno.setText(this.produto.getReferencia());
            this.tfCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getUltimoCusto(), (int)2));
            this.tfVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.tfPrecoVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.tfNome.requestFocus();
        } else {
            this.subProdutos = null;
        }
        this.loadTabela();
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfVenda);
        MaximaMask.monetaryField((TextField)this.tfCusto);
        MaximaMask.monetaryField((TextField)this.tfPrecoVenda);
    }

    private void loadCombos() {
        this.cbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.list()));
        this.cbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCategoriaProdutoAdd.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnCodigo.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void registraAcoes() {
        this.btnAddProduto.setOnAction(evt -> this.addProdutoCombo());
        this.btnDelProduto.setOnAction(evt -> this.deleteProdutoCombo());
        this.btnSalva.setOnAction(t -> this.salva());
        this.btnCodigo.setOnAction(evt -> {
            String codigo = this.produtoService.geraCodigo();
            this.tfCodigoBarras.setText(codigo);
            this.tfCodigoInterno.setText(codigo);
        });
    }

    private void calculaPrecoVenda() {
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.produto.getNome() == null || this.produto.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getCategoriaProduto() == null) {
            this.cbCategoria.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbCategoria.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getUnidade() == null) {
            this.cbUnidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbUnidade.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getCodigo() == null || this.produto.getCodigo().isEmpty()) {
            this.tfCodigoBarras.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigoBarras.getStyleClass().remove((Object)"error");
        }
        if (this.subProdutos == null || this.subProdutos.isEmpty()) {
            this.tabela.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tabela.getStyleClass().remove((Object)"error");
        }
        BigDecimal precoVenda = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText());
        if (precoVenda != null) {
            if (this.produto.getPrecoVenda().compareTo(precoVenda) != 0) {
                this.tfPrecoVenda.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfPrecoVenda.getStyleClass().remove((Object)"error");
            }
        } else {
            this.tfPrecoVenda.getStyleClass().add((Object)"error");
            valido = false;
        }
        return valido;
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("subProduto"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidade"));
        this.colValorUnitario.setCellValueFactory((Callback)new PropertyValueFactory("valorUnitario"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colValorTotal.setCellValueFactory((Callback)new PropertyValueFactory("valorTotal"));
        this.colValorUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colValorTotal.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        if (this.subProdutos != null) {
            this.tabela.setItems(FXCollections.observableArrayList((Collection)this.subProdutos));
            BigDecimal precoCusto = BigDecimal.ZERO;
            BigDecimal precoVenda = BigDecimal.ZERO;
            for (ProdutoComposicao sub : this.subProdutos) {
                precoCusto = precoCusto.add(sub.getCusto());
                precoVenda = precoVenda.add(sub.getValorTotal());
            }
            this.tfVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)precoVenda, (int)2));
            this.tfCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)precoCusto, (int)2));
        }
    }
}

