/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoComplementoFormController;
import br.com.maximasolutions.estoque.modelo.ProdutoComplemento;
import br.com.maximasolutions.estoque.service.ProdutoComplementoService;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoComplementoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btNovo;
    @FXML
    private Button btEdita;
    @FXML
    private Button btDelete;
    @FXML
    private Button btAtualiza;
    @FXML
    private TableView<ProdutoComplemento> tabela;
    @FXML
    private TableColumn<ProdutoComplemento, String> colNome;
    @FXML
    private TableColumn<ProdutoComplemento, String> colCategoria;
    @FXML
    private TableColumn<ProdutoComplemento, String> colUnidade;
    @FXML
    private TableColumn<ProdutoComplemento, BigDecimal> colPrecoVenda;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoComplementoService produtoComplementoService;
    private ObservableList<ProdutoComplemento> produtoComplementoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.produtoComplementoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaProduto();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
    }

    @FXML
    private void edita(ActionEvent event) {
        this.editaProduto();
    }

    @FXML
    private void delete(ActionEvent event) {
        ProdutoComplemento produto = (ProdutoComplemento)this.tabela.getSelectionModel().getSelectedItem();
        if (produto != null && MaximaAlert.confirmacao((String)("Deseja remover o produto: '" + produto.getNome() + "'?"))) {
            this.produtoComplementoService.delete((Object)produto);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Produto removido com sucesso.");
        }
        this.loadTabela();
    }

    @FXML
    private void atualiza(ActionEvent event) {
        this.loadTabela();
    }

    @FXML
    private void novo(ActionEvent event) throws IOException {
        Stage stage = this.createWindowForm();
        ProdutoComplementoFormController controller = (ProdutoComplementoFormController)stage.getUserData();
        controller.setProdutoComplemento(null);
        stage.setTitle("Cadastro de Produto Complemento");
        stage.showAndWait();
        this.loadTabela();
    }

    private void editaProduto() {
        ProdutoComplemento complemento = (ProdutoComplemento)this.tabela.getSelectionModel().getSelectedItem();
        if (complemento != null) {
            try {
                Stage stage = this.createWindowForm();
                ProdutoComplementoFormController controller = (ProdutoComplementoFormController)stage.getUserData();
                controller.setProdutoComplemento(complemento);
                stage.setTitle("Edi\u00e7\u00e3o de Produto Complemento");
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ProdutoComplementoController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Stage createWindowForm() throws IOException {
        FXMLLoader loader = this.stageManager.loader("/fxml/estoque/produtoComplemento/ProdutoComplementoForm.fxml");
        AnchorPane content = (AnchorPane)loader.load();
        Scene scene = new Scene((Parent)content);
        ProdutoComplementoFormController controller = (ProdutoComplementoFormController)loader.getController();
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.DECORATED);
        stage.initOwner((Window)this.stageManager.getStage());
        stage.setScene(scene);
        return stage;
    }

    private void setColumnProperties() {
        this.colCategoria.setCellValueFactory((Callback)new PropertyValueFactory("categoriaProduto"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidade"));
        this.colPrecoVenda.setCellValueFactory((Callback)new PropertyValueFactory("precoVenda"));
    }

    private void loadTabela() {
        this.produtoComplementoList.clear();
        this.produtoComplementoList.addAll((Collection)this.produtoComplementoService.findAll());
        this.tabela.setItems(this.produtoComplementoList);
    }

    private void carregaIcones() {
        this.btNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }
}

