/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.ProdutoComplemento;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoComplementoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoComplementoFormController
extends MaximaController
implements Initializable {
    private ProdutoComplemento produtoComplemento;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoComplementoService produtoComplementoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private UnidadeService unidadeService;
    @FXML
    private TextField tfId;
    @FXML
    private CheckBox cbAtivo;
    @FXML
    private ComboBox<CategoriaProduto> cbCategoria;
    @FXML
    private Button btnCategoriaProdutoAdd;
    @FXML
    private Button btnSalva;
    @FXML
    private ComboBox<Unidade> cbUnidade;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfPrecoCusto;
    @FXML
    private TextField tfPrecoVenda;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    @FXML
    private void onSalva(ActionEvent event) {
        String mensagem;
        this.produtoComplemento = this.getProdutoComplemento();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.produtoComplemento, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        if (this.produtoComplemento.getId() == null) {
            this.produtoComplementoService.save((Object)this.produtoComplemento);
            mensagem = "Complemento adicionado com sucesso.";
        } else {
            this.produtoComplementoService.update((Object)this.produtoComplemento);
            mensagem = "Complemento alterado com sucesso.";
        }
        MaximaAlert.informe((StageManager)this.stageManager, (String)mensagem);
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }

    private ProdutoComplemento getProdutoComplemento() {
        if (this.produtoComplemento == null) {
            this.produtoComplemento = new ProdutoComplemento();
        }
        this.produtoComplemento.setNome(this.tfNome.getText().trim());
        this.produtoComplemento.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        this.produtoComplemento.setCategoriaProduto((CategoriaProduto)this.cbCategoria.getSelectionModel().getSelectedItem());
        this.produtoComplemento.setUnidade((Unidade)this.cbUnidade.getSelectionModel().getSelectedItem());
        this.produtoComplemento.setUltimoCusto(MaximaNumber.moneyToBigDecimal((String)this.tfPrecoCusto.getText()));
        this.produtoComplemento.setPrecoVenda(MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText()));
        return this.produtoComplemento;
    }

    public void setProdutoComplemento(ProdutoComplemento pc) {
        this.produtoComplemento = pc;
        if (this.produtoComplemento != null) {
            this.tfId.setText(this.produtoComplemento.getId().toString());
            this.cbAtivo.setSelected(this.produtoComplemento.getAtivo().booleanValue());
            this.tfNome.setText(this.produtoComplemento.getNome());
            this.cbCategoria.getSelectionModel().select((Object)this.produtoComplemento.getCategoriaProduto());
            this.cbUnidade.getSelectionModel().select((Object)this.produtoComplemento.getUnidade());
            this.tfPrecoCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produtoComplemento.getUltimoCusto(), (int)2));
            this.tfPrecoVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produtoComplemento.getPrecoVenda(), (int)2));
            this.tfNome.requestFocus();
        }
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoCusto);
        MaximaMask.monetaryField((TextField)this.tfPrecoVenda);
    }

    private void loadCombos() {
        this.cbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.list()));
        this.cbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCategoriaProdutoAdd.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void registraAcoes() {
    }
}

