/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoComprasController
extends MaximaController
implements Initializable {
    @FXML
    private TableView<EntradaProduto> tabela;
    @FXML
    private TableColumn<EntradaProduto, String> colFornecedor;
    @FXML
    private TableColumn<EntradaProduto, String> colCodigo;
    @FXML
    private TableColumn<EntradaProduto, String> colData;
    @FXML
    private TableColumn<EntradaProduto, String> colNota;
    @FXML
    private TableColumn<EntradaProduto, BigDecimal> colTotal;
    @FXML
    private Button btnFechar;
    @FXML
    private Label produtoLabel;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    private Produto produto;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa(Produto produto) {
        this.produto = produto;
        this.produtoLabel.setText(produto.getNome().toUpperCase());
        this.loadTabela();
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colNota.setCellValueFactory((Callback)new PropertyValueFactory("numeroNota"));
        this.colFornecedor.setCellValueFactory((Callback)new PropertyValueFactory("fornecedor"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        List list = this.entradaProdutoService.listaPorProduto(this.produto);
        this.tabela.setItems(FXCollections.observableArrayList((Collection)list));
    }

    private void carregaIcones() {
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void selecionaVenda() {
    }

    private void close() {
        Stage stage = (Stage)this.tabela.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.close());
    }
}

