/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.GetNumeroFormController;
import br.com.maximasolutions.controller.GetValorFormController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.EstoqueBalancoController;
import br.com.maximasolutions.estoque.controller.EstoqueController;
import br.com.maximasolutions.estoque.controller.EtiquetasController;
import br.com.maximasolutions.estoque.controller.PDVFormController;
import br.com.maximasolutions.estoque.controller.ProdutoComboFormController;
import br.com.maximasolutions.estoque.controller.ProdutoComprasController;
import br.com.maximasolutions.estoque.controller.ProdutoExtratoController;
import br.com.maximasolutions.estoque.controller.ProdutoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPorTamanhoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoRegimeNormalFormController;
import br.com.maximasolutions.estoque.controller.VendasPorProdutoViewController;
import br.com.maximasolutions.estoque.core.ProdutoEtiqueta;
import br.com.maximasolutions.estoque.core.ProdutoEtiquetaModelo;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDuplica;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private MenuItem menuItemBalancaToledo;
    @FXML
    private MenuItem menuItemOrdenar;
    @FXML
    private MenuItem menuItemImportar;
    @FXML
    private MenuItem menuItemAlterarPreco;
    @FXML
    private ComboBox<CategoriaProduto> cbbCategoriaProduto;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private CheckBox ccbEstoquePositivo;
    @FXML
    private CheckBox ccbServico;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Produto> tabela;
    @FXML
    private TableColumn<Produto, String> colNome;
    @FXML
    private TableColumn<Produto, String> colCodigo;
    @FXML
    private TableColumn<Produto, String> colCategoria;
    @FXML
    private TableColumn<Produto, String> colUnidade;
    @FXML
    private TableColumn<Produto, BigDecimal> colEstoque;
    @FXML
    private TableColumn<Produto, BigDecimal> colPrecoVenda;
    @FXML
    private TableColumn<Produto, BigDecimal> colMargemCusto;
    @FXML
    private TableColumn<Produto, BigDecimal> colMargemVenda;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UnidadeService unidadeService;
    private ObservableList<Produto> produtoList;
    private Configuracao conf;
    private Boolean multiSelected;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.produtoList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.multiSelected = false;
        this.conf = this.configuracaoService.load();
        this.ccbEstoquePositivo.setSelected(this.conf.getExibirEstoquePositivo().booleanValue());
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Produto);
        this.loadTabela();
    }

    private void delete() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto != null) {
            if (produto.getProdutoPaiTamanho() != null && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Todos os tamanhos ser\u00e3o exclu\u00eddos. Deseja continuar?")) {
                return;
            }
            if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o produto: '" + produto.getNome() + "'?"))) {
                try {
                    this.produtoService.remove(produto);
                    MaximaAlert.informe((StageManager)this.stageManager, (String)"Produto removido com sucesso.");
                }
                catch (MaximaException ex) {
                    Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel remover o produto.\n" + ex.getMessage()));
                }
            }
        }
        this.loadTabela();
    }

    private void produtoPorTamanho() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formProdutoPorTamanho(null);
    }

    private void formProdutoPorTamanho(Produto produto) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPorTamanhoForm.fxml", "Produto Por Tamanho");
            ProdutoPorTamanhoFormController controller = (ProdutoPorTamanhoFormController)stage.getUserData();
            controller.inicializa(produto);
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de cadastro de combo produto.");
        }
    }

    private void combo() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formCombo(null);
    }

    private void formCombo(Produto produto) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ComboForm.fxml", "Novo Combo");
            ProdutoComboFormController controller = (ProdutoComboFormController)stage.getUserData();
            controller.inicializa(produto);
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de cadastro de combo produto.");
        }
    }

    private void novo() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formProduto(null);
    }

    private void editaProduto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto != null) {
            if (produto.getCombo().booleanValue()) {
                this.formCombo(produto);
            } else if (produto.getProdutoPaiTamanho() != null) {
                this.formProdutoPorTamanho(produto.getProdutoPaiTamanho());
            } else {
                this.formProduto(produto);
            }
        }
    }

    private void formProduto(Produto produto) {
        if (this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoForm.fxml", "Cadastro Produto");
                ProdutoFormController controller = (ProdutoFormController)stage.getUserData();
                controller.inicializa(produto);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoRegimeNormalForm.fxml", "Cadastro Produto");
                ProdutoRegimeNormalFormController controller = (ProdutoRegimeNormalFormController)stage.getUserData();
                controller.inicializa(produto);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void duplicaProduto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto != null) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoForm.fxml", "Novo Produto");
                ProdutoFormController controller = (ProdutoFormController)stage.getUserData();
                produto.setId(null);
                produto.setCodigo(null);
                produto.setReferencia(null);
                produto.setUuid(null);
                produto.setSincronizado(Boolean.valueOf(false));
                produto.setEstoqueInicial(BigDecimal.ZERO);
                produto.setEstoqueAtual(BigDecimal.ZERO);
                produto.setEstoqueMinimo(BigDecimal.ZERO);
                produto.setFotoPrincipal(null);
                produto.setComposicao(null);
                controller.inicializa(produto);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form de cadastro de produto.\n" + ex.getMessage()));
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um produto para duplicar.");
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colCategoria.setCellValueFactory((Callback)new PropertyValueFactory("categoriaProduto"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidade"));
        this.colEstoque.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colPrecoVenda.setCellValueFactory((Callback)new PropertyValueFactory("precoVenda"));
        this.colMargemCusto.setCellValueFactory((Callback)new PropertyValueFactory("margemLucroCusto"));
        this.colMargemVenda.setCellValueFactory((Callback)new PropertyValueFactory("margemLucroVenda"));
        ColumnNumberFormatter numberFormatter = new ColumnNumberFormatter();
        this.colEstoque.setCellFactory((Callback)numberFormatter);
        this.colPrecoVenda.setCellFactory((Callback)numberFormatter);
        this.colMargemCusto.setCellFactory((Callback)numberFormatter);
        this.colMargemVenda.setCellFactory((Callback)numberFormatter);
        this.colNome.setCellFactory((Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.produtoList.clear();
        List list = this.produtoService.pesquisa((CategoriaProduto)this.cbbCategoriaProduto.getSelectionModel().getSelectedItem(), Boolean.valueOf(this.ccbAtivo.isSelected()), Boolean.valueOf(this.ccbEstoquePositivo.isSelected()), Boolean.valueOf(this.ccbServico.isSelected()), valorPesquisa);
        System.out.println("=== lista de produtos: " + list.size());
        for (Produto prod : list) {
            if (prod.getPorTamanho().booleanValue()) continue;
            this.produtoList.add((Object)prod);
        }
        this.tabela.setItems(this.produtoList);
    }

    private void carregaCombos() {
        ArrayList categorias = new ArrayList();
        categorias.add(null);
        categorias.addAll(this.categoriaProdutoService.list());
        this.cbbCategoriaProduto.setItems(FXCollections.observableArrayList(categorias));
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDuplica.setGraphic((Node)new MaximaIcone().duplca());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEtiqueta = new MenuItem("Etiqueta");
        menuEtiqueta.setOnAction(event -> this.etiqueta());
        MenuItem menuVendas = new MenuItem("Visualizar Vendas");
        menuVendas.setOnAction(event -> this.vendasPorProduto());
        MenuItem menuCompras = new MenuItem("Visualizar Compras");
        menuCompras.setOnAction(event -> this.comprasPorProduto());
        MenuItem menuExtrato = new MenuItem("Extrato");
        menuExtrato.setOnAction(event -> this.extratoProduto());
        MenuItem menuBalanco = new MenuItem("Atualizar Estoque");
        menuBalanco.setOnAction(event -> {
            if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
                return;
            }
            this.balancoProduto();
        });
        cm.getItems().add((Object)menuEtiqueta);
        cm.getItems().add((Object)menuVendas);
        cm.getItems().add((Object)menuCompras);
        cm.getItems().add((Object)menuBalanco);
        cm.getItems().add((Object)menuExtrato);
        return cm;
    }

    private void registraAcoes() {
        this.tabela.setContextMenu(this.getTableMenu());
        this.btnNovo.setOnAction(event -> this.novo());
        this.btnEdita.setOnAction(event -> this.editaProduto());
        this.btnDuplica.setOnAction(t -> this.duplicaProduto());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(t -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaProduto();
            }
        });
        this.menuItemBalancaToledo.setOnAction(evt -> this.geraArquivoBalancaToledo());
        this.menuItemOrdenar.setOnAction(evt -> this.ordenarForm());
        this.menuItemImportar.setOnAction(evt -> this.importarExcel());
        this.menuItemAlterarPreco.setOnAction(evt -> this.alterarPrecoLote());
        this.menuItemAlterarPreco.setDisable(false);
    }

    private void alterarPrecoLote() {
        if (!this.multiSelected.booleanValue()) {
            this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Tabela alterada para permitir selecionar mais de um produto.");
            return;
        }
        this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ObservableList listaProdutos = this.tabela.getSelectionModel().getSelectedItems();
        if (listaProdutos.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto informado na tabela.");
            return;
        }
        BigDecimal novoPrecoVenda = this.getPercentualAumento();
        if (novoPrecoVenda == null || novoPrecoVenda.compareTo(BigDecimal.ZERO) <= 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Percentual deve ser um valor maior que zero.");
            return;
        }
        try {
            this.produtoService.alteraPreco((List)listaProdutos, novoPrecoVenda);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Pre\u00e7os alterados com sucesso!");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Ocorreu um erro ao alterar os pre\u00e7os.\n" + ex.getMessage()));
        }
    }

    private BigDecimal getPercentualAumento() {
        BigDecimal valorUnitario = BigDecimal.ZERO;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.tabela.getScene().getWindow(), "/fxml/GetValorForm.fxml", "Informe o precentual de aumento:");
            GetValorFormController controller = (GetValorFormController)form.getUserData();
            form.showAndWait();
            valorUnitario = controller.getValor();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return valorUnitario;
    }

    private void importarExcel() {
        MaximaAlert.aviso((StageManager)this.stageManager, (String)"Entrar em contato com o suporte para ativar a fun\u00e7\u00e3o.");
    }

    private void ordenarForm() {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoOrdenaForm.fxml", "Ordernar Produto");
            form.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo de ordena\u00e7\u00e3o de produtos.");
        }
    }

    private void geraArquivoBalancaToledo() {
        String dirFile = System.getProperty("user.home") + File.separator + "Desktop";
        File arquivo = new File(dirFile = dirFile + "\\ITENSMGV.txt");
        if (!arquivo.exists()) {
            try {
                arquivo.createNewFile();
            }
            catch (IOException ex) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Ocorreu um erro ao criar o arquivo ITENSMGV.TXT\n" + ex.getMessage()));
                return;
            }
        }
        try {
            BufferedWriter buffWrite = new BufferedWriter(new FileWriter(dirFile));
            List balancaLista = this.produtoService.listaBalanca();
            boolean sucesso = true;
            for (Produto prod : balancaLista) {
                String linha = "010";
                String codigoProduto = prod.getReferencia();
                if (codigoProduto == null || codigoProduto.isEmpty() || codigoProduto.length() > 6) {
                    codigoProduto = prod.getCodigo();
                }
                if (codigoProduto == null || codigoProduto.length() < 3) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)("O c\u00f3digo interno do produto [ " + prod.getNome() + " ] deve conter 3 ou 4 caracteres."));
                    sucesso = false;
                    break;
                }
                linha = linha + MaximaUtils.completaZeroEsquerda((String)codigoProduto, (Integer)6);
                String preco = prod.getPrecoVenda().toString().replace(".", "");
                preco = MaximaUtils.completaZeroEsquerda((String)preco, (Integer)6);
                linha = linha + preco;
                linha = linha + MaximaUtils.completaZeroEsquerda((String)prod.getDiasValidade().toString(), (Integer)3);
                String desc1 = MaximaUtils.completaDireita((String)prod.getNome().toUpperCase(), (String)" ", (int)25);
                String desc2 = "";
                if (prod.getNome().length() > 25) {
                    desc2 = MaximaUtils.completaDireita((String)prod.getNome().substring(25), (String)" ", (int)25);
                }
                System.out.println(desc1 + desc2);
                linha = linha + MaximaUtils.completaDireita((String)desc1, (String)" ", (int)25);
                linha = linha + MaximaUtils.completaDireita((String)desc2, (String)" ", (int)25);
                linha = linha + "000000";
                linha = linha + "000";
                linha = linha + "0000";
                linha = linha + "1";
                linha = linha + "1";
                linha = linha + "0000";
                linha = linha + "000000000000";
                linha = linha + "00000000000";
                linha = linha + "0";
                linha = linha + "00";
                linha = linha + "\r\n";
                buffWrite.append(linha);
            }
            buffWrite.close();
            if (sucesso) {
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Arquivo para balan\u00e7a gerado com sucesso.\nArquivo localizado na \u00e1rea de trabalho.");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Diret\u00f3rio/Arquivo n\u00e3o encontrada para gerar ITENSMGV.TXT");
        }
        catch (Exception ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Ocorreu um erro ao recuperar lista de produtos.\n" + ex.getMessage()));
        }
    }

    private void etiqueta() {
        Long numeroItem;
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto == null) {
            return;
        }
        String imp = this.conf.getImpressoraEtiqueta();
        if (imp == null || imp.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Impressora de etiquetas n\u00e3o encontrada.");
            return;
        }
        PrintService impressora = null;
        PrintService[] pservices = PrinterJob.lookupPrintServices();
        if (pservices.length > 0) {
            for (PrintService ps : pservices) {
                if (!ps.getName().equalsIgnoreCase(imp)) continue;
                impressora = ps;
                break;
            }
        }
        if (impressora == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Impressora n\u00e3o instalada corretamente.");
            return;
        }
        ProdutoEtiquetaModelo etiquetaModelo = this.conf.getProdutoEtiquetaModelo();
        if (etiquetaModelo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de etiquta n\u00e3o informado em:\nAdministrativo->Configura\u00e7\u00e3o->Produtos");
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.tabela.getScene().getWindow(), "/fxml/GetNumeroForm.fxml", "Informe o n\u00famero do Item");
            GetNumeroFormController controller = (GetNumeroFormController)form.getUserData();
            controller.setLabel("Informe a quantidade de etiquetas:");
            form.showAndWait();
            numeroItem = controller.getNumero();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel excluir item.");
            return;
        }
        if (numeroItem == null || numeroItem < 0L) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe uma quantidade maior que zero.");
            return;
        }
        String texto = "";
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_40_30_1) {
            texto = ProdutoEtiqueta.etiqueta_40_30_1_coluna((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_50_30_1) {
            texto = ProdutoEtiqueta.etiqueta_50_30_1_coluna((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_50_30_SEM_PRECO) {
            texto = ProdutoEtiqueta.etiqueta_50_30_Sem_Preco((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_50_30_2) {
            texto = ProdutoEtiqueta.etiqueta_50_30_2_coluna((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_60_30_1) {
            texto = ProdutoEtiqueta.etiqueta_60_30_1_coluna((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_60_40_1) {
            texto = ProdutoEtiqueta.etiqueta_60_40_1_coluna((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_60_40_1_PARCELADO) {
            texto = ProdutoEtiqueta.etiqueta_60_40_parcelado((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_gondola) {
            texto = ProdutoEtiqueta.etiqueta_gondola((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_gondola_35) {
            texto = ProdutoEtiqueta.etiqueta_gondola_35((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_33_55_2) {
            numeroItem = (numeroItem + numeroItem % 2L) / 2L;
            texto = ProdutoEtiqueta.etiqueta_roupa_33_55_2((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_50_75_2) {
            numeroItem = (numeroItem + numeroItem % 2L) / 2L;
            texto = ProdutoEtiqueta.etiqueta_roupa_50_75_2((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_50_75_2_INVERTIDA) {
            numeroItem = (numeroItem + numeroItem % 2L) / 2L;
            texto = ProdutoEtiqueta.etiqueta_roupa_50_75_2_INVERTIDA((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_50_75_1) {
            texto = ProdutoEtiqueta.etiqueta_roupa_50_75_1((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_33_18_3) {
            texto = ProdutoEtiqueta.etiqueta_33_18_3((Produto)produto, (Integer)numeroItem.intValue(), (String)this.conf.getImpressoraEtiqueta());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_33_18_3_SEM_PRECO) {
            texto = ProdutoEtiqueta.etiqueta_33_18_3_SEM_PRECO((Produto)produto, (Integer)numeroItem.intValue(), (String)this.conf.getImpressoraEtiqueta());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Personalizada) {
            String modeloEtiquetaPersonalizada = MaximaConfig.modeloEtiquetaPersonalizada();
            System.out.println("== etiqueta modelo: " + modeloEtiquetaPersonalizada);
            if (modeloEtiquetaPersonalizada == null || modeloEtiquetaPersonalizada.isEmpty()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum modelo de etiqueta configurado.");
                return;
            }
            if (modeloEtiquetaPersonalizada.equalsIgnoreCase("duradiadores")) {
                texto = ProdutoEtiqueta.etiqueta_du_radiadores((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
            }
            if (modeloEtiquetaPersonalizada.equalsIgnoreCase("fruta_no_palito")) {
                new EtiquetasController().frutaNoPalito(this.stageManager, produto, Integer.valueOf(numeroItem.intValue()), this.conf.getImpressoraEtiqueta());
                return;
            }
            if (modeloEtiquetaPersonalizada.equalsIgnoreCase("deluxe_brinco")) {
                texto = ProdutoEtiqueta.deluxe_brinco((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
            }
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_joia) {
            texto = ProdutoEtiqueta.joia((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (etiquetaModelo == ProdutoEtiquetaModelo.Etiqueta_25_15_4) {
            numeroItem = numeroItem % 4L == 0L ? Long.valueOf(numeroItem / 4L) : Long.valueOf(numeroItem / 4L + 1L);
            texto = ProdutoEtiqueta.etiqueta_25_15_5((Configuracao)this.conf, (Produto)produto, (String)numeroItem.toString());
        }
        if (texto == null || texto.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de etiqueta n\u00e3o suportado.");
            return;
        }
        ByteArrayInputStream pis = new ByteArrayInputStream(texto.getBytes());
        DocFlavor.INPUT_STREAM df = DocFlavor.INPUT_STREAM.AUTOSENSE;
        SimpleDoc d = new SimpleDoc(pis, df, null);
        DocPrintJob job = impressora.createPrintJob();
        try {
            job.print(d, null);
        }
        catch (PrintException e) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao efetuar impress\u00e3o da eitqueta.");
        }
    }

    private void vendasPorProduto() {
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm(this.stageManager, "/fxml/estoque/produto/VendasPorProdutoView.fxml", "Vendas por Produto");
            VendasPorProdutoViewController controller = (VendasPorProdutoViewController)form.getUserData();
            controller.inicializa(produto);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EstoqueBalancoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel visualizar vendas do produto.");
        }
    }

    private void comprasPorProduto() {
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm(this.stageManager, "/fxml/estoque/produto/ComprasPorProdutoView.fxml", "Compras por Produto");
            ProdutoComprasController controller = (ProdutoComprasController)form.getUserData();
            controller.inicializa(produto);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EstoqueBalancoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel visualizar vendas do produto.");
        }
    }

    private void extratoProduto() {
        System.out.println("--- entrou aqui ----");
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm(this.stageManager, "/fxml/estoque/produto/ExtratoProdutoView.fxml", "Exrato Estoque Produto");
            ProdutoExtratoController controller = (ProdutoExtratoController)form.getUserData();
            controller.inicializa(produto);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EstoqueBalancoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel visualizar vendas do produto.");
        }
    }

    private void balancoProduto() {
        BigDecimal estoque;
        Produto produto = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (produto == null) {
            return;
        }
        Boolean confirma = false;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnDelete.getScene().getWindow(), "/fxml/EstoqueForm.fxml", "");
            EstoqueController controller = (EstoqueController)form.getUserData();
            form.showAndWait();
            estoque = controller.getEstoque();
            confirma = controller.getConfirma();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro ao abrir m\u00f3dulo de autoriza\u00e7\u00e3o.");
            return;
        }
        if (confirma.booleanValue()) {
            try {
                this.produtoService.atualizaEstoque(produto, estoque);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Estoque atualizado com sucesso.");
                this.loadTabela();
            }
            catch (Exception e) {
                Logger.getLogger(ProdutoController.class.getSimpleName()).log(Level.SEVERE, null, e);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao atualizar estoque.\n" + e.getMessage()));
            }
        }
    }
}

