/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.bean.ProdutoExtratoDto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.ProdutoService;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoExtratoController
extends MaximaController
implements Initializable {
    @FXML
    private TableView<ProdutoExtratoDto> tabela;
    @FXML
    private TableColumn<ProdutoExtratoDto, String> colData;
    @FXML
    private TableColumn<ProdutoExtratoDto, String> colOperacao;
    @FXML
    private TableColumn<ProdutoExtratoDto, BigDecimal> colEstoqueAtual;
    @FXML
    private TableColumn<ProdutoExtratoDto, BigDecimal> colEstoqueAnterior;
    @FXML
    private TableColumn<ProdutoExtratoDto, BigDecimal> colQuantidade;
    @FXML
    private Button btnFechar;
    @FXML
    private Label produtoLabel;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    private Produto produto;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa(Produto produto) {
        this.produto = produto;
        this.produtoLabel.setText(produto.getNome().toUpperCase());
        this.loadTabela();
    }

    private void setColumnProperties() {
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colOperacao.setCellValueFactory((Callback)new PropertyValueFactory("operacao"));
        this.colEstoqueAtual.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colEstoqueAnterior.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAnterior"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
    }

    private void loadTabela() {
        List list = this.produtoService.extratoProduto(this.produto.getId());
        this.tabela.setItems(FXCollections.observableArrayList((Collection)list));
    }

    private void carregaIcones() {
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void close() {
        Stage stage = (Stage)this.tabela.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.close());
    }
}

