/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.MateriaPrimaPesquisaController;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.modelo.ProdutoIngrediente;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoIngredienteFormController
extends MaximaController
implements Initializable {
    private ProdutoIngrediente ingrediente;
    private MateriaPrima materiaPrima;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private MateriaPrimaService materiaPrimaService;
    @FXML
    private TextField tfId;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private ComboBox<Unidade> cbUnidade;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfCustoUnitario;
    @FXML
    private TextField tfCustoTotal;
    @FXML
    private TextField tfMateriaPrimaPesquisa;
    @FXML
    private TextField tfMateriaPrimaNome;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa(ProdutoIngrediente produtoIngrediente) {
        this.materiaPrima = null;
        this.ingrediente = produtoIngrediente;
        if (this.ingrediente != null) {
            this.materiaPrima = this.ingrediente.getMateriaPrima();
        }
    }

    public ProdutoIngrediente getIngrediente() {
        return this.ingrediente;
    }

    private void salva() {
        this.get();
        if (!this.validaForm()) {
            return;
        }
        this.fechaForm();
    }

    private void get() {
        if (this.ingrediente == null || this.ingrediente.getId() == null) {
            this.ingrediente = new ProdutoIngrediente();
        }
        this.ingrediente.setCusto(MaximaNumber.moneyToBigDecimal((String)this.tfCustoTotal.getText()));
        this.ingrediente.setQuantidade(MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText()));
        this.ingrediente.setMateriaPrima(this.materiaPrima);
        this.ingrediente.setUnidade((Unidade)this.cbUnidade.getSelectionModel().getSelectedItem());
    }

    private void calculaPrecoCusto() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfCustoTotal.setText("0,00");
            return;
        }
        BigDecimal custoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfCustoUnitario.getText());
        if (custoUnitario == null || custoUnitario.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfCustoTotal.setText("0,00");
            return;
        }
        BigDecimal custoTotal = custoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfCustoTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)custoTotal, (int)2));
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.ingrediente.getQuantidade() == null || this.ingrediente.getQuantidade().compareTo(BigDecimal.ZERO) <= 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfCustoUnitario);
        MaximaMask.monetaryField((TextField)this.tfCustoTotal);
    }

    private void loadCombos() {
        this.cbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnProdutoPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(t -> this.salva());
        this.tfQuantidade.setOnKeyReleased(evt -> this.calculaPrecoCusto());
        this.tfMateriaPrimaPesquisa.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.pesquisaMateriaPrima();
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaMateriaPrimaForm());
    }

    private void pesquisaMateriaPrima() {
        String materiaPrimaCodigo = this.tfMateriaPrimaPesquisa.getText().trim();
        if (materiaPrimaCodigo.isEmpty()) {
            return;
        }
        this.materiaPrima = this.materiaPrimaService.getByCodigo(materiaPrimaCodigo);
        if (this.materiaPrima != null) {
            this.loadDadosMateriaPrima();
        } else {
            this.pesquisaMateriaPrimaForm();
        }
    }

    private void pesquisaMateriaPrimaForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/materiaPrima/MateriaPrimaPesquisa.fxml", "Pesquisa de materiaPrima");
            MateriaPrimaPesquisaController controller = (MateriaPrimaPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMateriaPrimaPesquisa.getText().trim());
            stage.showAndWait();
            this.materiaPrima = controller.getMateriaPrimaSelecionado();
            this.loadDadosMateriaPrima();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'MateriaPrimaPesquisa.fxml'");
        }
    }

    private void loadDadosMateriaPrima() {
        if (this.materiaPrima != null) {
            this.tfMateriaPrimaPesquisa.setText(this.materiaPrima.getCodigo());
            this.tfMateriaPrimaNome.setText(this.materiaPrima.getNome().toUpperCase());
            this.tfCustoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getUltimoCusto(), (int)2));
            this.cbUnidade.getSelectionModel().select((Object)this.materiaPrima.getUnidade());
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            this.tfMateriaPrimaNome.setText("");
            this.tfMateriaPrimaPesquisa.setText("");
            this.tfQuantidade.setText("");
            this.tfCustoUnitario.setText("");
            this.cbUnidade.getSelectionModel().select(null);
            this.tfMateriaPrimaPesquisa.requestFocus();
        }
        this.calculaPrecoCusto();
    }

    private void fechaForm() {
        Stage stage = (Stage)this.tfId.getScene().getWindow();
        stage.close();
    }
}

