/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoObservacaoFormController;
import br.com.maximasolutions.estoque.modelo.ProdutoObservacao;
import br.com.maximasolutions.estoque.service.ProdutoObservacaoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoObservacaoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btNovo;
    @FXML
    private Button btEdita;
    @FXML
    private Button btDelete;
    @FXML
    private Button btAtualiza;
    @FXML
    private TableView<ProdutoObservacao> tabela;
    @FXML
    private TableColumn<ProdutoObservacao, String> colNome;
    @FXML
    private TableColumn<ProdutoObservacao, String> colCategoria;
    @FXML
    private TableColumn<ProdutoObservacao, String> colUnidade;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoObservacaoService produtoObservacaoService;
    private ObservableList<ProdutoObservacao> produtoObservacaoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.produtoObservacaoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaProduto();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
    }

    @FXML
    private void edita(ActionEvent event) {
        this.editaProduto();
    }

    @FXML
    private void delete(ActionEvent event) {
        ProdutoObservacao produto = (ProdutoObservacao)this.tabela.getSelectionModel().getSelectedItem();
        if (produto != null && MaximaAlert.confirmacao((String)("Deseja remover o produto: '" + produto.getNome() + "'?"))) {
            this.produtoObservacaoService.delete((Object)produto);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Produto removido com sucesso.");
        }
        this.loadTabela();
    }

    @FXML
    private void atualiza(ActionEvent event) {
        this.loadTabela();
    }

    @FXML
    private void novo(ActionEvent event) throws IOException {
        Stage stage = this.createWindowForm();
        ProdutoObservacaoFormController controller = (ProdutoObservacaoFormController)stage.getUserData();
        controller.setProdutoObservacao(null);
        stage.setTitle("Cadastro de Produto Observacao");
        stage.showAndWait();
        this.loadTabela();
    }

    private void editaProduto() {
        ProdutoObservacao complemento = (ProdutoObservacao)this.tabela.getSelectionModel().getSelectedItem();
        if (complemento != null) {
            try {
                Stage stage = this.createWindowForm();
                ProdutoObservacaoFormController controller = (ProdutoObservacaoFormController)stage.getUserData();
                controller.setProdutoObservacao(complemento);
                stage.setTitle("Edi\u00e7\u00e3o de Produto Observacao");
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ProdutoObservacaoController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Stage createWindowForm() throws IOException {
        FXMLLoader loader = this.stageManager.loader("/fxml/estoque/produtoObservacao/ProdutoObservacaoForm.fxml");
        AnchorPane content = (AnchorPane)loader.load();
        Scene scene = new Scene((Parent)content);
        ProdutoObservacaoFormController controller = (ProdutoObservacaoFormController)loader.getController();
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.DECORATED);
        stage.initOwner((Window)this.stageManager.getStage());
        stage.setScene(scene);
        return stage;
    }

    private void setColumnProperties() {
        this.colCategoria.setCellValueFactory((Callback)new PropertyValueFactory("categoriaProduto"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidade"));
    }

    private void loadTabela() {
        this.produtoObservacaoList.clear();
        this.produtoObservacaoList.addAll((Collection)this.produtoObservacaoService.findAll());
        this.tabela.setItems(this.produtoObservacaoList);
    }

    private void carregaIcones() {
        this.btNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }
}

