/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaImage;
import br.com.maximasolutions.estoque.controller.CategoriaProdutoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoIngredienteFormController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoFoto;
import br.com.maximasolutions.estoque.modelo.ProdutoIngrediente;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.fiscal.controller.FiscalProdutoPesquisaController;
import br.com.maximasolutions.fiscal.modelo.FiscalProduto;
import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class ProdutoRegimeNormalFormController
extends MaximaController
implements Initializable {
    private Produto produto;
    private ProdutoFoto produtoFoto;
    private ProdutoFoto produtoFoto2;
    private List<ProdutoIngrediente> ingredientes;
    private Configuracao conf;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private NcmService ncmService;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabFiscal;
    @FXML
    private TextField tfId;
    @FXML
    private CheckBox cbAtivo;
    @FXML
    private CheckBox cbEstoqueNegativo;
    @FXML
    private CheckBox ccbServico;
    @FXML
    private CheckBox ccbBalanca;
    @FXML
    private CheckBox ccbAgrupar;
    @FXML
    private CheckBox ccbVendasExternas;
    @FXML
    private CheckBox ccbDestaque;
    @FXML
    private ComboBox<CategoriaProduto> cbCategoria;
    @FXML
    private Button btnCategoriaProdutoAdd;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnCodigo;
    @FXML
    private Button btnImage;
    @FXML
    private Button btnImage2;
    @FXML
    private Button btnIngredienteAdd;
    @FXML
    private Button btnDadosFiscais;
    @FXML
    private ComboBox<Unidade> cbUnidade;
    @FXML
    private ComboBox<Unidade> cbbUnidadeEntrada;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfCodigoBarras;
    @FXML
    private TextField tfCodigoInterno;
    @FXML
    private TextField tfPrecoCusto;
    @FXML
    private TextField tfPrecoVenda;
    @FXML
    private TextField tfPreco2;
    @FXML
    private TextField tfEstoqueInicial;
    @FXML
    private TextField tfEstoqueAtual;
    @FXML
    private TextField tfEstoqueMinimo;
    @FXML
    private TextField tfCodigoNcm;
    @FXML
    private TextField tfCodigoCest;
    @FXML
    private TextField tfCfopDentroEstado;
    @FXML
    private TextField tfCfopForaEstado;
    @FXML
    private TextField tfAliquotaIcms;
    @FXML
    private TextField tfAliquotaCreditoIcms;
    @FXML
    private TextField tfAliquotaIVA;
    @FXML
    private TextField tfAliquotaPis;
    @FXML
    private TextField tfAliquotaCofins;
    @FXML
    private TextField tfDescontoPermitido;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private TextField tfComissao;
    @FXML
    private TextField tfMargemCusto;
    @FXML
    private TextField tfMargemVenda;
    @FXML
    private TextField tfDescricao2;
    @FXML
    private TextField tfFatorConversaoEntrada;
    @FXML
    private TextField tfCodigoEntrada;
    @FXML
    private TextField tfQuantidadeMinimaVenda;
    @FXML
    private ComboBox<NFOrigem> cbOrigem;
    @FXML
    private ComboBox<NFNotaInfoImpostoTributacaoICMS> cbCSOSN;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaPIS> cbPis;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaCOFINS> cbCofins;
    @FXML
    private ImageView imagePrincipal;
    @FXML
    private ImageView imagePrincipal2;
    @FXML
    private TextArea txtComposicao;
    @FXML
    private TableView<ProdutoIngrediente> tabelaIngredientes;
    @FXML
    private TableColumn<Produto, String> colMateriaPrima;
    @FXML
    private TableColumn<Produto, BigDecimal> colQuantidade;

    public void initialize(URL url, ResourceBundle rb) {
        this.tfEstoqueInicial.setDisable(true);
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
        this.setColumnProperties();
    }

    public Produto getProdutoCadastrado() {
        return this.produto;
    }

    private void fechaForm() {
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }

    private void salva() {
        this.produto = this.getProduto();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.produto, new Class[0]);
        if (!this.validaForm()) {
            return;
        }
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        if (this.produto.getPrecoVenda().compareTo(BigDecimal.ZERO) == 0 && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cadastrar o produto com pre\u00e7o de venda zerado?")) {
            return;
        }
        try {
            this.produto = this.produtoService.salva(this.produto, null, this.ingredientes, this.produtoFoto, this.produtoFoto2);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Produto salvo com sucesso.");
            this.fechaForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ProdutoRegimeNormalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setProduto() {
        if (this.produto.getId() != null) {
            this.tfId.setText(this.produto.getId().toString());
            this.ingredientes = this.produtoService.listaIngredientes(this.produto);
            this.produtoFoto = this.produtoService.getFotoPrincipal(this.produto.getId());
            this.produtoFoto2 = this.produtoService.getFoto(this.produto.getId());
        }
        this.cbAtivo.setSelected(this.produto.isAtivo().booleanValue());
        this.cbEstoqueNegativo.setSelected(this.produto.isEstoqueNegativo().booleanValue());
        this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.produto.getUltimaAlteracao()));
        this.tfNome.setText(this.produto.getNome());
        this.tfDescricao2.setText(this.produto.getObservacao());
        this.cbCategoria.getSelectionModel().select((Object)this.produto.getCategoriaProduto());
        this.cbUnidade.getSelectionModel().select((Object)this.produto.getUnidade());
        this.tfCodigoBarras.setText(this.produto.getCodigo());
        this.tfCodigoInterno.setText(this.produto.getReferencia());
        this.tfPrecoCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getUltimoCusto(), (int)2));
        this.tfMargemCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getMargemLucroCusto(), (int)2));
        this.tfMargemVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getMargemLucroVenda(), (int)2));
        this.tfPrecoVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
        this.tfPreco2.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPreco2(), (int)2));
        this.tfEstoqueInicial.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getEstoqueInicial(), (int)2));
        this.tfQuantidadeMinimaVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getQuantidadeMinimaVenda(), (int)2));
        this.tfEstoqueAtual.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getEstoqueAtual(), (int)2));
        this.tfEstoqueMinimo.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getEstoqueMinimo(), (int)2));
        this.tfCodigoNcm.setText(this.produto.getNcm());
        this.tfCodigoCest.setText(this.produto.getCest());
        this.tfCfopDentroEstado.setText(this.produto.getCfop());
        this.tfCfopForaEstado.setText(this.produto.getCfopInterEstad());
        this.cbOrigem.getSelectionModel().select((Object)this.produto.getOrigem());
        this.cbCSOSN.getSelectionModel().select((Object)this.produto.getTributacaoICMS());
        this.cbPis.getSelectionModel().select((Object)this.produto.getPis());
        this.cbCofins.getSelectionModel().select((Object)this.produto.getCofins());
        this.tfAliquotaIcms.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaICMS(), (int)2));
        this.tfAliquotaCreditoIcms.setText(MaximaNumber.bigDecimalToString((BigDecimal)BigDecimal.ZERO, (int)2));
        this.tfAliquotaIVA.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaIVA(), (int)2));
        this.tfAliquotaPis.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaPis(), (int)2));
        this.tfAliquotaCofins.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaCofins(), (int)2));
        this.tfDescontoPermitido.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getDescontoPermitido(), (int)2));
        this.tfComissao.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getComissao(), (int)2));
        this.ccbServico.setSelected(this.produto.getServico().booleanValue());
        this.ccbBalanca.setSelected(this.produto.getBalanca().booleanValue());
        this.ccbAgrupar.setSelected(this.produto.getAgrupar().booleanValue());
        this.tfFatorConversaoEntrada.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getFatorConversaoEntrada(), (int)4));
        this.cbbUnidadeEntrada.getSelectionModel().select((Object)this.produto.getUnidadeEntrada());
        this.tfCodigoEntrada.setText(this.produto.getCodigoEntrada());
        this.txtComposicao.setText(this.produto.getComposicao());
        this.ccbVendasExternas.setSelected(this.produto.getVendasExternas().booleanValue());
        this.ccbDestaque.setSelected(this.produto.getDestaque().booleanValue());
        if (this.produtoFoto != null) {
            this.exibeImagem(new ByteArrayInputStream(this.produtoFoto.getBytes()));
        }
        if (this.produtoFoto2 != null) {
            this.exibeImagem2(new ByteArrayInputStream(this.produtoFoto2.getBytes()));
        }
        this.tfNome.requestFocus();
    }

    private Produto getProduto() {
        if (this.produto == null) {
            this.produto = new Produto();
        }
        this.produto.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.produto.setObservacao(MaximaUtils.getText((String)this.tfDescricao2.getText()));
        this.produto.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        this.produto.setEstoqueNegativo(Boolean.valueOf(this.cbEstoqueNegativo.isSelected()));
        this.produto.setCategoriaProduto((CategoriaProduto)this.cbCategoria.getSelectionModel().getSelectedItem());
        this.produto.setUnidade((Unidade)this.cbUnidade.getSelectionModel().getSelectedItem());
        this.produto.setCodigo(MaximaUtils.getText((String)this.tfCodigoBarras.getText()));
        this.produto.setReferencia(MaximaUtils.getText((String)this.tfCodigoInterno.getText()));
        this.produto.setUltimoCusto(MaximaNumber.moneyToBigDecimal((String)this.tfPrecoCusto.getText()));
        this.produto.setPrecoVenda(MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText()));
        this.produto.setPreco2(MaximaNumber.moneyToBigDecimal((String)this.tfPreco2.getText()));
        this.produto.setEstoqueInicial(MaximaNumber.moneyToBigDecimal((String)this.tfEstoqueInicial.getText()));
        this.produto.setEstoqueAtual(MaximaNumber.moneyToBigDecimal((String)this.tfEstoqueAtual.getText()));
        this.produto.setEstoqueMinimo(MaximaNumber.moneyToBigDecimal((String)this.tfEstoqueMinimo.getText()));
        this.produto.setQuantidadeMinimaVenda(MaximaNumber.moneyToBigDecimal((String)this.tfQuantidadeMinimaVenda.getText()));
        this.produto.setNcm(MaximaUtils.getText((String)this.tfCodigoNcm.getText()));
        if ((this.produto.getNcm() == null || this.produto.getNcm().isEmpty()) && !this.conf.getProdutoFiscal().booleanValue()) {
            this.produto.setNcm("00000000");
        }
        this.produto.setCest(MaximaUtils.getText((String)this.tfCodigoCest.getText()));
        this.produto.setCfop(MaximaUtils.getText((String)this.tfCfopDentroEstado.getText()));
        this.produto.setCfopInterEstad(MaximaUtils.getText((String)this.tfCfopForaEstado.getText()));
        this.produto.setOrigem((NFOrigem)this.cbOrigem.getSelectionModel().getSelectedItem());
        this.produto.setTributacaoICMS((NFNotaInfoImpostoTributacaoICMS)this.cbCSOSN.getSelectionModel().getSelectedItem());
        this.produto.setPis((NFNotaInfoSituacaoTributariaPIS)this.cbPis.getSelectionModel().getSelectedItem());
        this.produto.setCofins((NFNotaInfoSituacaoTributariaCOFINS)this.cbCofins.getSelectionModel().getSelectedItem());
        this.produto.setAliquotaICMS(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaIcms.getText()));
        this.produto.setAliquotaIVA(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaIVA.getText()));
        this.produto.setAliquotaPis(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaPis.getText()));
        this.produto.setAliquotaCofins(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaCofins.getText()));
        this.produto.setDescontoPermitido(MaximaNumber.moneyToBigDecimal((String)this.tfDescontoPermitido.getText()));
        this.produto.setComissao(MaximaNumber.moneyToBigDecimal((String)this.tfComissao.getText()));
        this.produto.setServico(Boolean.valueOf(this.ccbServico.isSelected()));
        this.produto.setUnidadeEntrada((Unidade)this.cbbUnidadeEntrada.getSelectionModel().getSelectedItem());
        this.produto.setFatorConversaoEntrada(MaximaNumber.quantidadeToBigDecimal((String)this.tfFatorConversaoEntrada.getText()));
        this.produto.setCodigoEntrada(MaximaUtils.getText((String)this.tfCodigoEntrada.getText()));
        this.produto.setBalanca(Boolean.valueOf(this.ccbBalanca.isSelected()));
        this.produto.setAgrupar(Boolean.valueOf(this.ccbAgrupar.isSelected()));
        this.produto.setComposicao(MaximaUtils.getText((String)this.txtComposicao.getText()));
        this.produto.setVendasExternas(Boolean.valueOf(this.ccbVendasExternas.isSelected()));
        this.produto.setDestaque(Boolean.valueOf(this.ccbDestaque.isSelected()));
        boolean validarDadosFiscais = MaximaConfig.getInstance().getProperty("produto_fiscal", "s").equalsIgnoreCase("s");
        if (!validarDadosFiscais && (this.produto.getNcm() == null || this.produto.getNcm().isEmpty())) {
            this.produto.setNcm("0");
        }
        return this.produto;
    }

    public void inicializa() {
        if (MaximaConfig.getAlteraEstoque().booleanValue()) {
            this.tfEstoqueAtual.setDisable(false);
        }
        this.produtoFoto = null;
        this.produtoFoto2 = null;
        this.ingredientes = new ArrayList();
        this.conf = this.configuracaoService.load();
        this.ccbAgrupar.setSelected(true);
    }

    public void inicializa(Produto produto1) {
        this.ingredientes = new ArrayList();
        this.produto = produto1;
        if (this.produto != null) {
            if (this.produto.getId() != null) {
                this.produto = this.produtoService.getById(this.produto.getId().longValue());
            }
            this.setProduto();
        }
        this.loadTabela();
    }

    public static byte[] toByteArray(BufferedImage bi, String format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, format, baos);
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    private void exibeImagem(ByteArrayInputStream stream) {
        Image image = new Image((InputStream)stream);
        this.imagePrincipal.setImage(image);
    }

    private void exibeImagem2(ByteArrayInputStream stream) {
        Image image = new Image((InputStream)stream);
        this.imagePrincipal2.setImage(image);
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoCusto);
        MaximaMask.monetaryField((TextField)this.tfPrecoVenda);
        MaximaMask.monetaryField((TextField)this.tfPreco2);
        MaximaMask.monetaryField((TextField)this.tfEstoqueInicial);
        MaximaMask.monetaryField((TextField)this.tfEstoqueAtual);
        MaximaMask.monetaryField((TextField)this.tfEstoqueMinimo);
        MaximaMask.monetaryField((TextField)this.tfQuantidadeMinimaVenda);
        MaximaMask.monetaryField((TextField)this.tfAliquotaCreditoIcms);
        MaximaMask.monetaryField((TextField)this.tfAliquotaIVA);
        MaximaMask.monetaryField((TextField)this.tfAliquotaPis);
        MaximaMask.monetaryField((TextField)this.tfAliquotaCofins);
        MaximaMask.monetaryField((TextField)this.tfDescontoPermitido);
        MaximaMask.monetaryField((TextField)this.tfComissao);
        MaximaMask.monetaryField((TextField)this.tfMargemCusto);
        MaximaMask.monetaryField((TextField)this.tfMargemVenda);
    }

    private void loadCombos() {
        this.cbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.list()));
        this.cbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
        this.cbbUnidadeEntrada.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
        this.cbOrigem.setItems(FXCollections.observableArrayList((Object[])NFOrigem.values()));
        this.cbCSOSN.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoImpostoTributacaoICMS.values()));
        this.cbPis.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaPIS.values()));
        this.cbCofins.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaCOFINS.values()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCategoriaProdutoAdd.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnCodigo.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void registraAcoes() {
        this.btnDadosFiscais.setOnAction(evt -> this.carregarDadosFiscais());
        this.tabelaIngredientes.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteIngrediente();
            }
        });
        this.btnIngredienteAdd.setOnAction(evt -> this.addIngrediente());
        this.tfEstoqueInicial.setOnKeyReleased(event -> this.tfEstoqueAtual.setText(this.tfEstoqueInicial.getText()));
        this.btnSalva.setOnAction(t -> this.salva());
        this.btnImage.setOnAction(evt -> this.carregaImagem());
        this.btnImage2.setOnAction(evt -> this.carregaImagem2());
        this.tfPrecoCusto.setOnKeyReleased(evt -> {
            if (this.conf.getAlteraPrecoVenda().booleanValue()) {
                this.calculaPrecoVenda();
            } else {
                this.calculaMargem();
            }
        });
        this.tfPrecoVenda.setOnKeyReleased(evt -> this.calculaMargem());
        this.tfMargemCusto.setOnKeyReleased(evt -> this.calculaPrecoVenda());
        this.btnCodigo.setOnAction(evt -> {
            String codigo = this.produtoService.geraCodigo();
            this.tfCodigoBarras.setText(codigo);
            this.tfCodigoInterno.setText(codigo);
        });
        this.btnCategoriaProdutoAdd.setOnAction(evt -> this.addCategoria());
    }

    private void carregarDadosFiscais() {
        FiscalProduto fiscalProduto;
        try {
            Stage formPesquisa = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnDadosFiscais.getScene().getWindow(), "/fxml/fiscal/produtoFiscal/FiscalProdutoPesquisa.fxml", "Pesquisar Dados Fiscais");
            FiscalProdutoPesquisaController controller = (FiscalProdutoPesquisaController)formPesquisa.getUserData();
            formPesquisa.showAndWait();
            fiscalProduto = controller.getItemSelecionado();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoRegimeNormalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Erro ao abrir janela com os dados fiscais.");
            return;
        }
        if (fiscalProduto != null) {
            this.tfCodigoNcm.setText(fiscalProduto.getNcm());
            this.tfCfopDentroEstado.setText(fiscalProduto.getCfop());
            this.tfCfopForaEstado.setText(fiscalProduto.getCfopInterEstad());
            this.cbOrigem.getSelectionModel().select((Object)fiscalProduto.getOrigem());
            this.cbCSOSN.getSelectionModel().select((Object)fiscalProduto.getTributacaoICMS());
            this.cbPis.getSelectionModel().select((Object)fiscalProduto.getPis());
            this.cbCofins.getSelectionModel().select((Object)fiscalProduto.getCofins());
        }
    }

    private void deleteIngrediente() {
        ProdutoIngrediente ingrediente = (ProdutoIngrediente)this.tabelaIngredientes.getSelectionModel().getSelectedItem();
        if (ingrediente == null) {
            return;
        }
        int cont = 0;
        for (ProdutoIngrediente ing : this.ingredientes) {
            if (ingrediente.getNumeroItem().equals(ing.getNumeroItem())) {
                this.ingredientes.remove(cont);
                break;
            }
            ++cont;
        }
        cont = 1;
        for (ProdutoIngrediente ing : this.ingredientes) {
            ing.setNumeroItem(Integer.valueOf(cont));
            ++cont;
        }
        this.loadTabela();
    }

    private void addIngrediente() {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/IngredienteForm.fxml", "Adicionar ingrediente");
            ProdutoIngredienteFormController controller = (ProdutoIngredienteFormController)form.getUserData();
            controller.inicializa(null);
            form.showAndWait();
            ProdutoIngrediente ingrediente = controller.getIngrediente();
            if (ingrediente != null) {
                if (this.ingredientes == null) {
                    this.ingredientes = new ArrayList();
                }
                ingrediente.setNumeroItem(Integer.valueOf(this.ingredientes.size() + 1));
                this.ingredientes.add(ingrediente);
                this.loadTabela();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoRegimeNormalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo de adicionar ingrediente.");
        }
    }

    private void carregaImagem() {
        if (this.conf.getProdutoDiretorioFoto() == null || this.conf.getProdutoDiretorioFoto().isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Diret\u00f3rio de imagens do produto n\u00e3o configurado.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Selecionar imagem produto");
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg", "*.png"});
        chooser.getExtensionFilters().add((Object)filter);
        File file = chooser.showOpenDialog(this.btnImage.getScene().getWindow());
        if (file != null) {
            try {
                BufferedImage inputImage = ImageIO.read(file);
                BufferedImage outputImage = MaximaImage.resizeImage((BufferedImage)inputImage, (int)1080, (int)1080);
                byte[] bytes = ProdutoRegimeNormalFormController.toByteArray((BufferedImage)outputImage, (String)"jpg");
                this.exibeImagem(new ByteArrayInputStream(bytes));
                if (this.produtoFoto == null) {
                    this.produtoFoto = new ProdutoFoto();
                }
                this.produtoFoto.setBytes(bytes);
            }
            catch (IOException ex) {
                Logger.getLogger(ProdutoRegimeNormalFormController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void carregaImagem2() {
        if (this.conf.getProdutoDiretorioFoto() == null || this.conf.getProdutoDiretorioFoto().isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Diret\u00f3rio de imagens do produto n\u00e3o configurado.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Selecionar imagem produto");
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg", "*.png"});
        chooser.getExtensionFilters().add((Object)filter);
        File file = chooser.showOpenDialog(this.btnImage.getScene().getWindow());
        if (file != null) {
            try {
                BufferedImage inputImage = ImageIO.read(file);
                BufferedImage outputImage = MaximaImage.resizeImage((BufferedImage)inputImage, (int)1080, (int)1080);
                byte[] bytes = ProdutoRegimeNormalFormController.toByteArray((BufferedImage)outputImage, (String)"jpg");
                this.exibeImagem2(new ByteArrayInputStream(bytes));
                if (this.produtoFoto2 == null) {
                    this.produtoFoto2 = new ProdutoFoto();
                }
                this.produtoFoto2.setBytes(bytes);
            }
            catch (IOException ex) {
                Logger.getLogger(ProdutoRegimeNormalFormController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void setColumnProperties() {
        this.colMateriaPrima.setCellValueFactory((Callback)new PropertyValueFactory("materiaPrima"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        ColumnNumberFormatter numberFormatter = new ColumnNumberFormatter();
        this.colQuantidade.setCellFactory((Callback)numberFormatter);
    }

    private void loadTabela() {
        if (this.ingredientes == null) {
            this.ingredientes = new ArrayList();
        }
        ObservableList lista = FXCollections.observableArrayList((Collection)this.ingredientes);
        this.tabelaIngredientes.setItems(lista);
    }

    private void addCategoria() {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/categoriaProduto/CategoriaProdutoForm.fxml", "Cadastro de Categoria de Produto");
            CategoriaProdutoFormController controller = (CategoriaProdutoFormController)form.getUserData();
            controller.inicializa(null);
            form.showAndWait();
            this.cbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.list()));
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoRegimeNormalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de cadastro de categoria de produto.");
        }
    }

    private void calculaPrecoVenda() {
        BigDecimal precoCusto = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoCusto.getText());
        BigDecimal margem = MaximaNumber.moneyToBigDecimal((String)this.tfMargemCusto.getText());
        if (precoCusto == null || margem == null || precoCusto.compareTo(BigDecimal.ZERO) <= 0 || margem.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfPrecoVenda.setText("0,00");
            return;
        }
        BigDecimal precoVenda = precoCusto.add(precoCusto.multiply(margem.divide(new BigDecimal(100), 2, RoundingMode.HALF_EVEN))).setScale(2, RoundingMode.HALF_EVEN);
        this.tfPrecoVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)precoVenda, (int)2));
    }

    private void calculaMargem() {
        BigDecimal precoCusto = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoCusto.getText());
        BigDecimal precoVenda = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText());
        if (precoCusto == null || precoVenda == null || precoCusto.compareTo(BigDecimal.ZERO) <= 0 || precoVenda.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfMargemCusto.setText("0,00");
            this.tfMargemVenda.setText("0,00");
            return;
        }
        BigDecimal margemCusto = precoVenda.subtract(precoCusto).multiply(new BigDecimal("100")).divide(precoCusto, 2, RoundingMode.HALF_EVEN);
        BigDecimal lucro = precoVenda.subtract(precoCusto);
        BigDecimal margemVenda = lucro.multiply(new BigDecimal("100")).divide(precoVenda, 2, RoundingMode.UP);
        this.tfMargemCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemCusto, (int)2));
        this.tfMargemVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemVenda, (int)2));
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.produto.getNome() == null || this.produto.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getCategoriaProduto() == null) {
            this.cbCategoria.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbCategoria.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getUnidade() == null) {
            this.cbUnidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbUnidade.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getCodigo() == null || this.produto.getCodigo().isEmpty()) {
            this.tfCodigoBarras.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigoBarras.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (this.conf.getProdutoFiscal().booleanValue() && !this.produto.getServico().booleanValue()) {
                if (this.produto.getNcm() == null || this.produto.getNcm().isEmpty()) {
                    this.tabPane.getSelectionModel().select((Object)this.tabFiscal);
                    this.tfCodigoNcm.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    try {
                        Ncm ncm = this.ncmService.loadByNCM(Long.parseLong(this.produto.getNcm()));
                        if (ncm == null) {
                            MaximaAlert.aviso((StageManager)this.stageManager, (String)"NCM informado n\u00e3o \u00e9 v\u00e1lido");
                            this.tfCodigoNcm.getStyleClass().add((Object)"error");
                            valido = false;
                        } else {
                            this.tfCodigoNcm.getStyleClass().remove((Object)"error");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        MaximaAlert.aviso((StageManager)this.stageManager, (String)"NCM informado n\u00e3o \u00e9 v\u00e1lido");
                        this.tfCodigoNcm.getStyleClass().add((Object)"error");
                    }
                    this.tfCodigoNcm.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getCfop() == null || this.produto.getCfop().length() != 4) {
                    this.tfCfopDentroEstado.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.tfCfopDentroEstado.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getOrigem() == null) {
                    this.cbOrigem.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbOrigem.getStyleClass().remove((Object)"error");
                }
                if (this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
                    if (this.produto.getIcmsSN() == null) {
                        this.cbCSOSN.getStyleClass().add((Object)"error");
                        valido = false;
                    } else {
                        this.cbCSOSN.getStyleClass().remove((Object)"error");
                    }
                } else if (this.produto.getTributacaoICMS() == null) {
                    this.cbCSOSN.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbCSOSN.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getPis() == null) {
                    this.cbPis.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbPis.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getCofins() == null) {
                    this.cbCofins.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbCofins.getStyleClass().remove((Object)"error");
                }
            } else if (this.produto.getNcm() == null || this.produto.getNcm().isEmpty()) {
                this.produto.setNcm("00000000");
            }
        }
        return valido;
    }
}

