/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.HtmlEditorController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.estoque.controller.VendaProdutoController;
import br.com.maximasolutions.estoque.controller.VendaProdutoViewController;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendaProdutoController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnVisualiza;
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnDeleteVenda;
    @FXML
    private Button btnEmail;
    @FXML
    private Button btnAgrupa;
    @FXML
    private TableView<VendaProduto> tabela;
    @FXML
    private TableColumn<VendaProduto, String> colCliente;
    @FXML
    private TableColumn<VendaProduto, String> colCodigo;
    @FXML
    private TableColumn<VendaProduto, String> colObservacao;
    @FXML
    private TableColumn<VendaProduto, String> colData;
    @FXML
    private TableColumn<VendaProduto, String> colDataFat;
    @FXML
    private TableColumn<VendaProduto, String> colVendedor;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colTotal;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colLiquido;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label labelTotal;
    @FXML
    private Label labelQuantidade;
    @FXML
    private Label labelLiquido;
    @FXML
    private CheckBox ccbFaturado;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<VendaProduto> vendaProdutoList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)LocalDate.now());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.vendaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.VendaProduto);
        this.loadTabela();
        this.registraAcoes();
    }

    private void deleteFaturamento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        VendaProduto venda = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (venda == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma venda para excluir o faturamento.");
            return;
        }
        if (!(venda = this.vendaProdutoService.getById(venda.getId())).isAtivo().booleanValue() || venda.isExcluida().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Venda exclu\u00edda do sistema.\nN\u00e3o \u00e9 poss\u00edvel excluir o faturamento.");
            return;
        }
        if (!venda.isFaturado().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Venda n\u00e3o faturada.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Essa opera\u00e7\u00e3o ir\u00e1 excluir todas parcelas e recebimentos da venda.\nTem certeza que deseja continuar?")) {
            return;
        }
        try {
            this.vendaProdutoService.deleteFaturamento(venda, Boolean.valueOf(false));
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Faturamento exclu\u00eddo com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void deleteVenda() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        VendaProduto venda = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (venda == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma venda para excluir.");
            return;
        }
        if (!(venda = this.vendaProdutoService.getById(venda.getId())).isAtivo().booleanValue() || venda.isExcluida().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Venda exclu\u00edda do sistema.\nN\u00e3o \u00e9 poss\u00edvel excluir o faturamento.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Essa opera\u00e7\u00e3o ir\u00e1 excluir todas informa\u00e7\u00f5es da venda: estoque e financeiro.\nTem certeza que deseja continuar?")) {
            return;
        }
        try {
            this.vendaProdutoService.delete(venda);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Venda exclu\u00edda com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void visualiza() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
        try {
            Stage vendaProdutoView = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.tabela.getScene().getWindow(), "/fxml/estoque/vendaProduto/VendaProdutoView.fxml", "Visualiza\u00e7\u00e3o de Venda");
            VendaProdutoViewController controller = (VendaProdutoViewController)vendaProdutoView.getUserData();
            controller.inicializa(vendaProduto);
            vendaProdutoView.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel visualziar a venda.");
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataHora"));
        this.colDataFat.setCellValueFactory((Callback)new PropertyValueFactory("dataFaturamento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colVendedor.setCellValueFactory((Callback)new PropertyValueFactory("vendedor"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colLiquido.setCellValueFactory((Callback)new PropertyValueFactory("totalLiquido"));
        this.colDataFat.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colLiquido.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private void loadTabela() {
        this.vendaProdutoList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "";
        List list = this.vendaProdutoService.lista(inicio, fim, Boolean.valueOf(this.ccbFaturado.isSelected()), Boolean.valueOf(this.ccbExcluida.isSelected()), filtro);
        this.vendaProdutoList.addAll((Collection)list);
        this.tabela.setItems(this.vendaProdutoList);
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal faturado = BigDecimal.ZERO;
        for (VendaProduto venda : this.vendaProdutoList) {
            total = total.add(venda.getTotal());
            faturado = faturado.add(venda.getTotalLiquido());
        }
        if (PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            this.labelTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
            this.labelLiquido.setText(MaximaNumber.bigDecimalToString((BigDecimal)faturado, (int)2));
            this.labelQuantidade.setText(MaximaUtils.completaZeroEsquerda((String)String.valueOf(this.vendaProdutoList.size()), (Integer)3));
        } else {
            this.labelTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)BigDecimal.ZERO, (int)2));
            this.labelLiquido.setText(MaximaNumber.bigDecimalToString((BigDecimal)BigDecimal.ZERO, (int)2));
            this.labelQuantidade.setText(MaximaUtils.completaZeroEsquerda((String)String.valueOf(0), (Integer)3));
        }
    }

    private void carregaIcones() {
        this.btnVisualiza.setGraphic((Node)new MaximaIcone().iconeVisualizar());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void email() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Selecione uma venda para enviar por e-mail.");
            return;
        }
        if (vendaProduto.isExcluida().booleanValue() || !vendaProduto.isAtivo().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o \u00e9 permitido o envio de venda exclu\u00edda.");
            return;
        }
        String emailCliente = vendaProduto.getCliente().getEmail();
        if (emailCliente == null || emailCliente.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: E-mail n\u00e3o cadastrado para o cliente.");
            return;
        }
        String textoHtml = "";
        try {
            Stage htmlEditor = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/HtmlEditor.fxml", "Conte\u00fado E-mail");
            HtmlEditorController htmlEditorController = (HtmlEditorController)htmlEditor.getUserData();
            htmlEditorController.inicializa();
            htmlEditor.showAndWait();
            textoHtml = htmlEditorController.getTextoHtml();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
        }
        List itens = this.vendaProdutoService.listItens(vendaProduto);
        List parcelas = this.vendaProdutoService.listParcelas(vendaProduto);
        List faturamentos = this.vendaProdutoService.listaFaturamentos(vendaProduto);
        String arquivoDestino = "Pedido-" + vendaProduto.getId() + ".pdf";
        Stage progress = new MaximaDialogFX().progress(this.stageManager, "Enviando pedido por e-mail.......");
        progress.show();
        this.enviaPedidoEmail(progress, vendaProduto, itens, faturamentos, parcelas, arquivoDestino, textoHtml);
    }

    private void enviaPedidoEmail(Stage progress, VendaProduto vendaProduto, List<VendaProdutoItem> itens, List<VendaProdutoFaturamento> faturamentos, List<ContaReceberParcela> parcelas, String arquivoDestino, String textoHtml) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$enviaPedidoEmail$1(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {});
        service.start();
    }

    private void agrupaVendas() {
        ObservableList vendas = this.tabela.getSelectionModel().getSelectedItems();
        if (vendas == null || vendas.size() < 2) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione ao menos dois pedidos para agrupar.");
            return;
        }
        String mensagemErro = "";
        Long clienteId = null;
        for (VendaProduto venda : vendas) {
            if (clienteId == null) {
                clienteId = venda.getCliente().getId();
            }
            if (clienteId != venda.getCliente().getId()) {
                mensagemErro = "Pedidos com clientes diferentes. N\u00e3o pode ser agrupado.";
                break;
            }
            if (!venda.isFaturado().booleanValue()) continue;
            mensagemErro = "Pedido '" + venda.getId() + "' j\u00e1 faturado. N\u00e3o pode ser agrupado.";
            break;
        }
        if (!mensagemErro.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemErro);
            return;
        }
        try {
            this.vendaProdutoService.agrupa((List)vendas);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Vendas agrupadas com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel agrupar os pedidos.\n" + ex.getMessage()));
        }
    }

    private void registraAcoes() {
        this.btnAgrupa.setOnAction(evt -> this.agrupaVendas());
        this.btnDeleteVenda.setOnAction(evt -> this.deleteVenda());
        this.btnVisualiza.setOnAction(event -> this.visualiza());
        this.btnImprime.setOnAction(evt -> this.imprime());
        this.btnEmail.setOnAction(evt -> this.email());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private void imprime() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Selecione uma venda para imprimir.");
            return;
        }
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Erro ao imprimir venda.\n" + ex.getMessage()));
        }
    }

    private /* synthetic */ void lambda$enviaPedidoEmail$1(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ Configuracao access$000(VendaProdutoController x0) {
        return x0.conf;
    }
}

