/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class VendaProdutoEmail {
    public static void sendMail(VendaProduto vendaProduto, String arquivo, Configuracao conf, String textoHtml) throws MaximaException {
        String username = conf.getEmail();
        String password = conf.getEmailSenha();
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", conf.getEmailHost());
        props.put("mail.smtp.port", conf.getEmailPorta());
        props.put("mail.smtp.ssl.protocols", "TLSv1.2");
        Session session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(username));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(vendaProduto.getCliente().getEmail(), vendaProduto.getCliente().getNome()));
            msg.setSubject("Pedido: " + vendaProduto.getId());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(arquivo);
            messageBodyPart.setContent((Object)textoHtml, "text/html; charset=utf-8");
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("Pedido-" + vendaProduto.getId() + ".pdf");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            throw new MaximaException("Ops, falha ao enviar e-mail. " + e.getMessage());
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new MaximaException("Ops, falha ao enviar e-mail. " + e.getMessage());
        }
    }
}

