/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.service.SatCFeService;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendaProdutoOSController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImprimeVenda;
    @FXML
    private Button btnImprimeOS;
    @FXML
    private Button btnFechar;
    @FXML
    private TableView<VendaProduto> tabela;
    @FXML
    private TableColumn<VendaProduto, String> colCliente;
    @FXML
    private TableColumn<VendaProduto, String> colCodigo;
    @FXML
    private TableColumn<VendaProduto, String> colObservacao;
    @FXML
    private TableColumn<VendaProduto, String> colData;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private NcmService ncmService;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private NFCeService nFCeService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    private ObservableList<VendaProduto> vendaProdutoList;
    private ControleSAT controleSAT;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.vendaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa(ControleSAT controleSAT, Configuracao configuracao) {
        this.controleSAT = controleSAT;
        this.conf = configuracao;
    }

    private void imprimeVendaSelecionada() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoOSController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void imprimeOS() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
        try {
            this.vendaProdutoService.imprimeOS(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoOSController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataHora"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setRowFactory(tv -> new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadTabela() {
        this.vendaProdutoList.clear();
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")));
        if (movimentoCaixa != null) {
            List list = this.vendaProdutoService.listaPorMovimentoCaixaSemFaturar(movimentoCaixa);
            this.vendaProdutoList.addAll((Collection)list);
        }
        this.tabela.setItems(this.vendaProdutoList);
    }

    private void carregaIcones() {
        this.btnImprimeOS.setGraphic((Node)new MaximaIcone().print());
        this.btnImprimeVenda.setGraphic((Node)new MaximaIcone().print());
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnImprimeVenda.setOnAction(event -> this.imprimeVendaSelecionada());
        this.btnImprimeOS.setOnAction(event -> this.imprimeOS());
        this.btnFechar.setOnAction(evt -> this.fecharForm());
    }

    private void fecharForm() {
        Stage stage = (Stage)this.btnFechar.getScene().getWindow();
        stage.close();
    }
}

