/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.bean.VendaProdutoFaturamentoTableBean;
import br.com.maximasolutions.estoque.modelo.EntradaProdutoItem;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendaProdutoViewController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private UsuarioService usuarioService;
    private VendaProduto vendaProduto;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfClienteNome;
    @FXML
    private TextField tfDataEmissao;
    @FXML
    private TextField tfDataFaturamento;
    @FXML
    private TextField tfClienteCnpj;
    @FXML
    private TextField tfClienteInscricaoEstadual;
    @FXML
    private TextField tfClienteEndereco;
    @FXML
    private TextField tfClienteTelefone;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorServicos;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfValorBruto;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfVendedor;
    @FXML
    private TextField tfValorCusto;
    @FXML
    private TextField tfValorMargem;
    @FXML
    private TextField tfValorLucro;
    @FXML
    private Button btnFechar;
    @FXML
    private TableView<VendaProdutoItem> tabela;
    @FXML
    private TableColumn<VendaProdutoItem, String> colProduto;
    @FXML
    private TableColumn<VendaProdutoItem, String> colCodigo;
    @FXML
    private TableColumn<VendaProdutoItem, String> colItem;
    @FXML
    private TableColumn<VendaProdutoItem, String> colFuncionario;
    @FXML
    private TableColumn<VendaProdutoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<VendaProdutoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<VendaProdutoItem, BigDecimal> colDesconto;
    @FXML
    private TableColumn<VendaProdutoItem, BigDecimal> colTotalItem;
    @FXML
    private TableView<VendaProdutoFaturamentoTableBean> tabelaFaturamento;
    @FXML
    private TableColumn<VendaProdutoFaturamentoTableBean, String> colFaturamentoDescricao;
    @FXML
    private TableColumn<VendaProdutoFaturamentoTableBean, BigDecimal> colFaturamentoValor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.VendaProduto);
    }

    public void inicializa(VendaProduto vendaProduto) {
        this.vendaProduto = vendaProduto;
        this.carregaDadosVendaProduto();
    }

    private void carregaDadosVendaProduto() {
        if (this.vendaProduto == null) {
            return;
        }
        this.vendaProduto = this.vendaProdutoService.getById(this.vendaProduto.getId());
        List itens = this.vendaProdutoService.listItens(this.vendaProduto);
        Collections.sort(itens, Comparator.comparing(VendaProdutoItem::getServico));
        this.tfId.setText(this.vendaProduto.getId().toString());
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)this.vendaProduto.getDataEmissao()));
        this.tfDataFaturamento.setText(MaximaDate.getDataHora((LocalDateTime)this.vendaProduto.getDataOperacao()));
        Vendedor vendedor = this.vendaProduto.getVendedor();
        if (vendedor != null) {
            this.tfVendedor.setText(vendedor.getNome().toUpperCase());
        }
        this.tfClienteNome.setText(this.vendaProduto.getCliente().getNome().toUpperCase());
        this.tfClienteCnpj.setText(this.vendaProduto.getCliente().getCpf());
        this.tfClienteInscricaoEstadual.setText(this.vendaProduto.getCliente().getRg());
        this.tfClienteEndereco.setText(this.vendaProduto.getCliente().getEnderecoCompleto());
        this.tfClienteTelefone.setText(this.vendaProduto.getCliente().getTelefone());
        this.tfObservacao.setText(this.vendaProduto.getObservacao());
        this.loadTabela(itens);
        BigDecimal valorProdutos = BigDecimal.ZERO;
        BigDecimal valorServicos = BigDecimal.ZERO;
        for (VendaProdutoItem item : itens) {
            if (item.getServico().booleanValue()) {
                valorServicos = valorServicos.add(item.getPrecoTotal());
                continue;
            }
            valorProdutos = valorProdutos.add(item.getPrecoTotal());
        }
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorProdutos, (int)2));
        this.tfValorServicos.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorServicos, (int)2));
        this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.vendaProduto.getDesconto(), (int)2));
        String valorTotal = MaximaNumber.bigDecimalToString((BigDecimal)this.vendaProduto.getTotal(), (int)2);
        if (this.vendaProduto.getTotal().compareTo(this.vendaProduto.getTotalLiquido()) != 0) {
            valorTotal = valorTotal + " | " + MaximaNumber.bigDecimalToString((BigDecimal)this.vendaProduto.getTotalLiquido(), (int)2);
        }
        this.tfValorTotal.setText(valorTotal);
        this.tfValorBruto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.vendaProduto.getValorProdutos(), (int)2));
        if (PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            this.tfValorCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.vendaProduto.getCustoTotal(), (int)2));
            BigDecimal valorLucro = this.vendaProduto.getTotalLiquido().subtract(this.vendaProduto.getCustoTotal());
            this.tfValorLucro.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorLucro, (int)2));
            BigDecimal margemLucro = BigDecimal.ZERO;
            if (this.vendaProduto.getTotal().compareTo(BigDecimal.ZERO) > 0) {
                margemLucro = valorLucro.multiply(new BigDecimal(100)).divide(this.vendaProduto.getTotal(), 2, RoundingMode.HALF_EVEN);
            }
            this.tfValorMargem.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemLucro, (int)2));
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigoProduto"));
        this.colFuncionario.setCellValueFactory((Callback)new PropertyValueFactory("funcionario"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colDesconto.setCellValueFactory((Callback)new PropertyValueFactory("desconto"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colFaturamentoDescricao.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colFaturamentoValor.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colDesconto.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colFaturamentoValor.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setContextMenu(this.getTableMenu());
    }

    private void loadTabela(List<VendaProdutoItem> itens) {
        if (this.vendaProduto.getEntradaProduto() != null) {
            List entradaItens = this.entradaProdutoService.listItens(this.vendaProduto.getEntradaProduto());
            for (EntradaProdutoItem epi : entradaItens) {
                VendaProdutoItem item = new VendaProdutoItem();
                item.setProduto(epi.getProduto());
                item.setDescricao(epi.getDescricao());
                item.setQuantidade(epi.getQuantidade());
                item.setPrecoUnitario(epi.getPrecoCusto());
                item.setPrecoTotal(epi.getTotalCusto());
                item.setDesconto(BigDecimal.ZERO);
                itens.add(item);
            }
        }
        ObservableList pedidoItemList = FXCollections.observableArrayList();
        pedidoItemList.clear();
        pedidoItemList.addAll(itens);
        this.tabela.setItems(FXCollections.observableArrayList((Collection)pedidoItemList));
        List faturamentoLista = this.vendaProdutoService.listaFaturamentos(this.vendaProduto);
        ArrayList lista = new ArrayList();
        if (faturamentoLista != null && !faturamentoLista.isEmpty()) {
            faturamentoLista.forEach(fat -> lista.add(new VendaProdutoFaturamentoTableBean(fat.getCondicaoRecebimento().getNome(), fat.getValor())));
        } else {
            List parcelas = this.vendaProdutoService.listParcelas(this.vendaProduto);
            parcelas.forEach(parc -> lista.add(new VendaProdutoFaturamentoTableBean(parc.getFormaPagamento().getDescricao(), parc.getValor())));
        }
        this.tabelaFaturamento.setItems(FXCollections.observableArrayList(lista));
    }

    private void carregaIcones() {
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void fechar() {
        Stage stage = (Stage)this.anchorPane.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.fechar());
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Copiar descri\u00e7\u00e3o");
        menuEdita.setOnAction(event -> {
            VendaProdutoItem item = (VendaProdutoItem)this.tabela.getSelectionModel().getSelectedItem();
            if (item == null) {
                return;
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(item.getDescricaoCompleta());
            clipboard.setContents(stringSelection, null);
        });
        cm.getItems().add((Object)menuEdita);
        return cm;
    }
}

