/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.dino.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.delivery.modelo.Entregador;
import br.com.maximasolutions.food.service.EntregadorService;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVDinoEntregadorController
extends MaximaController
implements Initializable {
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private Button btnFechar;
    @FXML
    private Button btnFinalizar;
    @FXML
    private ComboBox<Entregador> comboEntregador;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EntregadorService entregadorService;
    private Entregador entregador;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa() {
        this.entregador = null;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFechar.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnFinalizar.setGraphic((Node)maximaIcone.icone_confirma_48());
    }

    public Entregador getEntregador() {
        return this.entregador;
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> {
            this.entregador = null;
            this.fechaForm();
        });
        this.btnFinalizar.setOnAction(evt -> {
            this.entregador = (Entregador)this.comboEntregador.getSelectionModel().getSelectedItem();
            this.fechaForm();
        });
    }

    private void carregaCombos() {
        this.comboEntregador.setItems(FXCollections.observableArrayList((Collection)this.entregadorService.listaPorNome("", true)));
    }

    private void fechaForm() {
        Stage form = (Stage)this.anchorPane.getScene().getWindow();
        form.close();
    }
}

