/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.relatorio.dto.VendaProdutoGraficoDto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class GraficoVendaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ClienteService clienteService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfClientePesquisa;
    @FXML
    private TextField tfClienteNome;
    @FXML
    private CheckBox ccbFaturadas;
    @FXML
    private Pane paneGrafico;
    private BigDecimal total;
    private BigDecimal produtos;
    private BigDecimal produtosCusto;
    private BigDecimal servicos;
    private BigDecimal servicosCusto;
    private BigDecimal totalCusto;
    private BigDecimal desconto;
    private Cliente cliente;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.cliente = null;
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        LocalDate dataInicial = (LocalDate)this.tfDataInicial.getValue();
        LocalDate dataFinal = (LocalDate)this.tfDataFinal.getValue();
        if (dataFinal.getDayOfYear() - dataInicial.getDayOfYear() > 31) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Per\u00edodo de 31 dias \u00e9 o m\u00e1ximo permitido.");
            return;
        }
        List vendas = this.vendaProdutoService.grafico(dataInicial, dataFinal, Boolean.valueOf(this.ccbFaturadas.isSelected()), this.cliente);
        if (vendas == null || vendas.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        CategoryAxis xAxis = new CategoryAxis();
        xAxis.setLabel("Data");
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("Valor");
        LineChart lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        lineChart.setTitle("Vendas por per\u00edodo");
        lineChart.setPrefWidth(950.0);
        XYChart.Series data = new XYChart.Series();
        for (VendaProdutoGraficoDto dto : vendas) {
            data.getData().add((Object)new XYChart.Data((Object)dto.getDataEmissao().format(DateTimeFormatter.ofPattern("dd/MM")), (Object)dto.getValor()));
        }
        lineChart.getData().add((Object)data);
        this.paneGrafico.getChildren().add((Object)lineChart);
    }

    private void calculaTotal(List<VendaProduto> vendas) {
        this.produtos = BigDecimal.ZERO;
        this.produtosCusto = BigDecimal.ZERO;
        this.servicos = BigDecimal.ZERO;
        this.servicosCusto = BigDecimal.ZERO;
        this.desconto = BigDecimal.ZERO;
        this.total = BigDecimal.ZERO;
        this.totalCusto = BigDecimal.ZERO;
        vendas.stream().forEachOrdered(venda -> {
            this.produtos = this.produtos.add(venda.getValorPecas());
            this.produtosCusto = this.produtosCusto.add(venda.getCustoProdutos());
            this.servicos = this.servicos.add(venda.getValorServico());
            this.servicosCusto = this.servicosCusto.add(venda.getCustoServicos());
            this.desconto = this.desconto.add(venda.getDesconto());
            this.total = this.total.add(venda.getTotal());
            this.totalCusto = this.totalCusto.add(venda.getCustoTotal());
            BigDecimal valida = venda.getValorPecas().add(venda.getValorServico());
            if (venda.getTotal().compareTo(valida) != 0) {
                System.out.println("== VENDA: " + venda.getId() + " | " + valida + "  x  " + venda.getTotal());
            }
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnClientePesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.tfClientePesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnClientePesquisa.setOnAction(event -> this.pesquisaClienteForm());
    }

    private void loadCombos() {
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClientePesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
            } else {
                this.cliente = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                this.tfClientePesquisa.requestFocus();
                this.tfClientePesquisa.selectAll();
            }
            this.loadDadosCliente();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaClienteForm();
            return;
        }
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), this.tfClientePesquisa.getText().trim());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClientePesquisa.setText(this.cliente.getId().toString());
            this.tfClienteNome.setText(this.cliente.getNome().toUpperCase());
        } else {
            this.tfClienteNome.setText("");
            this.tfClientePesquisa.setText("");
            this.tfClientePesquisa.requestFocus();
        }
    }
}

