/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.geral.controller.FornecedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioCompraController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private FornecedorService fornecedorService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnFornecedorPesquisa;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfFornecedorPesquisa;
    @FXML
    private TextField tfFornecedorNome;
    private BigDecimal total;
    private BigDecimal produtos;
    private BigDecimal desconto;
    private Fornecedor fornecedor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.fornecedor = null;
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        List compras = this.entradaProdutoService.relatorio((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), this.fornecedor);
        if (compras == null || compras.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(compras);
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            params.put("TELEFONE", conf.getTelefoneEmpresa());
            params.put("CNPJ", conf.getEmpresaNFe().getCpf());
            params.put("ENDERECO", conf.getEmpresaNFe().getEnderecoCompleto());
            params.put("Logo", "logo.png");
            params.put("FILTRO", "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            params.put("PRODUTOS", this.produtos);
            params.put("DESCONTO", this.desconto);
            params.put("TOTAL", this.total);
            params.put("COMPRAS", compras.size());
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)compras);
            new PrintReport().showReport("/jasper/estoque/entradaProduto/compras.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioCompraController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<EntradaProduto> compras) {
        this.produtos = BigDecimal.ZERO;
        this.desconto = BigDecimal.ZERO;
        this.total = BigDecimal.ZERO;
        compras.stream().forEachOrdered(compra -> {
            this.produtos = this.produtos.add(compra.getValorProdutos());
            this.desconto = this.desconto.add(compra.getDesconto());
            this.total = this.total.add(compra.getTotal());
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnFornecedorPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.tfFornecedorPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaFornecedor();
            }
        });
        this.btnFornecedorPesquisa.setOnAction(event -> this.pesquisaFornecedorForm());
    }

    private void loadCombos() {
    }

    private void pesquisaFornecedor() {
        String fornecedorCodigo = this.tfFornecedorPesquisa.getText().trim();
        if (fornecedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long fornecedorCodigoNumero = Long.valueOf(fornecedorCodigo);
            Fornecedor fornecedorPesquisa = this.fornecedorService.getById(fornecedorCodigoNumero);
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
            } else {
                this.fornecedor = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de fornecedor n\u00e3o encontrado.");
                this.tfFornecedorPesquisa.requestFocus();
                this.tfFornecedorPesquisa.selectAll();
            }
            this.loadDadosFornecedor();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaFornecedorForm();
            return;
        }
    }

    private void pesquisaFornecedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorPesquisa.fxml", "Pesquisa de fornecedor");
            FornecedorPesquisaController controller = (FornecedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfFornecedorPesquisa.getText().trim());
            stage.showAndWait();
            Fornecedor fornecedorPesquisa = controller.getFornecedorSelecionado();
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'FornecedorPesquisa'");
        }
    }

    private void loadDadosFornecedor() {
        if (this.fornecedor != null) {
            this.tfFornecedorPesquisa.setText(this.fornecedor.getId().toString());
            this.tfFornecedorNome.setText(this.fornecedor.getNome().toUpperCase());
        } else {
            this.tfFornecedorNome.setText("");
            this.tfFornecedorPesquisa.setText("");
            this.tfFornecedorPesquisa.requestFocus();
        }
    }
}

