/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.bean.EntradaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.bean.RelatorioEntradaProdutoItemBean;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioCompraProdutoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private CheckBox ccbAgruparProdutos;
    @FXML
    private ComboBox<CategoriaProduto> cbbCategoria;
    @FXML
    private ComboBox<EntradaProdutoItemOrderBy> cbbOrderBy;
    private BigDecimal quantidade;
    private BigDecimal total;
    private BigDecimal precoMedio;
    private Integer produtos;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    private void habilitaForm() {
        if (this.ccbAgruparProdutos.isSelected()) {
            this.cbbOrderBy.getSelectionModel().select((Object)EntradaProdutoItemOrderBy.PRODUTO);
            this.cbbOrderBy.setDisable(true);
        } else {
            this.cbbOrderBy.getSelectionModel().select((Object)EntradaProdutoItemOrderBy.DATA);
            this.cbbOrderBy.setDisable(false);
        }
    }

    public void inicializa() {
        this.habilitaForm();
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        Boolean agruparProdutos = this.ccbAgruparProdutos.isSelected();
        List itens = this.entradaProdutoService.relatorioProdutos((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), null, (CategoriaProduto)this.cbbCategoria.getSelectionModel().getSelectedItem(), agruparProdutos, (EntradaProdutoItemOrderBy)this.cbbOrderBy.getSelectionModel().getSelectedItem());
        if (itens == null || itens.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(itens);
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            String filtro = "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            params.put("FILTRO", filtro);
            params.put("QUANTIDADE", this.quantidade);
            params.put("PRODUTOS", this.produtos);
            params.put("TOTAL", this.total);
            params.put("PRECO_MEDIO", this.precoMedio);
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)itens);
            String jasper = agruparProdutos != false ? "compras-produtos-agrupados.jasper" : "compras-produtos.jasper";
            new PrintReport().showReport("/jasper/estoque/entradaProduto/" + jasper, (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioCompraProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<RelatorioEntradaProdutoItemBean> itens) {
        this.total = BigDecimal.ZERO;
        this.quantidade = BigDecimal.ZERO;
        this.precoMedio = BigDecimal.ZERO;
        this.produtos = 0;
        ArrayList produtosAdicionados = new ArrayList();
        itens.stream().forEachOrdered(bean -> {
            this.quantidade = this.quantidade.add(bean.getQuantidade());
            this.total = this.total.add(bean.getTotal());
            this.precoMedio = this.precoMedio.add(bean.getValorMedio());
            boolean existe = false;
            for (RelatorioEntradaProdutoItemBean b : produtosAdicionados) {
                if (!bean.getProdutoId().equals(b.getProdutoId())) continue;
                existe = true;
                break;
            }
            if (!existe) {
                produtosAdicionados.add(bean);
            }
        });
        this.produtos = produtosAdicionados.size();
        this.precoMedio = this.precoMedio.divide(new BigDecimal(itens.size()), 2, RoundingMode.HALF_EVEN);
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.ccbAgruparProdutos.setOnAction(evt -> this.habilitaForm());
    }

    private void loadCombos() {
        this.cbbCategoria.setItems(FXCollections.observableList((List)this.categoriaProdutoService.combo()));
        this.cbbOrderBy.setItems(FXCollections.observableArrayList((Object[])EntradaProdutoItemOrderBy.values()));
    }
}

